/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.EncodingParameters;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalAudioTrackPublication;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalDataTrackPublication;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.LocalVideoTrackPublication;
import com.twilio.video.Logger;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPublication;
import com.twilio.video.VideoTrackPublication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LocalParticipant
implements Participant {
    private static final Logger logger = Logger.getLogger(LocalParticipant.class);
    private long nativeLocalParticipantHandle;
    private final String sid;
    private final String identity;
    private final List<AudioTrackPublication> audioTrackPublications;
    private final List<LocalAudioTrackPublication> localAudioTrackPublications;
    private final List<VideoTrackPublication> videoTrackPublications;
    private final List<LocalVideoTrackPublication> localVideoTrackPublications;
    private final List<DataTrackPublication> dataTrackPublications;
    private final List<LocalDataTrackPublication> localDataTrackPublications;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    private final Listener localParticipantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackPublished(final LocalParticipant localParticipant, final LocalAudioTrackPublication localAudioTrackPublication) {
            this.checkCallback(localParticipant, localAudioTrackPublication, "onAudioTrackPublished");
            LocalParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackPublished");
                    LocalParticipant.this.audioTrackPublications.add(localAudioTrackPublication);
                    LocalParticipant.this.localAudioTrackPublications.add(localAudioTrackPublication);
                    Listener listener = (Listener)LocalParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackPublished(localParticipant, localAudioTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackPublished(final LocalParticipant localParticipant, final LocalVideoTrackPublication localVideoTrackPublication) {
            this.checkCallback(localParticipant, localVideoTrackPublication, "onVideoTrackPublished");
            LocalParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackPublished");
                    LocalParticipant.this.videoTrackPublications.add(localVideoTrackPublication);
                    LocalParticipant.this.localVideoTrackPublications.add(localVideoTrackPublication);
                    Listener listener = (Listener)LocalParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackPublished(localParticipant, localVideoTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onDataTrackPublished(final LocalParticipant localParticipant, final LocalDataTrackPublication localDataTrackPublication) {
            this.checkCallback(localParticipant, localDataTrackPublication, "onDataTrackPublished");
            LocalParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onDataTrackPublished");
                    LocalParticipant.this.dataTrackPublications.add(localDataTrackPublication);
                    LocalParticipant.this.localDataTrackPublications.add(localDataTrackPublication);
                    Listener listener = (Listener)LocalParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onDataTrackPublished(localParticipant, localDataTrackPublication);
                    }
                }
            });
        }

        private void checkCallback(LocalParticipant localParticipant, TrackPublication track, String callback) {
            Preconditions.checkState(localParticipant != null, "Received null local participant in %s", (Object)callback);
            Preconditions.checkState(track != null, "Received null track in %s", (Object)callback);
        }
    };

    @Override
    public String getSid() {
        return this.sid;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public synchronized List<AudioTrackPublication> getAudioTracks() {
        return Collections.unmodifiableList(this.audioTrackPublications);
    }

    @Override
    public synchronized List<VideoTrackPublication> getVideoTracks() {
        return Collections.unmodifiableList(this.videoTrackPublications);
    }

    @Override
    public synchronized List<DataTrackPublication> getDataTracks() {
        return Collections.unmodifiableList(this.dataTrackPublications);
    }

    public synchronized List<LocalAudioTrackPublication> getLocalAudioTracks() {
        return Collections.unmodifiableList(this.localAudioTrackPublications);
    }

    public synchronized List<LocalVideoTrackPublication> getLocalVideoTracks() {
        return Collections.unmodifiableList(this.localVideoTrackPublications);
    }

    public synchronized List<LocalDataTrackPublication> getLocalDataTracks() {
        return Collections.unmodifiableList(this.localDataTrackPublications);
    }

    public synchronized boolean publishTrack(@NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        return this.nativePublishAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack, localAudioTrack.getNativeHandle());
    }

    public synchronized boolean publishTrack(@NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        return this.nativePublishVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack, localVideoTrack.getNativeHandle());
    }

    public synchronized boolean publishTrack(@NonNull LocalDataTrack localDataTrack) {
        Preconditions.checkNotNull(localDataTrack, "LocalDataTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        return this.nativePublishDataTrack(this.nativeLocalParticipantHandle, localDataTrack, localDataTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedAudioTrack(localAudioTrack);
        return this.nativeUnpublishAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedVideoTrack(localVideoTrack);
        return this.nativeUnpublishVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack.getNativeHandle());
    }

    public synchronized boolean unpublishTrack(@NonNull LocalDataTrack localDataTrack) {
        Preconditions.checkNotNull(localDataTrack, "LocalDataTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        this.removePublishedDataTrack(localDataTrack);
        return this.nativeUnpublishDataTrack(this.nativeLocalParticipantHandle, localDataTrack.getNativeHandle());
    }

    public void setListener(@NonNull Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized void setEncodingParameters(@Nullable EncodingParameters encodingParameters) {
        if (!this.isReleased()) {
            this.nativeSetEncodingParameters(this.nativeLocalParticipantHandle, encodingParameters);
        } else {
            logger.w("Cannot set encoding parameters after disconnected from a room");
        }
    }

    LocalParticipant(long nativeLocalParticipantHandle, @NonNull String sid, @NonNull String identity, @NonNull List<LocalAudioTrackPublication> localAudioTrackPublications, @NonNull List<LocalVideoTrackPublication> localVideoTrackPublications, @NonNull List<LocalDataTrackPublication> localDataTrackPublications, @NonNull Handler handler) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(identity, "Identity must not be null");
        this.nativeLocalParticipantHandle = nativeLocalParticipantHandle;
        this.sid = sid;
        this.identity = identity;
        this.localAudioTrackPublications = localAudioTrackPublications;
        this.audioTrackPublications = new ArrayList<AudioTrackPublication>(localAudioTrackPublications.size());
        this.addAudioTracks(localAudioTrackPublications);
        this.localVideoTrackPublications = localVideoTrackPublications;
        this.videoTrackPublications = new ArrayList<VideoTrackPublication>(localVideoTrackPublications.size());
        this.addVideoTracks(localVideoTrackPublications);
        this.localDataTrackPublications = localDataTrackPublications;
        this.dataTrackPublications = new ArrayList<DataTrackPublication>(localDataTrackPublications.size());
        this.addDataTracks(localDataTrackPublications);
        this.handler = handler;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalParticipantHandle);
            this.nativeLocalParticipantHandle = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeLocalParticipantHandle == 0L;
    }

    private void addAudioTracks(List<LocalAudioTrackPublication> localAudioTrackPublications) {
        for (LocalAudioTrackPublication localAudioTrackPublication : localAudioTrackPublications) {
            this.audioTrackPublications.add(localAudioTrackPublication);
        }
    }

    private void addVideoTracks(List<LocalVideoTrackPublication> localVideoTrackPublications) {
        for (LocalVideoTrackPublication localVideoTrackPublication : localVideoTrackPublications) {
            this.videoTrackPublications.add(localVideoTrackPublication);
        }
    }

    private void addDataTracks(List<LocalDataTrackPublication> localDataTrackPublications) {
        for (LocalDataTrackPublication localDataTrackPublication : localDataTrackPublications) {
            this.dataTrackPublications.add(localDataTrackPublication);
        }
    }

    private void removePublishedAudioTrack(LocalAudioTrack localAudioTrack) {
        for (LocalAudioTrackPublication localAudioTrackPublication : this.localAudioTrackPublications) {
            if (!localAudioTrack.equals(localAudioTrackPublication.getLocalAudioTrack())) continue;
            this.audioTrackPublications.remove(localAudioTrackPublication);
            this.localAudioTrackPublications.remove(localAudioTrackPublication);
            return;
        }
    }

    private void removePublishedVideoTrack(LocalVideoTrack localVideoTrack) {
        for (LocalVideoTrackPublication localVideoTrackPublication : this.localVideoTrackPublications) {
            if (!localVideoTrack.equals(localVideoTrackPublication.getLocalVideoTrack())) continue;
            this.videoTrackPublications.remove(localVideoTrackPublication);
            this.localVideoTrackPublications.remove(localVideoTrackPublication);
            return;
        }
    }

    private void removePublishedDataTrack(LocalDataTrack localDataTrack) {
        for (LocalDataTrackPublication localDataTrackPublication : this.localDataTrackPublications) {
            if (!localDataTrack.equals(localDataTrackPublication.getLocalDataTrack())) continue;
            this.dataTrackPublications.remove(localDataTrackPublication);
            this.localDataTrackPublications.remove(localDataTrackPublication);
            return;
        }
    }

    private native boolean nativePublishAudioTrack(long var1, LocalAudioTrack var3, long var4);

    private native boolean nativePublishVideoTrack(long var1, LocalVideoTrack var3, long var4);

    private native boolean nativePublishDataTrack(long var1, LocalDataTrack var3, long var4);

    private native boolean nativeUnpublishAudioTrack(long var1, long var3);

    private native boolean nativeUnpublishVideoTrack(long var1, long var3);

    private native boolean nativeUnpublishDataTrack(long var1, long var3);

    private native void nativeSetEncodingParameters(long var1, EncodingParameters var3);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackPublished(LocalParticipant var1, LocalAudioTrackPublication var2);

        public void onVideoTrackPublished(LocalParticipant var1, LocalVideoTrackPublication var2);

        public void onDataTrackPublished(LocalParticipant var1, LocalDataTrackPublication var2);
    }
}

