/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.Logger;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteAudioTrack;
import com.twilio.video.RemoteAudioTrackPublication;
import com.twilio.video.RemoteVideoTrack;
import com.twilio.video.RemoteVideoTrackPublication;
import com.twilio.video.TrackPublication;
import com.twilio.video.VideoTrackPublication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteParticipant
implements Participant {
    private static final Logger logger = Logger.getLogger(RemoteParticipant.class);
    private final String identity;
    private final String sid;
    private final List<RemoteAudioTrackPublication> remoteAudioTrackPublications;
    private final List<AudioTrackPublication> audioTrackPublications;
    private final List<RemoteVideoTrackPublication> remoteVideoTrackPublications;
    private final List<VideoTrackPublication> videoTrackPublications;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    private final Listener participantListenerProxy = new Listener(){

        @Override
        public void onAudioTrackPublished(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackPublished");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackPublished");
                    RemoteParticipant.this.audioTrackPublications.add(remoteAudioTrackPublication);
                    RemoteParticipant.this.remoteAudioTrackPublications.add(remoteAudioTrackPublication);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackPublished(remoteParticipant, remoteAudioTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackUnpublished(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnpublished");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackUnpublished");
                    RemoteParticipant.this.audioTrackPublications.remove(remoteAudioTrackPublication);
                    RemoteParticipant.this.remoteAudioTrackPublications.remove(remoteAudioTrackPublication);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackUnpublished(remoteParticipant, remoteAudioTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackSubscribed(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication, final RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackSubscribed");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackSubscribed");
                    remoteAudioTrackPublication.setSubscribed(true);
                    remoteAudioTrackPublication.setRemoteAudioTrack(remoteAudioTrack);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackSubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackUnsubscribed(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication, final RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnsubscribed");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackUnsubscribed");
                    remoteAudioTrackPublication.setRemoteAudioTrack(null);
                    remoteAudioTrackPublication.setSubscribed(false);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackUnsubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackPublished(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackPublished");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackPublished");
                    RemoteParticipant.this.videoTrackPublications.add(remoteVideoTrackPublication);
                    RemoteParticipant.this.remoteVideoTrackPublications.add(remoteVideoTrackPublication);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackPublished(remoteParticipant, remoteVideoTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackUnpublished(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnpublished");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackUnpublished");
                    RemoteParticipant.this.videoTrackPublications.remove(remoteVideoTrackPublication);
                    RemoteParticipant.this.remoteVideoTrackPublications.remove(remoteVideoTrackPublication);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackUnpublished(remoteParticipant, remoteVideoTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackSubscribed(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication, final RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackSubscribed");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackSubscribed");
                    remoteVideoTrackPublication.setSubscribed(true);
                    remoteVideoTrackPublication.setRemoteVideoTrack(remoteVideoTrack);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackSubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackUnsubscribed(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication, final RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnsubscribed");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackUnsubscribed");
                    remoteVideoTrack.release();
                    remoteVideoTrackPublication.setRemoteVideoTrack(null);
                    remoteVideoTrackPublication.setSubscribed(false);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackUnsubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackEnabled(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackEnabled");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackEnabled");
                    remoteAudioTrackPublication.setEnabled(true);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackEnabled(remoteParticipant, remoteAudioTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onAudioTrackDisabled(final RemoteParticipant remoteParticipant, final RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackDisabled");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onAudioTrackDisabled");
                    remoteAudioTrackPublication.setEnabled(false);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onAudioTrackDisabled(remoteParticipant, remoteAudioTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackEnabled(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackEnabled");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackEnabled");
                    remoteVideoTrackPublication.setEnabled(true);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackEnabled(remoteParticipant, remoteVideoTrackPublication);
                    }
                }
            });
        }

        @Override
        public void onVideoTrackDisabled(final RemoteParticipant remoteParticipant, final RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackDisabled");
            RemoteParticipant.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    logger.d("onVideoTrackDisabled");
                    remoteVideoTrackPublication.setEnabled(false);
                    Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                    if (listener != null) {
                        listener.onVideoTrackDisabled(remoteParticipant, remoteVideoTrackPublication);
                    }
                }
            });
        }

        private void checkCallback(RemoteParticipant remoteParticipant, TrackPublication trackPublication, String callback) {
            Preconditions.checkState(remoteParticipant != null, "Received null remote participant in %s", (Object)callback);
            Preconditions.checkState(trackPublication != null, "Received null track publication in %s", (Object)callback);
        }
    };
    private long nativeParticipantContext;

    RemoteParticipant(String identity, String sid, List<RemoteAudioTrackPublication> remoteAudioTrackPublications, List<RemoteVideoTrackPublication> remoteVideoTrackPublications, Handler handler, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.remoteAudioTrackPublications = remoteAudioTrackPublications;
        this.audioTrackPublications = new ArrayList<AudioTrackPublication>(remoteAudioTrackPublications.size());
        this.addAudioTracks(remoteAudioTrackPublications);
        this.remoteVideoTrackPublications = remoteVideoTrackPublications;
        this.videoTrackPublications = new ArrayList<VideoTrackPublication>(remoteVideoTrackPublications.size());
        this.addVideoTracks(remoteVideoTrackPublications);
        this.handler = handler;
        this.nativeParticipantContext = nativeParticipantContext;
    }

    @Override
    public String getSid() {
        return this.sid;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public List<AudioTrackPublication> getAudioTracks() {
        return Collections.unmodifiableList(this.audioTrackPublications);
    }

    @Override
    public List<VideoTrackPublication> getVideoTracks() {
        return Collections.unmodifiableList(this.videoTrackPublications);
    }

    public List<RemoteAudioTrackPublication> getRemoteAudioTracks() {
        return Collections.unmodifiableList(this.remoteAudioTrackPublications);
    }

    public List<RemoteVideoTrackPublication> getRemoteVideoTracks() {
        return Collections.unmodifiableList(this.remoteVideoTrackPublications);
    }

    public void setListener(Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized boolean isConnected() {
        if (!this.isReleased()) {
            return this.nativeIsConnected(this.nativeParticipantContext);
        }
        return false;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            for (RemoteVideoTrackPublication remoteVideoTrackPublication : this.remoteVideoTrackPublications) {
                RemoteVideoTrack remoteVideoTrack = remoteVideoTrackPublication.getRemoteVideoTrack();
                if (remoteVideoTrack == null) continue;
                remoteVideoTrack.release();
            }
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private void addAudioTracks(List<RemoteAudioTrackPublication> remoteAudioTracks) {
        for (RemoteAudioTrackPublication remoteAudioTrackPublication : remoteAudioTracks) {
            this.audioTrackPublications.add(remoteAudioTrackPublication);
        }
    }

    private void addVideoTracks(List<RemoteVideoTrackPublication> remoteVideoTracks) {
        for (RemoteVideoTrackPublication remoteVideoTrackPublication : remoteVideoTracks) {
            this.videoTrackPublications.add(remoteVideoTrackPublication);
        }
    }

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onAudioTrackPublished(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackUnpublished(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackSubscribed(RemoteParticipant var1, RemoteAudioTrackPublication var2, RemoteAudioTrack var3);

        public void onAudioTrackUnsubscribed(RemoteParticipant var1, RemoteAudioTrackPublication var2, RemoteAudioTrack var3);

        public void onVideoTrackPublished(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackUnpublished(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackSubscribed(RemoteParticipant var1, RemoteVideoTrackPublication var2, RemoteVideoTrack var3);

        public void onVideoTrackUnsubscribed(RemoteParticipant var1, RemoteVideoTrackPublication var2, RemoteVideoTrack var3);

        public void onAudioTrackEnabled(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onAudioTrackDisabled(RemoteParticipant var1, RemoteAudioTrackPublication var2);

        public void onVideoTrackEnabled(RemoteParticipant var1, RemoteVideoTrackPublication var2);

        public void onVideoTrackDisabled(RemoteParticipant var1, RemoteVideoTrackPublication var2);
    }
}

