/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class LocalParticipant {
    private long nativeLocalParticipantHandle;
    private final String sid;
    private final String identity;
    private final List<LocalAudioTrack> audioTracks;
    private final List<LocalVideoTrack> videoTracks;

    public String getSid() {
        return this.sid;
    }

    public String getIdentity() {
        return this.identity;
    }

    public synchronized List<LocalAudioTrack> getAudioTracks() {
        return new ArrayList<LocalAudioTrack>(this.audioTracks);
    }

    public synchronized List<LocalVideoTrack> getVideoTracks() {
        return new ArrayList<LocalVideoTrack>(this.videoTracks);
    }

    public synchronized boolean addAudioTrack(@NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        boolean added = this.nativeAddAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack.getNativeHandle());
        if (added) {
            this.audioTracks.add(localAudioTrack);
        }
        return added;
    }

    public synchronized boolean addVideoTrack(@NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        boolean added = this.nativeAddVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack.getNativeHandle());
        if (added) {
            this.videoTracks.add(localVideoTrack);
        }
        return added;
    }

    public synchronized boolean removeAudioTrack(@NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(localAudioTrack, "LocalAudioTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        this.audioTracks.remove(localAudioTrack);
        return this.nativeRemoveAudioTrack(this.nativeLocalParticipantHandle, localAudioTrack.getNativeHandle());
    }

    public synchronized boolean removeVideoTrack(@NonNull LocalVideoTrack localVideoTrack) {
        Preconditions.checkNotNull(localVideoTrack, "LocalVideoTrack must not be null");
        if (this.isReleased()) {
            return false;
        }
        this.videoTracks.remove(localVideoTrack);
        return this.nativeRemoveVideoTrack(this.nativeLocalParticipantHandle, localVideoTrack.getNativeHandle());
    }

    LocalParticipant(long nativeLocalParticipantHandle, String sid, String identity, List<LocalAudioTrack> audioTracks, List<LocalVideoTrack> videoTracks) {
        this.nativeLocalParticipantHandle = nativeLocalParticipantHandle;
        this.sid = sid;
        this.identity = identity;
        if (audioTracks == null) {
            audioTracks = new ArrayList<LocalAudioTrack>();
        }
        this.audioTracks = audioTracks;
        if (videoTracks == null) {
            videoTracks = new ArrayList<LocalVideoTrack>();
        }
        this.videoTracks = videoTracks;
    }

    @Deprecated
    public synchronized void release() {
    }

    synchronized void internalRelease() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalParticipantHandle);
            this.nativeLocalParticipantHandle = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeLocalParticipantHandle == 0L;
    }

    private native boolean nativeAddAudioTrack(long var1, long var3);

    private native boolean nativeAddVideoTrack(long var1, long var3);

    private native boolean nativeRemoveAudioTrack(long var1, long var3);

    private native boolean nativeRemoveVideoTrack(long var1, long var3);

    private native void nativeRelease(long var1);
}

