/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.VideoRenderer;

public class I420Frame {
    public final int width;
    public final int height;
    @Nullable
    public final int[] yuvStrides;
    @Nullable
    public final ByteBuffer[] yuvPlanes;
    public int rotationDegree;
    public int textureId;
    public final float[] samplingMatrix;
    final VideoRenderer.I420Frame webRtcI420Frame;
    long nativeFramePointer;

    I420Frame(VideoRenderer.I420Frame webRtcI420Frame) {
        this.width = webRtcI420Frame.width;
        this.height = webRtcI420Frame.height;
        this.yuvStrides = webRtcI420Frame.yuvStrides;
        this.yuvPlanes = webRtcI420Frame.yuvPlanes;
        this.rotationDegree = webRtcI420Frame.rotationDegree;
        this.webRtcI420Frame = webRtcI420Frame;
        this.nativeFramePointer = webRtcI420Frame.nativeFramePointer;
        this.textureId = webRtcI420Frame.textureId;
        this.samplingMatrix = webRtcI420Frame.samplingMatrix;
        if (this.rotationDegree % 90 != 0) {
            throw new IllegalArgumentException("Rotation degree not multiple of 90: " + this.rotationDegree);
        }
    }

    public int rotatedWidth() {
        return this.rotationDegree % 180 == 0 ? this.width : this.height;
    }

    public int rotatedHeight() {
        return this.rotationDegree % 180 == 0 ? this.height : this.width;
    }

    public synchronized void release() {
        if (this.nativeFramePointer != 0L) {
            this.nativeRelease(this.nativeFramePointer);
            this.nativeFramePointer = 0L;
        }
    }

    public String toString() {
        return this.width + "x" + this.height + ":" + this.yuvStrides[0] + ":" + this.yuvStrides[1] + ":" + this.yuvStrides[2];
    }

    private native void nativeRelease(long var1);
}

