/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import java.nio.ByteBuffer;

public class I420Frame {
    public final int width;
    public final int height;
    public final int[] yuvStrides;
    public ByteBuffer[] yuvPlanes;
    public final boolean yuvFrame;
    public final float[] samplingMatrix;
    public int textureId;
    long nativeFramePointer;
    public int rotationDegree;

    public I420Frame(int width, int height, int rotationDegree, int[] yuvStrides, ByteBuffer[] yuvPlanes, long nativeFramePointer) {
        this.width = width;
        this.height = height;
        this.yuvStrides = yuvStrides;
        this.yuvPlanes = yuvPlanes;
        this.yuvFrame = true;
        this.rotationDegree = rotationDegree;
        this.nativeFramePointer = nativeFramePointer;
        if (rotationDegree % 90 != 0) {
            throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
        }
        this.samplingMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public I420Frame(int width, int height, int rotationDegree, int textureId, float[] samplingMatrix, long nativeFramePointer) {
        this.width = width;
        this.height = height;
        this.yuvStrides = null;
        this.yuvPlanes = null;
        this.samplingMatrix = samplingMatrix;
        this.textureId = textureId;
        this.yuvFrame = false;
        this.rotationDegree = rotationDegree;
        this.nativeFramePointer = nativeFramePointer;
        if (rotationDegree % 90 != 0) {
            throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
        }
    }

    public int rotatedWidth() {
        return this.rotationDegree % 180 == 0 ? this.width : this.height;
    }

    public int rotatedHeight() {
        return this.rotationDegree % 180 == 0 ? this.height : this.width;
    }

    public String toString() {
        return this.width + "x" + this.height + ":" + this.yuvStrides[0] + ":" + this.yuvStrides[1] + ":" + this.yuvStrides[2];
    }
}

