/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import com.twilio.video.VideoClient;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;

final class PlatformInfo {
    private static final String PLATFORM_NAME = "Android";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");

    private PlatformInfo() {
    }

    static String getPlatfomName() {
        return PLATFORM_NAME;
    }

    static String getPlatformVersion() {
        return Build.VERSION.RELEASE;
    }

    static String getHwDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    static String getHwDeviceModel() {
        return Build.MODEL;
    }

    static String getHwDeviceUUID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    static String getHwDeviceIPAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !PlatformInfo.isIPv4Address(inetAddress.getHostAddress())) continue;
                    String ipaddress = inetAddress.getHostAddress().toString();
                    return ipaddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "";
    }

    static String getHwDeviceConnectionType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        String connType = "";
        connType = info == null || !info.isConnected() ? "No connection" : (info.getType() == 1 ? info.getTypeName() : (info.getType() == 0 ? info.getSubtypeName() : "Unable to detect connection type"));
        return connType;
    }

    static int getHwDeviceNumCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    static double getTimeStamp() {
        return System.currentTimeMillis() / 1000L;
    }

    static String getRtcPlatformSdkVersion() {
        return VideoClient.getVersion();
    }

    static String getOsArch() {
        return System.getProperty("os.arch");
    }

    private static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }
}

