/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.HashMap;
import java.util.Map;

public class Metrics {
    private static final String TAG = "Metrics";
    public final Map<String, HistogramInfo> map = new HashMap<String, HistogramInfo>();

    private void add(String name, HistogramInfo info) {
        this.map.put(name, info);
    }

    public static void enable() {
        Metrics.nativeEnable();
    }

    public static Metrics getAndReset() {
        return Metrics.nativeGetAndReset();
    }

    private static native void nativeEnable();

    private static native Metrics nativeGetAndReset();

    static {
        System.loadLibrary("jingle_peerconnection_so");
    }

    static class Histogram {
        private final long handle;
        private final String name;

        private Histogram(long handle, String name) {
            this.handle = handle;
            this.name = name;
        }

        public static Histogram createCounts(String name, int min, int max, int bucketCount) {
            return new Histogram(Histogram.nativeCreateCounts(name, min, max, bucketCount), name);
        }

        public void addSample(int sample) {
            Histogram.nativeAddSample(this.handle, sample);
        }

        private static native long nativeCreateCounts(String var0, int var1, int var2, int var3);

        private static native void nativeAddSample(long var0, int var2);
    }

    public static class HistogramInfo {
        public final int min;
        public final int max;
        public final int bucketCount;
        public final Map<Integer, Integer> samples = new HashMap<Integer, Integer>();

        public HistogramInfo(int min, int max, int bucketCount) {
            this.min = min;
            this.max = max;
            this.bucketCount = bucketCount;
        }

        public void addSample(int value, int numEvents) {
            this.samples.put(value, numEvents);
        }
    }
}

