/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.NativeHandle;
import com.twilio.video.VideoTrack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Media {
    private static final Logger logger = Logger.getLogger(Media.class);
    private Map<String, VideoTrack> videoTrackMap = new HashMap<String, VideoTrack>();
    private Map<String, AudioTrack> audioTrackMap = new HashMap<String, AudioTrack>();
    private long nativeMediaContext;
    private final InternalMediaListenerImpl internalMediaListenerImpl;
    private final InternalMediaListenerHandle internalMediaListenerHandle;
    private Listener listener;
    private final Handler handler;

    Media(long nativeMediaContext, List<AudioTrack> audioTracks, List<VideoTrack> videoTracks, Handler handler) {
        this.nativeMediaContext = nativeMediaContext;
        this.handler = handler;
        this.addAudioTracks(audioTracks);
        this.addVideoTracks(videoTracks);
        this.internalMediaListenerImpl = new InternalMediaListenerImpl();
        this.internalMediaListenerHandle = new InternalMediaListenerHandle(this.internalMediaListenerImpl);
        this.nativeSetInternalListener(nativeMediaContext, this.internalMediaListenerHandle.get());
    }

    public AudioTrack getAudioTrack(String trackId) {
        return this.audioTrackMap.get(trackId);
    }

    public VideoTrack getVideoTrack(String trackId) {
        return this.videoTrackMap.get(trackId);
    }

    public List<VideoTrack> getVideoTracks() {
        return new ArrayList<VideoTrack>(this.videoTrackMap.values());
    }

    public List<AudioTrack> getAudioTracks() {
        return new ArrayList<AudioTrack>(this.audioTrackMap.values());
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    void addVideoTracks(List<VideoTrack> videoTrackList) {
        for (VideoTrack videoTrack : videoTrackList) {
            if (videoTrack == null || videoTrack.getTrackId() == null) continue;
            this.videoTrackMap.put(videoTrack.getTrackId(), videoTrack);
        }
    }

    void addAudioTracks(List<AudioTrack> audioTrackList) {
        for (AudioTrack audioTrack : audioTrackList) {
            if (audioTrack == null || audioTrack.getTrackId() == null) continue;
            this.audioTrackMap.put(audioTrack.getTrackId(), audioTrack);
        }
    }

    synchronized void release() {
        this.audioTrackMap.clear();
        for (VideoTrack videoTrack : this.videoTrackMap.values()) {
            videoTrack.release();
        }
        this.videoTrackMap.clear();
        if (this.nativeMediaContext != 0L) {
            this.nativeRelease(this.nativeMediaContext);
            this.nativeMediaContext = 0L;
            if (this.internalMediaListenerHandle != null) {
                this.internalMediaListenerHandle.release();
            }
        }
    }

    private native void nativeSetInternalListener(long var1, long var3);

    private native void nativeRelease(long var1);

    class InternalMediaListenerHandle
    extends NativeHandle {
        public InternalMediaListenerHandle(InternalMediaListener listener) {
            super(listener);
        }

        @Override
        protected native long nativeCreate(Object var1);

        @Override
        protected native void nativeRelease(long var1);
    }

    class InternalMediaListenerImpl
    implements InternalMediaListener {
        InternalMediaListenerImpl() {
        }

        @Override
        public void onAudioTrackAdded(final AudioTrack audioTrack) {
            logger.d("onAudioTrackAdded");
            if (audioTrack == null) {
                logger.w("Received audio track added callback for non-existing audio track");
            }
            Media.this.audioTrackMap.put(audioTrack.getTrackId(), audioTrack);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onAudioTrackAdded(Media.this, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackRemoved(String trackId) {
            logger.d("onAudioTrackRemoved");
            final AudioTrack audioTrack = (AudioTrack)Media.this.audioTrackMap.remove(trackId);
            if (audioTrack == null) {
                logger.w("Received audio track removed callback for non-existent audio track");
                return;
            }
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onAudioTrackRemoved(Media.this, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackAdded(final VideoTrack videoTrack) {
            logger.d("onVideoTrackAdded");
            if (videoTrack == null) {
                logger.w("Received video track added callback for non-existing video track");
            }
            Media.this.videoTrackMap.put(videoTrack.getTrackId(), videoTrack);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onVideoTrackAdded(Media.this, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackRemoved(String trackId) {
            logger.d("onVideoTrackRemoved");
            final VideoTrack videoTrack = (VideoTrack)Media.this.videoTrackMap.remove(trackId);
            if (videoTrack == null) {
                logger.w("Received video track removed callback for non-existent video track");
                return;
            }
            videoTrack.release();
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onVideoTrackRemoved(Media.this, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackEnabled(String trackId) {
            logger.d("onAudioTrackEnabled");
            final AudioTrack audioTrack = (AudioTrack)Media.this.audioTrackMap.get(trackId);
            if (audioTrack == null) {
                logger.w("Received audio track enabled callback for non-existent audio track");
                return;
            }
            audioTrack.setEnabled(true);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onAudioTrackEnabled(Media.this, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onAudioTrackDisabled(String trackId) {
            logger.d("onAudioTrackDisabled");
            final AudioTrack audioTrack = (AudioTrack)Media.this.audioTrackMap.get(trackId);
            if (audioTrack == null) {
                logger.w("Received audio track disabled callback for non-existent audio track");
                return;
            }
            audioTrack.setEnabled(false);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onAudioTrackDisabled(Media.this, audioTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackEnabled(String trackId) {
            logger.d("onVideoTrackEnabled");
            final VideoTrack videoTrack = (VideoTrack)Media.this.videoTrackMap.get(trackId);
            if (videoTrack == null) {
                logger.w("Received video track enabled callback for non-existent video track");
                return;
            }
            videoTrack.setEnabled(true);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onVideoTrackEnabled(Media.this, videoTrack);
                    }
                });
            }
        }

        @Override
        public void onVideoTrackDisabled(String trackId) {
            logger.d("onVideoTrackDisabled");
            final VideoTrack videoTrack = (VideoTrack)Media.this.videoTrackMap.get(trackId);
            if (videoTrack == null) {
                logger.w("Received video track disabled callback for non-existent video track");
                return;
            }
            videoTrack.setEnabled(false);
            if (Media.this.listener != null) {
                Media.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Media.this.listener.onVideoTrackDisabled(Media.this, videoTrack);
                    }
                });
            }
        }
    }

    static interface InternalMediaListener {
        public void onAudioTrackAdded(AudioTrack var1);

        public void onAudioTrackRemoved(String var1);

        public void onVideoTrackAdded(VideoTrack var1);

        public void onVideoTrackRemoved(String var1);

        public void onAudioTrackEnabled(String var1);

        public void onAudioTrackDisabled(String var1);

        public void onVideoTrackEnabled(String var1);

        public void onVideoTrackDisabled(String var1);
    }

    public static interface Listener {
        public void onAudioTrackAdded(Media var1, AudioTrack var2);

        public void onAudioTrackRemoved(Media var1, AudioTrack var2);

        public void onVideoTrackAdded(Media var1, VideoTrack var2);

        public void onVideoTrackRemoved(Media var1, VideoTrack var2);

        public void onAudioTrackEnabled(Media var1, AudioTrack var2);

        public void onAudioTrackDisabled(Media var1, AudioTrack var2);

        public void onVideoTrackEnabled(Media var1, VideoTrack var2);

        public void onVideoTrackDisabled(Media var1, VideoTrack var2);
    }
}

