/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.LocalMedia;
import com.twilio.video.Logger;

class MediaFactory {
    private static final String RELEASE_MESSAGE_TEMPLATE = "MediaFactory released %s unavailable";
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(MediaFactory.class);
    private static volatile MediaFactory instance;
    private static volatile int mediaFactoryRefCount;
    private long nativeMediaFactoryHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MediaFactory instance(Context context) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (instance != null) return instance;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            long nativeMediaFactoryHandle;
            if (instance != null) return instance;
            if (!libraryIsLoaded) {
                ReLinker.loadLibrary((Context)context, (String)"jingle_peerconnection_so");
                libraryIsLoaded = true;
            }
            if ((nativeMediaFactoryHandle = MediaFactory.nativeCreate(context)) == 0L) {
                logger.e("Failed to instance MediaFactory");
            } else {
                instance = new MediaFactory(nativeMediaFactoryHandle);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalMedia createLocalMedia(Context context) {
        this.checkReleased("createLocalMedia");
        long nativeLocalMediaHandle = MediaFactory.nativeCreateLocalMedia(this.nativeMediaFactoryHandle);
        if (nativeLocalMediaHandle == 0L) {
            logger.e("Failed to instance LocalMedia");
            return null;
        }
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            ++mediaFactoryRefCount;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return new LocalMedia(context, this, nativeLocalMediaHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release() {
        if (instance == null) return;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            --mediaFactoryRefCount;
            mediaFactoryRefCount = Math.max(0, mediaFactoryRefCount);
            if (instance == null || mediaFactoryRefCount != 0) return;
            this.nativeRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    long getNativeMediaFactoryHandle() {
        return this.nativeMediaFactoryHandle;
    }

    private MediaFactory(long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
    }

    private void checkReleased(String methodName) {
        if (this.nativeMediaFactoryHandle == 0L) {
            String releaseErrorMessage = String.format(RELEASE_MESSAGE_TEMPLATE, methodName);
            throw new IllegalStateException(releaseErrorMessage);
        }
    }

    private static native long nativeCreate(Context var0);

    private static native long nativeCreateLocalMedia(long var0);

    private native void nativeRelease(long var1);

    static {
        mediaFactoryRefCount = 0;
    }
}

