/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import com.twilio.video.CameraCapturer;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoCapturerListenerAdapter;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoPixelFormat;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

final class VideoCapturerDelegate
implements org.webrtc.VideoCapturer {
    private final VideoCapturer videoCapturer;
    private VideoPixelFormat videoPixelFormat;
    private VideoCapturer.Listener listenerAdapter;

    VideoCapturerDelegate(VideoCapturer videoCapturer) {
        this.videoCapturer = videoCapturer;
    }

    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return this.convertToWebRtcFormats(this.videoCapturer.getSupportedFormats());
    }

    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.listenerAdapter = new VideoCapturerListenerAdapter(capturerObserver);
        if (this.videoCapturer instanceof CameraCapturer) {
            CameraCapturer cameraCapturer = (CameraCapturer)this.videoCapturer;
            cameraCapturer.setSurfaceTextureHelper(surfaceTextureHelper);
        }
    }

    public void startCapture(int width, int height, int framerate) {
        VideoDimensions dimensions = new VideoDimensions(width, height);
        VideoFormat captureFormat = new VideoFormat(dimensions, framerate, this.videoPixelFormat);
        this.videoCapturer.startCapture(captureFormat, this.listenerAdapter);
    }

    public void stopCapture() throws InterruptedException {
        this.videoCapturer.stopCapture();
    }

    public void changeCaptureFormat(int width, int height, int framerate) {
    }

    public void dispose() {
    }

    public boolean isScreencast() {
        return this.videoCapturer.isScreencast();
    }

    private void setVideoPixelFormat(VideoPixelFormat videoPixelFormat) {
        this.videoPixelFormat = videoPixelFormat;
    }

    private List<CameraEnumerationAndroid.CaptureFormat> convertToWebRtcFormats(List<VideoFormat> videoFormats) {
        if (videoFormats != null) {
            ArrayList<CameraEnumerationAndroid.CaptureFormat> webRtcCaptureFormats = new ArrayList<CameraEnumerationAndroid.CaptureFormat>(videoFormats.size());
            for (int i = 0; i < videoFormats.size(); ++i) {
                VideoFormat videoFormat = videoFormats.get(i);
                CameraEnumerationAndroid.CaptureFormat webRtcCaptureFormat = new CameraEnumerationAndroid.CaptureFormat(videoFormat.dimensions.width, videoFormat.dimensions.height, videoFormat.framerate, videoFormat.framerate, videoFormat.pixelFormat.getValue());
                webRtcCaptureFormats.add(i, webRtcCaptureFormat);
            }
            return webRtcCaptureFormats;
        }
        return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
    }

    static class NativeObserver
    implements VideoCapturer.CapturerObserver {
        private final long nativeCapturer;

        public NativeObserver(long nativeCapturer) {
            this.nativeCapturer = nativeCapturer;
        }

        public void onCapturerStarted(boolean success) {
            this.nativeCapturerStarted(this.nativeCapturer, success);
        }

        public void onCapturerStopped() {
        }

        public void onByteBufferFrameCaptured(byte[] data, int width, int height, int rotation, long timeStamp) {
            this.nativeOnByteBufferFrameCaptured(this.nativeCapturer, data, data.length, width, height, rotation, timeStamp);
        }

        public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
            this.nativeOnTextureFrameCaptured(this.nativeCapturer, width, height, oesTextureId, transformMatrix, rotation, timestamp);
        }

        private native void nativeCapturerStarted(long var1, boolean var3);

        private native void nativeOnByteBufferFrameCaptured(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

        private native void nativeOnTextureFrameCaptured(long var1, int var3, int var4, int var5, float[] var6, int var7, long var8);
    }
}

