/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.twilio.video.Logger;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import com.twilio.video.VideoPixelFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public class ScreenCapturer
implements VideoCapturer {
    private static final String TAG = "ScreenCapturer";
    private static final Logger logger = Logger.getLogger(ScreenCapturer.class);
    private static final int IMAGE_READER_BUFFER_MAX = 5;
    private static final int SCREENCAPTURE_FRAME_RATE = 30;
    private static final int HD_SCREENCAST_PIXELS = 921600;
    private boolean firstFrameReported;
    private final Context context;
    private final int screenCaptureIntentResult;
    private final Intent screenCaptureIntentData;
    private final Listener screenCapturerListener;
    private VideoCapturer.Listener capturerListener;
    private MediaProjection mediaProjection;
    private VirtualDisplay virtualDisplay;
    private ImageReader imageReader;
    private final MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
            logger.d("media projection stopped");
        }
    };
    private final VirtualDisplay.Callback virtualDisplayCallbacks = new VirtualDisplay.Callback(){

        public void onResumed() {
            logger.d("virtual display resumed");
        }

        public void onPaused() {
            logger.d("virtual display paused");
        }

        public void onStopped() {
            logger.d("virtual display stopped");
        }
    };
    private final ImageReader.OnImageAvailableListener screenCapturer = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            block8: {
                Image image = null;
                try {
                    image = reader.acquireLatestImage();
                }
                catch (Exception e) {
                    String screenFrameFailure = "Failed to acquire screen frame";
                    logger.e(screenFrameFailure);
                    if (ScreenCapturer.this.screenCapturerListener != null) {
                        ScreenCapturer.this.screenCapturerListener.onScreenCaptureError(screenFrameFailure);
                    }
                    return;
                }
                if (image != null) {
                    long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                    if (!ScreenCapturer.this.firstFrameReported) {
                        if (ScreenCapturer.this.screenCapturerListener != null) {
                            ScreenCapturer.this.screenCapturerListener.onFirstFrameAvailable();
                        }
                        ScreenCapturer.this.firstFrameReported = true;
                    }
                    try {
                        Image.Plane plane = image.getPlanes()[0];
                        ByteBuffer planeBuffer = plane.getBuffer();
                        int bufferSize = planeBuffer.remaining();
                        byte[] buffer = new byte[bufferSize];
                        planeBuffer.get(buffer, 0, bufferSize);
                        VideoDimensions dimensions = new VideoDimensions(image.getWidth(), image.getHeight());
                        VideoFrame videoFrame = new VideoFrame(buffer, dimensions, VideoFrame.RotationAngle.ROTATION_0, captureTimeNs);
                        ScreenCapturer.this.capturerListener.onFrameCaptured(videoFrame);
                        image.close();
                    }
                    catch (Exception e) {
                        logger.e(e.getMessage());
                        if (ScreenCapturer.this.screenCapturerListener == null) break block8;
                        ScreenCapturer.this.screenCapturerListener.onScreenCaptureError(e.getMessage());
                    }
                }
            }
        }
    };

    public ScreenCapturer(Context context, int screenCaptureIntentResult, Intent screenCaptureIntentData, Listener screenCapturerListener) {
        if (Build.VERSION.SDK_INT < 21) {
            throw new RuntimeException("Screen capturing unavailable for " + Build.VERSION.SDK_INT);
        }
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        this.context = context;
        this.screenCaptureIntentResult = screenCaptureIntentResult;
        this.screenCaptureIntentData = screenCaptureIntentData;
        this.screenCapturerListener = screenCapturerListener;
    }

    @Override
    public List<VideoFormat> getSupportedFormats() {
        ArrayList<VideoFormat> screencastFormats = new ArrayList<VideoFormat>();
        VideoDimensions vgaDimensions = new VideoDimensions(640, 480);
        VideoDimensions hdDimensions = new VideoDimensions(1280, 720);
        screencastFormats.add(new VideoFormat(vgaDimensions, 30, VideoPixelFormat.RGBA_8888));
        screencastFormats.add(new VideoFormat(hdDimensions, 30, VideoPixelFormat.RGBA_8888));
        return screencastFormats;
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    @Override
    public void startCapture(VideoFormat captureFormat, VideoCapturer.Listener capturerListener) {
        this.capturerListener = capturerListener;
        this.firstFrameReported = false;
        Handler handler = Util.createCallbackHandler();
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.context.getSystemService("media_projection");
        this.mediaProjection = mediaProjectionManager.getMediaProjection(this.screenCaptureIntentResult, this.screenCaptureIntentData);
        if (this.mediaProjection == null) {
            if (this.screenCapturerListener != null) {
                this.screenCapturerListener.onScreenCaptureError("Unable to access media projection");
            }
            capturerListener.onCapturerStarted(false);
            return;
        }
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, handler);
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(metrics);
        int screenDensity = metrics.densityDpi;
        this.imageReader = ImageReader.newInstance((int)captureFormat.dimensions.width, (int)captureFormat.dimensions.height, (int)1, (int)5);
        this.imageReader.setOnImageAvailableListener(this.screenCapturer, handler);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay(TAG, captureFormat.dimensions.width, captureFormat.dimensions.height, screenDensity, 16, this.imageReader.getSurface(), this.virtualDisplayCallbacks, handler);
        capturerListener.onCapturerStarted(true);
    }

    @Override
    public void stopCapture() {
        logger.d("stopCapture");
        if (this.virtualDisplay != null) {
            this.virtualDisplay.release();
            this.virtualDisplay = null;
        }
        if (this.imageReader != null) {
            this.imageReader.close();
            this.imageReader = null;
        }
        if (this.mediaProjection != null) {
            this.mediaProjection.unregisterCallback(this.mediaProjectionCallback);
            this.mediaProjection.stop();
            this.mediaProjection = null;
        }
        logger.d("stopCapture done");
    }

    public static interface Listener {
        public void onScreenCaptureError(String var1);

        public void onFirstFrameAvailable();
    }
}

