/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LogLevel;
import com.twilio.video.LogModule;
import com.twilio.video.Logger;
import com.twilio.video.Participant;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Room;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class VideoClient {
    private static LogLevel level = LogLevel.OFF;
    private static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(VideoClient.class);
    private static final Set<Room> rooms = new HashSet<Room>();
    private static NetworkInfo currentNetworkInfo = null;
    private static Context applicationContext = null;
    private static final BroadcastReceiver connectivityChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo newNetworkInfo = conn.getActiveNetworkInfo();
                NetworkChangeEvent networkChangeEvent = NetworkChangeEvent.CONNECTION_CHANGED;
                if (newNetworkInfo != null && (currentNetworkInfo == null || currentNetworkInfo.getDetailedState() != newNetworkInfo.getDetailedState() || currentNetworkInfo.getType() != newNetworkInfo.getType() || currentNetworkInfo.getSubtype() != newNetworkInfo.getSubtype())) {
                    if (!newNetworkInfo.isConnectedOrConnecting()) {
                        networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                    }
                    logger.d("Network event detected: " + networkChangeEvent.name());
                    VideoClient.onNetworkChange(networkChangeEvent);
                } else if (newNetworkInfo == null) {
                    networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                    logger.d("Network connection lost");
                    VideoClient.onNetworkChange(networkChangeEvent);
                }
                currentNetworkInfo = newNetworkInfo;
            }
        }
    };

    public static synchronized Room connect(Context context, ConnectOptions connectOptions, Room.Listener roomListener) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (connectOptions == null) {
            throw new NullPointerException("connectOptions must not be null");
        }
        if (roomListener == null) {
            throw new NullPointerException("roomListener must not be null");
        }
        if (applicationContext == null) {
            applicationContext = context.getApplicationContext();
        }
        if (!libraryIsLoaded) {
            ReLinker.loadLibrary((Context)applicationContext, (String)"jingle_peerconnection_so");
            libraryIsLoaded = true;
            VideoClient.trySetCoreLogLevel(level.ordinal());
            for (LogModule module : moduleLogLevel.keySet()) {
                VideoClient.trySetCoreModuleLogLevel(module.ordinal(), moduleLogLevel.get((Object)module).ordinal());
            }
        }
        if (rooms.isEmpty()) {
            VideoClient.registerConnectivityBroadcastReceiver();
            ConnectivityManager conn = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            currentNetworkInfo = conn.getActiveNetworkInfo();
        }
        Room room = new Room(connectOptions.getRoomName(), connectOptions.getLocalMedia(), VideoClient.roomListenerProxy(roomListener), Util.createCallbackHandler());
        rooms.add(room);
        room.connect(applicationContext, connectOptions);
        return room;
    }

    static synchronized void release(Room room) {
        rooms.remove(room);
        if (rooms.isEmpty()) {
            VideoClient.unregisterConnectivityBroadcastReceiver();
            PlatformInfo.release();
        }
    }

    private static synchronized void onNetworkChange(NetworkChangeEvent networkChangeEvent) {
        for (Room room : rooms) {
            room.onNetworkChanged(networkChangeEvent);
        }
    }

    private static Room.Listener roomListenerProxy(final Room.Listener roomListener) {
        return new Room.Listener(){

            @Override
            public void onConnected(Room room) {
                roomListener.onConnected(room);
            }

            @Override
            public void onConnectFailure(Room room, TwilioException twilioException) {
                roomListener.onConnectFailure(room, twilioException);
                VideoClient.release(room);
            }

            @Override
            public void onDisconnected(Room room, TwilioException twilioException) {
                roomListener.onDisconnected(room, twilioException);
                VideoClient.release(room);
            }

            @Override
            public void onParticipantConnected(Room room, Participant participant) {
                roomListener.onParticipantConnected(room, participant);
            }

            @Override
            public void onParticipantDisconnected(Room room, Participant participant) {
                roomListener.onParticipantDisconnected(room, participant);
            }

            @Override
            public void onRecordingStarted(Room room) {
                roomListener.onRecordingStarted(room);
            }

            @Override
            public void onRecordingStopped(Room room) {
                roomListener.onRecordingStopped(room);
            }
        };
    }

    public static String getVersion() {
        return "1.0.0-beta14";
    }

    public static LogLevel getLogLevel() {
        return LogLevel.values()[VideoClient.tryGetCoreLogLevel()];
    }

    public static void setLogLevel(LogLevel level) {
        VideoClient.setSDKLogLevel(level);
        VideoClient.trySetCoreLogLevel(level.ordinal());
        VideoClient.level = level;
    }

    public static void setModuleLogLevel(LogModule module, LogLevel level) {
        if (module == LogModule.PLATFORM) {
            VideoClient.setSDKLogLevel(level);
        }
        VideoClient.trySetCoreModuleLogLevel(module.ordinal(), level.ordinal());
        moduleLogLevel.put(module, level);
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case FATAL: {
                Logger.setLogLevel(6);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    private static void trySetCoreLogLevel(int level) {
        if (libraryIsLoaded) {
            VideoClient.nativeSetCoreLogLevel(level);
        }
    }

    private static int tryGetCoreLogLevel() {
        return libraryIsLoaded ? VideoClient.nativeGetCoreLogLevel() : level.ordinal();
    }

    private static void trySetCoreModuleLogLevel(int module, int level) {
        if (libraryIsLoaded) {
            VideoClient.nativeSetModuleLevel(module, level);
        }
    }

    private static void registerConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.registerReceiver(connectivityChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private static void unregisterConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.unregisterReceiver(connectivityChangeReceiver);
        }
    }

    private static native void nativeSetCoreLogLevel(int var0);

    private static native void nativeSetModuleLevel(int var0, int var1);

    private static native int nativeGetCoreLogLevel();

    static enum NetworkChangeEvent {
        CONNECTION_LOST,
        CONNECTION_CHANGED;

    }
}

