/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.IceOptions;
import com.twilio.video.LocalMedia;
import com.twilio.video.PlatformInfo;

public class ConnectOptions {
    private final String accessToken;
    private final String roomName;
    private final LocalMedia localMedia;
    private final IceOptions iceOptions;

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.roomName = builder.roomName;
        this.localMedia = builder.localMedia;
        this.iceOptions = builder.iceOptions;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRoomName() {
        return this.roomName;
    }

    LocalMedia getLocalMedia() {
        return this.localMedia;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    private long createNativeObject() {
        return this.nativeCreate(this.accessToken, this.roomName, this.localMedia, this.iceOptions, PlatformInfo.getNativeHandle());
    }

    private native long nativeCreate(String var1, String var2, LocalMedia var3, IceOptions var4, long var5);

    public static class Builder {
        private String accessToken = "";
        private String roomName = "";
        private LocalMedia localMedia;
        private IceOptions iceOptions;

        public Builder(String accessToken) {
            this.accessToken = accessToken;
        }

        public Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public Builder localMedia(LocalMedia localMedia) {
            this.localMedia = localMedia;
            return this;
        }

        public Builder iceOptions(IceOptions iceOptions) {
            this.iceOptions = iceOptions;
            return this;
        }

        public ConnectOptions build() {
            if (this.accessToken == null) {
                throw new NullPointerException("Token must not be null.");
            }
            if (this.accessToken.equals("")) {
                throw new IllegalArgumentException("Token must not be empty.");
            }
            return new ConnectOptions(this);
        }
    }
}

