/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.trunking;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTrunkingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CredentialList
extends NextGenInstanceResource<TwilioTrunkingClient> {
    public CredentialList(TwilioTrunkingClient client, String trunkSid, String sid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)trunkSid)) {
            throw new IllegalArgumentException("trunkSid cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty("trunk_sid", trunkSid);
        this.setProperty("sid", sid);
    }

    public CredentialList(TwilioTrunkingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getTrunkSid() {
        return this.getProperty("trunk_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTrunkingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Trunks/" + this.getTrunkSid() + "/CredentialLists/" + this.getSid();
    }
}

