/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Activity
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public Activity(TwilioTaskRouterClient client) {
        super(client);
    }

    public Activity(TwilioTaskRouterClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Activity(TwilioTaskRouterClient client, String workspaceSid, String activitySid) {
        super(client);
        if (StringUtils.isBlank((CharSequence)workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for an Activity cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)activitySid)) {
            throw new IllegalArgumentException("The activitySid for an Activity cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty("sid", activitySid);
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    public boolean isAvailable() {
        return (Boolean)this.getObject("available");
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Activities/" + this.getSid();
    }
}

