/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Participant
extends InstanceResource<TwilioRestClient> {
    private static final String CALL_SID_PROPERTY = "call_sid";
    private static final String CONFERENCE_SID_PROPERTY = "conference_sid";

    public Participant(TwilioRestClient client) {
        super(client);
    }

    public Participant(TwilioRestClient client, String conferenceSid, String callSid) {
        super(client);
        if (conferenceSid == null) {
            throw new IllegalStateException("The conferenceSid for a Participant can not be null");
        }
        if (callSid == null) {
            throw new IllegalStateException("The callSid for a Participant can not be null");
        }
        this.setProperty(CONFERENCE_SID_PROPERTY, conferenceSid);
        this.setProperty(CALL_SID_PROPERTY, callSid);
    }

    public Participant(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Conferences/" + this.getConferenceSid() + "/Participants/" + this.getCallSid() + ".json";
    }

    public String getConferenceSid() {
        return this.getProperty(CONFERENCE_SID_PROPERTY);
    }

    public String getCallSid() {
        return this.getProperty(CALL_SID_PROPERTY);
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public boolean isMuted() {
        return (Boolean)this.getObject("muted");
    }

    public boolean isStartConferenceOnEnter() {
        return (Boolean)this.getObject("start_conference_on_enter");
    }

    public boolean isEndConferenceOnExit() {
        return (Boolean)this.getObject("end_conference_on_exit");
    }

    public Participant mute() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Muted", "true");
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", vars);
        return new Participant((TwilioRestClient)this.getClient(), response.toMap());
    }

    public Participant unmute() throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("Muted", "false");
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", vars);
        return new Participant((TwilioRestClient)this.getClient(), response.toMap());
    }

    public boolean kick() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

