/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import android.os.Handler;
import com.twilio.conversations.ListenerException;
import com.twilio.conversations.MediaUploadListener;
import com.twilio.conversations.internal.HandlerUtil;
import com.twilio.conversations.internal.RethrowingForwarder;
import com.twilio.util.ErrorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/twilio/conversations/internal/MediaUploadListenerForwarder;", "Lcom/twilio/conversations/MediaUploadListener;", "listener_", "(Lcom/twilio/conversations/MediaUploadListener;)V", "handler", "Landroid/os/Handler;", "kotlin.jvm.PlatformType", "getHandler", "()Landroid/os/Handler;", "listener", "getListener", "()Lcom/twilio/conversations/MediaUploadListener;", "onCompleted", "", "mediaSid", "", "onFailed", "errorInfo", "Lcom/twilio/util/ErrorInfo;", "onProgress", "bytesSent", "", "onStarted", "convo-android_release"})
public final class MediaUploadListenerForwarder
implements MediaUploadListener {
    private final Handler handler = HandlerUtil.setupListenerHandler();
    private final MediaUploadListener listener;

    public MediaUploadListenerForwarder(@Nullable MediaUploadListener listener_) {
        this.listener = RethrowingForwarder.create(listener_, ListenerException.class);
    }

    public final Handler getHandler() {
        return this.handler;
    }

    public final MediaUploadListener getListener() {
        return this.listener;
    }

    @Override
    public void onStarted() {
        this.handler.post(() -> MediaUploadListenerForwarder.onStarted$lambda$0(this));
    }

    @Override
    public void onProgress(long bytesSent) {
        this.handler.post(() -> MediaUploadListenerForwarder.onProgress$lambda$1(this, bytesSent));
    }

    @Override
    public void onCompleted(@NotNull String mediaSid) {
        Intrinsics.checkNotNullParameter((Object)mediaSid, (String)"mediaSid");
        this.handler.post(() -> MediaUploadListenerForwarder.onCompleted$lambda$2(this, mediaSid));
    }

    @Override
    public void onFailed(@NotNull ErrorInfo errorInfo) {
        Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
        this.handler.post(() -> MediaUploadListenerForwarder.onFailed$lambda$3(this, errorInfo));
    }

    private static final void onStarted$lambda$0(MediaUploadListenerForwarder this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            MediaUploadListener mediaUploadListener = this$0.listener;
            if (mediaUploadListener == null) break block0;
            mediaUploadListener.onStarted();
        }
    }

    private static final void onProgress$lambda$1(MediaUploadListenerForwarder this$0, long $bytesSent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            MediaUploadListener mediaUploadListener = this$0.listener;
            if (mediaUploadListener == null) break block0;
            mediaUploadListener.onProgress($bytesSent);
        }
    }

    private static final void onCompleted$lambda$2(MediaUploadListenerForwarder this$0, String $mediaSid) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$mediaSid, (String)"$mediaSid");
            MediaUploadListener mediaUploadListener = this$0.listener;
            if (mediaUploadListener == null) break block0;
            mediaUploadListener.onCompleted($mediaSid);
        }
    }

    private static final void onFailed$lambda$3(MediaUploadListenerForwarder this$0, ErrorInfo $errorInfo) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$errorInfo, (String)"$errorInfo");
            MediaUploadListener mediaUploadListener = this$0.listener;
            if (mediaUploadListener == null) break block0;
            mediaUploadListener.onFailed($errorInfo);
        }
    }
}

