/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations.internal;

import android.os.Handler;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.ListenerException;
import com.twilio.conversations.internal.HandlerUtil;
import com.twilio.conversations.internal.RethrowingForwarder;
import com.twilio.util.ErrorInfo;

public class CallbackListenerForwarder<T>
implements CallbackListener<T> {
    final Handler handler = HandlerUtil.setupListenerHandler();
    final CallbackListener<T> listener;

    public CallbackListenerForwarder(CallbackListener<T> listener_) {
        this.listener = RethrowingForwarder.create(listener_, ListenerException.class);
    }

    @Override
    public void onSuccess(final T value) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (CallbackListenerForwarder.this.listener != null) {
                    CallbackListenerForwarder.this.listener.onSuccess(value);
                }
            }
        });
    }

    @Override
    public void onError(final ErrorInfo error) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (CallbackListenerForwarder.this.listener != null) {
                    CallbackListenerForwarder.this.listener.onError(error);
                }
            }
        });
    }
}

