/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.User;
import com.twilio.conversations.internal.CallbackListenerForwarder;
import com.twilio.conversations.internal.DateUtils;
import com.twilio.conversations.internal.StatusListenerForwarder;
import com.twilio.util.TwilioLogger;
import java.util.Date;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.json.JSONException;

final class ParticipantImpl
implements Participant,
Disposable {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(ParticipantImpl.class));
    private long nativeHandle;
    private boolean isDisposed = false;

    protected ParticipantImpl(long handle) {
        this.nativeHandle = handle;
    }

    @Override
    public native String getSid();

    @Override
    public Long getLastReadMessageIndex() {
        this.checkDisposed("getLastReadMessageIndex");
        return this.nativeGetLastConsumedMessageIndex();
    }

    @Override
    public String getLastReadTimestamp() {
        this.checkDisposed("getLastReadTimestamp");
        return this.nativeGetLastConsumptionTimestamp();
    }

    @Override
    public native String getDateCreated();

    @Override
    public Date getDateCreatedAsDate() {
        this.checkDisposed("getDateCreatedAsDate");
        return DateUtils.parseIso8601DateTime(this.getDateCreated());
    }

    @Override
    public native String getDateUpdated();

    @Override
    public Date getDateUpdatedAsDate() {
        this.checkDisposed("getDateUpdatedAsDate");
        return DateUtils.parseIso8601DateTime(this.getDateUpdated());
    }

    @Override
    public Conversation getConversation() {
        this.checkDisposed("getConversation");
        return this.nativeGetChannel();
    }

    @Override
    public native String getIdentity();

    @Override
    public native String getChannel();

    @Override
    @NonNull
    public Attributes getAttributes() {
        this.checkDisposed("getAttributes");
        String attrString = this.nativeGetAttributes();
        try {
            return Attributes.parse(attrString);
        }
        catch (JSONException e) {
            logger.e("Unable to parse participant attributes", (Throwable)e);
            return Attributes.DEFAULT;
        }
    }

    @Override
    public void setAttributes(@NonNull Attributes attributes, StatusListener listener) {
        this.checkDisposed("setAttributes");
        this.nativeUpdateAttributes(attributes.toString(), new StatusListenerForwarder(listener));
    }

    @Override
    public void getAndSubscribeUser(CallbackListener<User> listener) {
        this.checkDisposed("getAndSubscribeUser");
        this.nativeGetAndSubscribeUser(new CallbackListenerForwarder<User>(listener));
    }

    @Override
    public void remove(StatusListener listener) {
        this.checkDisposed("remove");
        this.nativeRemove(new StatusListenerForwarder(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ParticipantImpl participantImpl = this;
        synchronized (participantImpl) {
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
        }
    }

    private void checkDisposed(String method) {
        if (this.isDisposed) {
            logger.e("Attempt to use disposed object in Participant#" + method);
        }
    }

    private native void nativeDispose();

    private native void nativeGetAndSubscribeUser(CallbackListener<User> var1);

    private native void nativeUpdateAttributes(String var1, StatusListener var2);

    private native void nativeRemove(StatusListener var1);

    private native String nativeGetAttributes();

    private native Conversation nativeGetChannel();

    private native Long nativeGetLastConsumedMessageIndex();

    private native String nativeGetLastConsumptionTimestamp();
}

