/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import android.os.Bundle;
import com.twilio.util.TwilioLogger;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationPayload {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(NotificationPayload.class));
    public static final long INVALID_MESSAGE_INDEX = -1L;
    Bundle payload;

    public NotificationPayload(Map<String, String> remoteMessage) {
        JSONObject obj = new JSONObject(remoteMessage);
        Bundle data = new Bundle();
        NotificationPayload.copyStringToBundle(obj, "twi_message_type", data);
        NotificationPayload.copyStringToBundle(obj, "twi_body", data);
        NotificationPayload.copyStringToBundle(obj, "twi_sound", data);
        NotificationPayload.copyStringToBundle(obj, "twi_message_id", data);
        NotificationPayload.copyStringToBundle(obj, "conversation_sid", data);
        NotificationPayload.copyStringToBundle(obj, "conversation_title", data);
        NotificationPayload.copyStringToBundle(obj, "author", data);
        NotificationPayload.copyStringToBundle(obj, "message_sid", data);
        NotificationPayload.copyNonNegativeNumberToBundle(obj, "message_index", data);
        NotificationPayload.copyNonNegativeNumberToBundle(obj, "media_count", data);
        String media = NotificationPayload.optString(obj, "media");
        if (media != null && !media.isEmpty()) {
            try {
                JSONObject objMedia = new JSONObject(media);
                NotificationPayload.copyStringToBundle(objMedia, "sid", data, "media_sid");
                NotificationPayload.copyStringToBundle(objMedia, "filename", data, "media_filename");
                NotificationPayload.copyStringToBundle(objMedia, "content_type", data, "media_content_type");
                NotificationPayload.copyNonNegativeNumberToBundle(objMedia, "size", data, "media_size");
            }
            catch (JSONException e) {
                logger.i("Media notification parsing exception: " + e.toString());
            }
        }
        this.payload = data;
    }

    public Type getType() {
        if (this.payload.containsKey("twi_message_type")) {
            return Type.fromString(this.payload.getString("twi_message_type"));
        }
        return Type.UNKNOWN;
    }

    public String getBody() {
        return this.payload.getString("twi_body", "");
    }

    public String getSound() {
        return this.payload.getString("twi_sound", "");
    }

    public String getConversationTitle() {
        return this.payload.getString("conversation_title", "");
    }

    public String getConversationSid() {
        return this.payload.getString("conversation_sid", "");
    }

    public String getAuthor() {
        return this.payload.getString("author", "");
    }

    public String getMessageSid() {
        return this.payload.getString("message_sid", "");
    }

    public long getMessageIndex() {
        return this.payload.getLong("message_index", -1L);
    }

    public long getMediaCount() {
        return this.payload.getLong("media_count", 0L);
    }

    public long getMediaSize() {
        return this.payload.getLong("media_size", 0L);
    }

    public String getMediaSid() {
        return this.payload.getString("media_sid", "");
    }

    public String getMediaFilename() {
        return this.payload.getString("media_filename", "");
    }

    public String getMediaContentType() {
        return this.payload.getString("media_content_type", "");
    }

    private static String optString(JSONObject srcJson, @NotNull String key) {
        return srcJson.isNull(key) ? null : srcJson.optString(key);
    }

    private static void copyStringToBundle(JSONObject srcJson, @NotNull String key, Bundle destBundle) {
        NotificationPayload.copyStringToBundle(srcJson, key, destBundle, key);
    }

    private static void copyStringToBundle(JSONObject srcJson, @NotNull String srcKey, Bundle destBundle, @NotNull String destKey) {
        String value = NotificationPayload.optString(srcJson, srcKey);
        if (value != null) {
            destBundle.putString(destKey, value);
        }
    }

    private static void copyNonNegativeNumberToBundle(JSONObject srcJson, @NotNull String key, Bundle destBundle) {
        NotificationPayload.copyNonNegativeNumberToBundle(srcJson, key, destBundle, key);
    }

    private static void copyNonNegativeNumberToBundle(JSONObject srcJson, @NotNull String srcKey, Bundle destBundle, @NotNull String destKey) {
        long value = srcJson.optLong(srcKey, -1L);
        if (value >= 0L) {
            destBundle.putLong(destKey, value);
        }
    }

    public static enum Type {
        UNKNOWN(0),
        NEW_MESSAGE(1),
        ADDED_TO_CONVERSATION(3),
        REMOVED_FROM_CONVERSATION(4);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromString(String in) {
            if (in.contentEquals("twilio.conversations.new_message")) {
                return NEW_MESSAGE;
            }
            if (in.contentEquals("twilio.conversations.added_to_conversation")) {
                return ADDED_TO_CONVERSATION;
            }
            if (in.contentEquals("twilio.conversations.removed_from_conversation")) {
                return REMOVED_FROM_CONVERSATION;
            }
            logger.w("Unsupported notification type: " + in);
            return UNKNOWN;
        }

        public int getValue() {
            return this.value;
        }

        public static Type fromInt(int value) {
            for (Type item : Type.values()) {
                if (item.getValue() != value) continue;
                return item;
            }
            logger.e("Invalid value " + value + " for NotificationPayload.Type");
            throw new IllegalStateException("Invalid value " + value + " for NotificationPayload.Type");
        }
    }
}

