/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.ConversationImpl;
import com.twilio.conversations.ConversationLimits;
import com.twilio.conversations.ConversationsClientImpl;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.MediaCategory;
import com.twilio.conversations.MediaUploadListener;
import com.twilio.conversations.MediaUploadListenerBuilder;
import com.twilio.conversations.Message;
import com.twilio.conversations.Messages;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.content.ContentTemplateVariable;
import com.twilio.conversations.internal.CallbackListenerForwarder;
import com.twilio.conversations.internal.MediaUploadListenerForwarder;
import com.twilio.conversations.media.MediaClient;
import com.twilio.conversations.media.MediaUploadItem;
import com.twilio.util.ErrorInfo;
import com.twilio.util.ErrorReason;
import com.twilio.util.InternalUtilsKt;
import com.twilio.util.TwilioException;
import com.twilio.util.TwilioLogger;
import com.twilio.util.TwilioLoggerKt;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.streams.InputKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u00039:;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u001f\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0086 J\t\u0010 \u001a\u00020\u0014H\u0086 J\t\u0010!\u001a\u00020\"H\u0086 J\t\u0010#\u001a\u00020$H\u0086 J\u0010\u0010%\u001a\u0004\u0018\u00010\u0003H\u0086 \u00a2\u0006\u0002\u0010&J%\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0\u001fH\u0086 J\u001f\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020+0\u001fH\u0086 J-\u0010.\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0\u001fH\u0086 J-\u0010/\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0\u001fH\u0086 J\u0019\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020+2\u0006\u0010\u001e\u001a\u000202H\u0086 J\u001f\u00103\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020+0\u001fH\u0086 J\u0017\u00104\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0086 J\u001f\u00105\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0086 J\u0017\u00106\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0086 J'\u00107\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020+0\u001fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"Lcom/twilio/conversations/Messages;", "Lcom/twilio/conversations/Disposable;", "nativeHandle", "", "(J)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "kotlin.jvm.PlatformType", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "coroutineScope$delegate", "Lkotlin/Lazy;", "isDisposed", "", "mediaClient", "Lcom/twilio/conversations/media/MediaClient;", "getMediaClient", "()Lcom/twilio/conversations/media/MediaClient;", "mediaClient$delegate", "checkDisposed", "", "method", "", "checkMessageExceedsLimits", "Lcom/twilio/util/ErrorInfo;", "messageDescriptor", "Lcom/twilio/conversations/Messages$MessageDescriptor;", "dispose", "nativeAdvanceLastConsumedMessageIndexWithResult", "lastConsumedMessageIndex", "listener", "Lcom/twilio/conversations/CallbackListener;", "nativeDispose", "nativeGetConversation", "Lcom/twilio/conversations/ConversationImpl;", "nativeGetConversationsClient", "Lcom/twilio/conversations/ConversationsClientImpl;", "nativeGetLastConsumedMessageIndex", "()Ljava/lang/Long;", "nativeGetLastMessages", "count", "", "", "Lcom/twilio/conversations/Message;", "nativeGetMessageByIndex", "index", "nativeGetMessagesAfter", "nativeGetMessagesBefore", "nativeRemoveMessage", "message", "Lcom/twilio/conversations/StatusListener;", "nativeSendMessage", "nativeSetAllMessagesConsumedWithResult", "nativeSetLastConsumedMessageIndexWithResult", "nativeSetNoMessagesConsumedWithResult", "sendMessage", "(Lcom/twilio/conversations/Messages$MessageDescriptor;Lcom/twilio/conversations/CallbackListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MessageBuilderImpl", "MessageDescriptor", "UnsentMessageImpl", "convo-android_release"})
@SourceDebugExtension(value={"SMAP\nMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,265:1\n1#2:266\n37#3,2:267\n*S KotlinDebug\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages\n*L\n119#1:267,2\n*E\n"})
public final class Messages
implements Disposable {
    private long nativeHandle;
    @NotNull
    private final Lazy mediaClient$delegate;
    @NotNull
    private final Lazy coroutineScope$delegate;
    private boolean isDisposed;

    public Messages(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.mediaClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaClient>(this){
            final /* synthetic */ Messages this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MediaClient invoke() {
                return this.this$0.nativeGetConversationsClient().getMediaClient();
            }
        }));
        this.coroutineScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CoroutineScope>(this){
            final /* synthetic */ Messages this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final CoroutineScope invoke() {
                return this.this$0.nativeGetConversationsClient().getCoroutineScope();
            }
        }));
    }

    private final MediaClient getMediaClient() {
        Lazy lazy = this.mediaClient$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mediaClient>(...)");
        return (MediaClient)object;
    }

    private final CoroutineScope getCoroutineScope() {
        Lazy lazy = this.coroutineScope$delegate;
        return (CoroutineScope)lazy.getValue();
    }

    private final ErrorInfo checkMessageExceedsLimits(MessageDescriptor messageDescriptor) {
        ConversationLimits conversationLimits = this.nativeGetConversation().getLimits();
        if (conversationLimits == null) {
            return null;
        }
        Set disallowedEmailBodies = CollectionsKt.subtract((Iterable)messageDescriptor.getEmailBodies().keySet(), (Iterable)conversationLimits.getEmailBodiesAllowedContentTypes());
        if (!((Collection)disallowedEmailBodies).isEmpty()) {
            TwilioLogger.e$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)(disallowedEmailBodies + " are not allowed email body types. See ConversationLimits.emailBodiesAllowedContentTypes."), null, (int)2, null);
            return new ErrorInfo(ErrorReason.UnsupportedEmailBodyContentType, 0, ErrorInfo.Companion.getUNSUPPORTED_EMAIL_BODY_CONTENT_TYPE(), "Unsupported email body content type(s) " + disallowedEmailBodies, null, 18, null);
        }
        Set disallowedEmailHistories = CollectionsKt.subtract((Iterable)messageDescriptor.getEmailHistories().keySet(), (Iterable)conversationLimits.getEmailHistoriesAllowedContentTypes());
        if (!((Collection)disallowedEmailHistories).isEmpty()) {
            TwilioLogger.e$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)(disallowedEmailHistories + " are not allowed email history types. See ConversationLimits.emailHistoriesAllowedContentTypes."), null, (int)2, null);
            return new ErrorInfo(ErrorReason.UnsupportedEmailHistoryContentType, 0, ErrorInfo.Companion.getUNSUPPORTED_EMAIL_HISTORY_CONTENT_TYPE(), "Unsupported email history content type(s) " + disallowedEmailHistories, null, 18, null);
        }
        int attachmentsCount = messageDescriptor.getAllMedias().size();
        if (attachmentsCount > conversationLimits.getMediaAttachmentsCountLimit()) {
            TwilioLogger.e$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("Attachments count (" + attachmentsCount + ") exceeds maximum attachments count limit (" + conversationLimits.getMediaAttachmentsCountLimit() + "). See ConversationLimits.mediaAttachmentsCountLimit."), null, (int)2, null);
            return new ErrorInfo(ErrorReason.TooManyAttachments, 0, ErrorInfo.Companion.getTOO_MANY_ATTACHMENTS(), "Too many media attachments in the message (" + attachmentsCount + " > " + conversationLimits.getMediaAttachmentsCountLimit() + ')', null, 18, null);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendMessage(MessageDescriptor var1_1, CallbackListener<Message> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof sendMessage.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ Messages this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Messages.access$sendMessage(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.checkMessageExceedsLimits(messageDescriptor);
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-Messages$sendMessage$2 = false;
                    listener.onError(it);
                    return Unit.INSTANCE;
                }
                var5_15 = this;
                $this$sendMessage_u24lambda_u241 = var5_15;
                $i$a$-runCatching-Messages$sendMessage$result$1 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = messageDescriptor;
                $continuation.L$2 = listener;
                $continuation.label = 1;
                v1 = super.getMediaClient().upload(messageDescriptor.getAllMedias(), (Continuation<? super List<String>>)$continuation);
                ** if (v1 != var13_6) goto lbl31
lbl30:
                // 1 sources

                return var13_6;
lbl31:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                $i$a$-runCatching-Messages$sendMessage$result$1 = false;
                listener = (CallbackListener)$continuation.L$2;
                messageDescriptor = (MessageDescriptor)$continuation.L$1;
                this = (Messages)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    $this$sendMessage_u24lambda_u241 = Result.constructor-impl((Object)((List)v1));
                }
                catch (Throwable $i$a$-runCatching-Messages$sendMessage$result$1) {
                    $this$sendMessage_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-Messages$sendMessage$result$1));
                }
                $this$sendMessage_u24lambda_u241 = result = $this$sendMessage_u24lambda_u241;
                v2 = Result.exceptionOrNull-impl((Object)$this$sendMessage_u24lambda_u241);
                if (v2 == null) break;
                t = v2;
                $i$a$-getOrElse-Messages$sendMessage$mediaSids$1 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = listener;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v3 = InternalUtilsKt.toTwilioException((Throwable)t, (ErrorReason)ErrorReason.MediaUploadError, (Continuation)$continuation);
                if (v3 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl65
            }
            case 2: {
                $i$a$-getOrElse-Messages$sendMessage$mediaSids$1 = false;
                listener = (CallbackListener)$continuation.L$1;
                this = (Messages)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl65:
                // 2 sources

                errorInfo = WhenMappings.$EnumSwitchMapping$0[(exception = (TwilioException)v3).getErrorInfo().getReason().ordinal()] == 1 ? new ErrorInfo(ErrorReason.Cancelled, 0, 0, "Message sending has been cancelled", null, 22, null) : new ErrorInfo(ErrorReason.MediaUploadError, 0, ErrorInfo.Companion.getMEDIA_UPLOAD_ERROR(), "Cannot upload one or more media files", null, 18, null);
                TwilioLoggerKt.getLogger((Object)this).e(String.valueOf(errorInfo), (Throwable)exception);
                listener.onError(errorInfo);
                return Unit.INSTANCE;
            }
        }
        mediaSids = (List)$this$sendMessage_u24lambda_u241;
        this.checkDisposed("sendMessage");
        $this$toTypedArray$iv = mediaSids;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        this.nativeSendMessage(MessageDescriptor.copy$default(messageDescriptor, null, null, null, null, null, null, thisCollection$iv.toArray(new String[0]), null, null, 447, null), listener);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Messages messages = this;
        synchronized (messages) {
            boolean bl = false;
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void checkDisposed(String method) {
        if (this.isDisposed) {
            TwilioLogger.e$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("Attempt to use disposed object in Messages#" + method), null, (int)2, null);
        }
    }

    @NotNull
    public final native ConversationsClientImpl nativeGetConversationsClient();

    @NotNull
    public final native ConversationImpl nativeGetConversation();

    public final native void nativeSendMessage(@NotNull MessageDescriptor var1, @NotNull CallbackListener<Message> var2);

    public final native void nativeRemoveMessage(@NotNull Message var1, @NotNull StatusListener var2);

    public final native void nativeGetMessagesBefore(long var1, int var3, @NotNull CallbackListener<List<Message>> var4);

    public final native void nativeGetMessagesAfter(long var1, int var3, @NotNull CallbackListener<List<Message>> var4);

    public final native void nativeGetLastMessages(int var1, @NotNull CallbackListener<List<Message>> var2);

    public final native void nativeGetMessageByIndex(long var1, @NotNull CallbackListener<Message> var3);

    @Nullable
    public final native Long nativeGetLastConsumedMessageIndex();

    public final native void nativeSetLastConsumedMessageIndexWithResult(long var1, @NotNull CallbackListener<Long> var3);

    public final native void nativeAdvanceLastConsumedMessageIndexWithResult(long var1, @NotNull CallbackListener<Long> var3);

    public final native void nativeSetAllMessagesConsumedWithResult(@NotNull CallbackListener<Long> var1);

    public final native void nativeSetNoMessagesConsumedWithResult(@NotNull CallbackListener<Long> var1);

    public final native void nativeDispose();

    public static final /* synthetic */ Object access$sendMessage(Messages $this, MessageDescriptor messageDescriptor, CallbackListener listener, Continuation $completion) {
        return $this.sendMessage(messageDescriptor, listener, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\f\u0010\u000e\u001a\u00060\u000fR\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u0014\u0010\u0015\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00060\u0000R\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u001a\u001a\u00060\u0000R\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u001a\u001a\u00060\u0000R\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016J&\u0010\u001f\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u001f\u001a\u00060\u0000R\u00020\u00062\u0006\u0010 \u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010!\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010!\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010#\u001a\u00060\u0000R\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/twilio/conversations/Messages$MessageBuilderImpl;", "Lcom/twilio/conversations/Conversation$MessageBuilder;", "(Lcom/twilio/conversations/Messages;)V", "messageDescriptor", "Lcom/twilio/conversations/Messages$MessageDescriptor;", "addMedia", "Lcom/twilio/conversations/Messages;", "inputStream", "Ljava/io/InputStream;", "contentType", "", "filename", "uploadListener", "Lcom/twilio/conversations/MediaUploadListener;", "build", "Lcom/twilio/conversations/Messages$UnsentMessageImpl;", "buildAndSend", "Lcom/twilio/conversations/CancellationToken;", "listener", "Lcom/twilio/conversations/CallbackListener;", "Lcom/twilio/conversations/Message;", "setAttributes", "attributes", "Lcom/twilio/conversations/Attributes;", "setBody", "body", "setContentTemplate", "contentTemplateSid", "variables", "", "Lcom/twilio/conversations/content/ContentTemplateVariable;", "setEmailBody", "emailBody", "setEmailHistory", "emailHistory", "setSubject", "subject", "convo-android_release"})
    @SourceDebugExtension(value={"SMAP\nMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages$MessageBuilderImpl\n+ 2 mediaFactory.kt\ncom/twilio/conversations/media/MediaFactoryKt\n+ 3 mediaFactory.kt\ncom/twilio/conversations/media/MediaFactoryKt$createMediaUploadItem$1\n*L\n1#1,265:1\n44#2,8:266\n44#2,8:275\n49#3:274\n49#3:283\n*S KotlinDebug\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages$MessageBuilderImpl\n*L\n178#1:266,8\n194#1:275,8\n178#1:274\n194#1:283\n*E\n"})
    public final class MessageBuilderImpl
    implements Conversation.MessageBuilder {
        @NotNull
        private MessageDescriptor messageDescriptor = new MessageDescriptor(null, null, null, null, null, null, null, null, null, 511, null);

        @Override
        @NotNull
        public MessageBuilderImpl setBody(@Nullable String body) {
            MessageBuilderImpl messageBuilderImpl;
            MessageBuilderImpl $this$setBody_u24lambda_u240 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setBody_u24lambda_u240.messageDescriptor = MessageDescriptor.copy$default($this$setBody_u24lambda_u240.messageDescriptor, body, null, null, null, null, null, null, null, null, 510, null);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl setSubject(@Nullable String subject) {
            MessageBuilderImpl messageBuilderImpl;
            MessageBuilderImpl $this$setSubject_u24lambda_u241 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setSubject_u24lambda_u241.messageDescriptor = MessageDescriptor.copy$default($this$setSubject_u24lambda_u241.messageDescriptor, null, subject, null, null, null, null, null, null, null, 509, null);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl setAttributes(@NotNull Attributes attributes) {
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            MessageBuilderImpl $this$setAttributes_u24lambda_u242 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setAttributes_u24lambda_u242.messageDescriptor = MessageDescriptor.copy$default($this$setAttributes_u24lambda_u242.messageDescriptor, null, null, attributes, null, null, null, null, null, null, 507, null);
            return messageBuilderImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public MessageBuilderImpl setEmailBody(@NotNull String emailBody, @NotNull String contentType) {
            void inputStream$iv;
            MediaUploadListenerBuilder mediaUploadListenerBuilder;
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)emailBody, (String)"emailBody");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            MessageBuilderImpl $this$setEmailBody_u24lambda_u243 = messageBuilderImpl = this;
            boolean bl = false;
            Map<String, MediaUploadItem> map = $this$setEmailBody_u24lambda_u243.messageDescriptor.getEmailBodies();
            Object object = emailBody;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = new ByteArrayInputStream(byArray);
            MediaCategory category$iv = MediaCategory.BODY;
            String filename$iv = "";
            boolean $i$f$createMediaUploadItem = false;
            MediaUploadListenerBuilder mediaUploadListenerBuilder2 = mediaUploadListenerBuilder = new MediaUploadListenerBuilder();
            String string = filename$iv;
            MediaCategory mediaCategory = category$iv;
            String string2 = contentType;
            Input input2 = InputKt.asInput$default((InputStream)inputStream$iv, null, (int)1, null);
            boolean bl2 = false;
            MediaUploadListenerBuilder $this$null = mediaUploadListenerBuilder2;
            Unit unit = Unit.INSTANCE;
            MediaUploadListener mediaUploadListener = mediaUploadListenerBuilder.build();
            String string3 = string;
            MediaCategory mediaCategory2 = mediaCategory;
            String string4 = string2;
            Input input3 = input2;
            object = new MediaUploadItem(input3, string4, mediaCategory2, string3, mediaUploadListener);
            map.put(contentType, (MediaUploadItem)object);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl setEmailBody(@NotNull InputStream inputStream, @NotNull String contentType, @Nullable MediaUploadListener uploadListener) {
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            MessageBuilderImpl $this$setEmailBody_u24lambda_u244 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setEmailBody_u24lambda_u244.messageDescriptor.getEmailBodies().put(contentType, new MediaUploadItem(InputKt.asInput$default((InputStream)inputStream, null, (int)1, null), contentType, MediaCategory.BODY, null, new MediaUploadListenerForwarder(uploadListener), 8, null));
            return messageBuilderImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public MessageBuilderImpl setEmailHistory(@NotNull String emailHistory, @NotNull String contentType) {
            void inputStream$iv;
            MediaUploadListenerBuilder mediaUploadListenerBuilder;
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)emailHistory, (String)"emailHistory");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            MessageBuilderImpl $this$setEmailHistory_u24lambda_u245 = messageBuilderImpl = this;
            boolean bl = false;
            Map<String, MediaUploadItem> map = $this$setEmailHistory_u24lambda_u245.messageDescriptor.getEmailHistories();
            Object object = emailHistory;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = new ByteArrayInputStream(byArray);
            MediaCategory category$iv = MediaCategory.HISTORY;
            String filename$iv = "";
            boolean $i$f$createMediaUploadItem = false;
            MediaUploadListenerBuilder mediaUploadListenerBuilder2 = mediaUploadListenerBuilder = new MediaUploadListenerBuilder();
            String string = filename$iv;
            MediaCategory mediaCategory = category$iv;
            String string2 = contentType;
            Input input2 = InputKt.asInput$default((InputStream)inputStream$iv, null, (int)1, null);
            boolean bl2 = false;
            MediaUploadListenerBuilder $this$null = mediaUploadListenerBuilder2;
            Unit unit = Unit.INSTANCE;
            MediaUploadListener mediaUploadListener = mediaUploadListenerBuilder.build();
            String string3 = string;
            MediaCategory mediaCategory2 = mediaCategory;
            String string4 = string2;
            Input input3 = input2;
            object = new MediaUploadItem(input3, string4, mediaCategory2, string3, mediaUploadListener);
            map.put(contentType, (MediaUploadItem)object);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl setEmailHistory(@NotNull InputStream inputStream, @NotNull String contentType, @Nullable MediaUploadListener uploadListener) {
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            MessageBuilderImpl $this$setEmailHistory_u24lambda_u246 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setEmailHistory_u24lambda_u246.messageDescriptor.getEmailHistories().put(contentType, new MediaUploadItem(InputKt.asInput$default((InputStream)inputStream, null, (int)1, null), contentType, MediaCategory.HISTORY, null, new MediaUploadListenerForwarder(uploadListener), 8, null));
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl addMedia(@NotNull InputStream inputStream, @NotNull String contentType, @Nullable String filename, @Nullable MediaUploadListener uploadListener) {
            MessageBuilderImpl messageBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            MessageBuilderImpl $this$addMedia_u24lambda_u247 = messageBuilderImpl = this;
            boolean bl = false;
            MediaUploadItem item = new MediaUploadItem(InputKt.asInput$default((InputStream)inputStream, null, (int)1, null), contentType, MediaCategory.MEDIA, filename, new MediaUploadListenerForwarder(uploadListener));
            List medias = CollectionsKt.plus((Collection)$this$addMedia_u24lambda_u247.messageDescriptor.getAttachedMedias(), (Object)item);
            $this$addMedia_u24lambda_u247.messageDescriptor = MessageDescriptor.copy$default($this$addMedia_u24lambda_u247.messageDescriptor, null, null, null, null, null, medias, null, null, null, 479, null);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public MessageBuilderImpl setContentTemplate(@Nullable String contentTemplateSid) {
            return this.setContentTemplate(contentTemplateSid, (List)null);
        }

        @Override
        @NotNull
        public MessageBuilderImpl setContentTemplate(@Nullable String contentTemplateSid, @Nullable List<ContentTemplateVariable> variables) {
            MessageBuilderImpl messageBuilderImpl;
            MessageBuilderImpl $this$setContentTemplate_u24lambda_u248 = messageBuilderImpl = this;
            boolean bl = false;
            $this$setContentTemplate_u24lambda_u248.messageDescriptor = MessageDescriptor.copy$default($this$setContentTemplate_u24lambda_u248.messageDescriptor, null, null, null, null, null, null, null, contentTemplateSid, variables, 127, null);
            return messageBuilderImpl;
        }

        @Override
        @NotNull
        public UnsentMessageImpl build() {
            return new UnsentMessageImpl(this.messageDescriptor);
        }

        @Override
        @NotNull
        public CancellationToken buildAndSend(@Nullable CallbackListener<Message> listener) {
            return this.build().send(listener);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0015\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u00c6\u0003J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u00100\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fH\u00c6\u0003J\u009a\u0001\u00101\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u000207H\u00d6\u0001J\t\u00108\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001b\u00a8\u00069"}, d2={"Lcom/twilio/conversations/Messages$MessageDescriptor;", "", "body", "", "subject", "attributes", "Lcom/twilio/conversations/Attributes;", "emailBodies", "", "Lcom/twilio/conversations/media/MediaUploadItem;", "emailHistories", "attachedMedias", "", "mediaSids", "", "contentSid", "contentVariables", "Lcom/twilio/conversations/content/ContentTemplateVariable;", "(Ljava/lang/String;Ljava/lang/String;Lcom/twilio/conversations/Attributes;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;[Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "allMedias", "getAllMedias", "()Ljava/util/List;", "getAttachedMedias", "getAttributes", "()Lcom/twilio/conversations/Attributes;", "attributesAsString", "getAttributesAsString", "()Ljava/lang/String;", "getBody", "getContentSid", "getContentVariables", "contentVariablesAsString", "getContentVariablesAsString", "getEmailBodies", "()Ljava/util/Map;", "getEmailHistories", "getMediaSids", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getSubject", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/twilio/conversations/Attributes;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;[Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)Lcom/twilio/conversations/Messages$MessageDescriptor;", "equals", "", "other", "hashCode", "", "toString", "convo-android_release"})
    @SourceDebugExtension(value={"SMAP\nMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages$MessageDescriptor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,265:1\n26#2:266\n1179#3,2:267\n1253#3,4:269\n1#4:273\n113#5:274\n*S KotlinDebug\n*F\n+ 1 Messages.kt\ncom/twilio/conversations/Messages$MessageDescriptor\n*L\n149#1:266\n155#1:267,2\n155#1:269,4\n155#1:274\n*E\n"})
    public static final class MessageDescriptor {
        @Nullable
        private final String body;
        @Nullable
        private final String subject;
        @NotNull
        private final Attributes attributes;
        @NotNull
        private final Map<String, MediaUploadItem> emailBodies;
        @NotNull
        private final Map<String, MediaUploadItem> emailHistories;
        @NotNull
        private final List<MediaUploadItem> attachedMedias;
        @NotNull
        private final String[] mediaSids;
        @Nullable
        private final String contentSid;
        @Nullable
        private final List<ContentTemplateVariable> contentVariables;

        public MessageDescriptor(@Nullable String body, @Nullable String subject, @NotNull Attributes attributes, @NotNull Map<String, MediaUploadItem> emailBodies, @NotNull Map<String, MediaUploadItem> emailHistories, @NotNull List<MediaUploadItem> attachedMedias, @NotNull String[] mediaSids, @Nullable String contentSid, @Nullable List<ContentTemplateVariable> contentVariables) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(emailBodies, (String)"emailBodies");
            Intrinsics.checkNotNullParameter(emailHistories, (String)"emailHistories");
            Intrinsics.checkNotNullParameter(attachedMedias, (String)"attachedMedias");
            Intrinsics.checkNotNullParameter((Object)mediaSids, (String)"mediaSids");
            this.body = body;
            this.subject = subject;
            this.attributes = attributes;
            this.emailBodies = emailBodies;
            this.emailHistories = emailHistories;
            this.attachedMedias = attachedMedias;
            this.mediaSids = mediaSids;
            this.contentSid = contentSid;
            this.contentVariables = contentVariables;
        }

        public /* synthetic */ MessageDescriptor(String string, String string2, Attributes attributes, Map map, Map map2, List list, String[] stringArray, String string3, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                Attributes attributes2 = Attributes.DEFAULT;
                Intrinsics.checkNotNullExpressionValue((Object)attributes2, (String)"DEFAULT");
                attributes = attributes2;
            }
            if ((n & 8) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 0x10) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n & 0x20) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x40) != 0) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            }
            if ((n & 0x80) != 0) {
                string3 = null;
            }
            if ((n & 0x100) != 0) {
                list2 = null;
            }
            this(string, string2, attributes, map, map2, list, stringArray, string3, list2);
        }

        @Nullable
        public final String getBody() {
            return this.body;
        }

        @Nullable
        public final String getSubject() {
            return this.subject;
        }

        @NotNull
        public final Attributes getAttributes() {
            return this.attributes;
        }

        @NotNull
        public final Map<String, MediaUploadItem> getEmailBodies() {
            return this.emailBodies;
        }

        @NotNull
        public final Map<String, MediaUploadItem> getEmailHistories() {
            return this.emailHistories;
        }

        @NotNull
        public final List<MediaUploadItem> getAttachedMedias() {
            return this.attachedMedias;
        }

        @NotNull
        public final String[] getMediaSids() {
            return this.mediaSids;
        }

        @Nullable
        public final String getContentSid() {
            return this.contentSid;
        }

        @Nullable
        public final List<ContentTemplateVariable> getContentVariables() {
            return this.contentVariables;
        }

        @NotNull
        public final String getAttributesAsString() {
            return String.valueOf(this.attributes);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getContentVariablesAsString() {
            String string;
            List<ContentTemplateVariable> list = this.contentVariables;
            if (list != null) {
                void $this$associateTo$iv$iv;
                List<ContentTemplateVariable> vars = list;
                boolean bl = false;
                Iterable $this$associate$iv = vars;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    ContentTemplateVariable it = (ContentTemplateVariable)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map it = destination$iv$iv;
                boolean bl3 = false;
                StringFormat $this$encodeToString$iv = (StringFormat)InternalUtilsKt.getJson();
                boolean $i$f$encodeToString = false;
                $this$encodeToString$iv.getSerializersModule();
                string = $this$encodeToString$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), (Object)it);
            } else {
                string = null;
            }
            return string;
        }

        @NotNull
        public final List<MediaUploadItem> getAllMedias() {
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.attachedMedias, (Iterable)this.emailBodies.values()), (Iterable)this.emailHistories.values());
        }

        @Nullable
        public final String component1() {
            return this.body;
        }

        @Nullable
        public final String component2() {
            return this.subject;
        }

        @NotNull
        public final Attributes component3() {
            return this.attributes;
        }

        @NotNull
        public final Map<String, MediaUploadItem> component4() {
            return this.emailBodies;
        }

        @NotNull
        public final Map<String, MediaUploadItem> component5() {
            return this.emailHistories;
        }

        @NotNull
        public final List<MediaUploadItem> component6() {
            return this.attachedMedias;
        }

        @NotNull
        public final String[] component7() {
            return this.mediaSids;
        }

        @Nullable
        public final String component8() {
            return this.contentSid;
        }

        @Nullable
        public final List<ContentTemplateVariable> component9() {
            return this.contentVariables;
        }

        @NotNull
        public final MessageDescriptor copy(@Nullable String body, @Nullable String subject, @NotNull Attributes attributes, @NotNull Map<String, MediaUploadItem> emailBodies, @NotNull Map<String, MediaUploadItem> emailHistories, @NotNull List<MediaUploadItem> attachedMedias, @NotNull String[] mediaSids, @Nullable String contentSid, @Nullable List<ContentTemplateVariable> contentVariables) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(emailBodies, (String)"emailBodies");
            Intrinsics.checkNotNullParameter(emailHistories, (String)"emailHistories");
            Intrinsics.checkNotNullParameter(attachedMedias, (String)"attachedMedias");
            Intrinsics.checkNotNullParameter((Object)mediaSids, (String)"mediaSids");
            return new MessageDescriptor(body, subject, attributes, emailBodies, emailHistories, attachedMedias, mediaSids, contentSid, contentVariables);
        }

        public static /* synthetic */ MessageDescriptor copy$default(MessageDescriptor messageDescriptor, String string, String string2, Attributes attributes, Map map, Map map2, List list, String[] stringArray, String string3, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = messageDescriptor.body;
            }
            if ((n & 2) != 0) {
                string2 = messageDescriptor.subject;
            }
            if ((n & 4) != 0) {
                attributes = messageDescriptor.attributes;
            }
            if ((n & 8) != 0) {
                map = messageDescriptor.emailBodies;
            }
            if ((n & 0x10) != 0) {
                map2 = messageDescriptor.emailHistories;
            }
            if ((n & 0x20) != 0) {
                list = messageDescriptor.attachedMedias;
            }
            if ((n & 0x40) != 0) {
                stringArray = messageDescriptor.mediaSids;
            }
            if ((n & 0x80) != 0) {
                string3 = messageDescriptor.contentSid;
            }
            if ((n & 0x100) != 0) {
                list2 = messageDescriptor.contentVariables;
            }
            return messageDescriptor.copy(string, string2, attributes, map, map2, list, stringArray, string3, list2);
        }

        @NotNull
        public String toString() {
            return "MessageDescriptor(body=" + this.body + ", subject=" + this.subject + ", attributes=" + this.attributes + ", emailBodies=" + this.emailBodies + ", emailHistories=" + this.emailHistories + ", attachedMedias=" + this.attachedMedias + ", mediaSids=" + Arrays.toString(this.mediaSids) + ", contentSid=" + this.contentSid + ", contentVariables=" + this.contentVariables + ')';
        }

        public int hashCode() {
            int result = this.body == null ? 0 : this.body.hashCode();
            result = result * 31 + (this.subject == null ? 0 : this.subject.hashCode());
            result = result * 31 + this.attributes.hashCode();
            result = result * 31 + ((Object)this.emailBodies).hashCode();
            result = result * 31 + ((Object)this.emailHistories).hashCode();
            result = result * 31 + ((Object)this.attachedMedias).hashCode();
            result = result * 31 + Arrays.hashCode(this.mediaSids);
            result = result * 31 + (this.contentSid == null ? 0 : this.contentSid.hashCode());
            result = result * 31 + (this.contentVariables == null ? 0 : ((Object)this.contentVariables).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageDescriptor)) {
                return false;
            }
            MessageDescriptor messageDescriptor = (MessageDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.body, (Object)messageDescriptor.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.subject, (Object)messageDescriptor.subject)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.attributes, (Object)messageDescriptor.attributes)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.emailBodies, messageDescriptor.emailBodies)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.emailHistories, messageDescriptor.emailHistories)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.attachedMedias, messageDescriptor.attachedMedias)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mediaSids, (Object)messageDescriptor.mediaSids)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentSid, (Object)messageDescriptor.contentSid)) {
                return false;
            }
            return Intrinsics.areEqual(this.contentVariables, messageDescriptor.contentVariables);
        }

        public MessageDescriptor() {
            this(null, null, null, null, null, null, null, null, null, 511, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/twilio/conversations/Messages$UnsentMessageImpl;", "Lcom/twilio/conversations/Conversation$UnsentMessage;", "messageDescriptor", "Lcom/twilio/conversations/Messages$MessageDescriptor;", "(Lcom/twilio/conversations/Messages;Lcom/twilio/conversations/Messages$MessageDescriptor;)V", "getMessageDescriptor", "()Lcom/twilio/conversations/Messages$MessageDescriptor;", "send", "Lcom/twilio/conversations/CancellationToken;", "listener", "Lcom/twilio/conversations/CallbackListener;", "Lcom/twilio/conversations/Message;", "convo-android_release"})
    public final class UnsentMessageImpl
    implements Conversation.UnsentMessage {
        @NotNull
        private final MessageDescriptor messageDescriptor;

        public UnsentMessageImpl(MessageDescriptor messageDescriptor) {
            Intrinsics.checkNotNullParameter((Object)messageDescriptor, (String)"messageDescriptor");
            this.messageDescriptor = messageDescriptor;
        }

        @NotNull
        public final MessageDescriptor getMessageDescriptor() {
            return this.messageDescriptor;
        }

        @Override
        @NotNull
        public CancellationToken send(@Nullable CallbackListener<Message> listener) {
            CallbackListenerForwarder<Message> listenerForwarder = new CallbackListenerForwarder<Message>(listener);
            CoroutineScope coroutineScope2 = Messages.this.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"coroutineScope");
            Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(Messages.this, this, listenerForwarder, null){
                int label;
                final /* synthetic */ Messages this$0;
                final /* synthetic */ UnsentMessageImpl this$1;
                final /* synthetic */ CallbackListenerForwarder<Message> $listenerForwarder;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$listenerForwarder = $listenerForwarder;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = Messages.access$sendMessage(this.this$0, this.this$1.getMessageDescriptor(), this.$listenerForwarder, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return () -> UnsentMessageImpl.send$lambda$0(job2);
        }

        private static final void send$lambda$0(Job $job) {
            Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
            Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorReason.values().length];
            try {
                nArray[ErrorReason.Cancelled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

