/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.ConversationLimits;
import com.twilio.conversations.ConversationListener;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.ListenerException;
import com.twilio.conversations.Message;
import com.twilio.conversations.Messages;
import com.twilio.conversations.Participant;
import com.twilio.conversations.Participants;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.internal.CallbackListenerForwarder;
import com.twilio.conversations.internal.DateUtils;
import com.twilio.conversations.internal.HandlerUtil;
import com.twilio.conversations.internal.RethrowingForwarder;
import com.twilio.conversations.internal.StatusListenerForwarder;
import com.twilio.util.TwilioLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.json.JSONException;

final class ConversationImpl
implements Conversation,
Disposable {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(ConversationImpl.class));
    protected long nativeHandle;
    private boolean isDisposed = false;
    private ConversationListenerForwarder listenerForwarder;

    protected ConversationImpl(long handle) {
        this.nativeHandle = handle;
        this.listenerForwarder = new ConversationListenerForwarder();
    }

    @Override
    public native String getSid();

    @Override
    public native String getFriendlyName();

    @Override
    public native Conversation.NotificationLevel getNotificationLevel();

    @Override
    public void setFriendlyName(String friendlyName, StatusListener listener) {
        this.checkDisposed("setFriendlyName");
        this.nativeSetFriendlyName(friendlyName, new StatusListenerForwarder(listener));
    }

    @Override
    public void setNotificationLevel(Conversation.NotificationLevel notificationLevel, StatusListener listener) {
        this.checkDisposed("setNotificationLevel");
        this.nativeSetNotificationLevel(notificationLevel, new StatusListenerForwarder(listener));
    }

    @Override
    public native String getUniqueName();

    @Override
    public ConversationLimits getLimits() {
        this.checkDisposed("getConversationLimits");
        return this.nativeGetConversationLimits();
    }

    @Override
    public void setUniqueName(String uniqueName, StatusListener listener) {
        this.checkDisposed("setUniqueName");
        this.nativeSetUniqueName(uniqueName, new StatusListenerForwarder(listener));
    }

    @Override
    @NonNull
    public Attributes getAttributes() {
        this.checkDisposed("getAttributes");
        String attrString = this.nativeGetAttributes();
        try {
            return Attributes.parse(attrString);
        }
        catch (JSONException e) {
            logger.e("Unable to parse conversation attributes", (Throwable)e);
            return Attributes.DEFAULT;
        }
    }

    @Override
    public void setAttributes(@NonNull Attributes attributes, StatusListener listener) {
        this.checkDisposed("setAttributes");
        this.nativeSetAttributes(attributes.toString(), new StatusListenerForwarder(listener));
    }

    @Override
    public native Conversation.ConversationStatus getStatus();

    @Override
    public native Conversation.ConversationState getState();

    @Override
    @Nullable
    public native Date getStateDateUpdatedAsDate();

    @Override
    public void addListener(ConversationListener listener) {
        this.checkDisposed("addListener");
        if (listener == null) {
            return;
        }
        this.listenerForwarder.addListener(this.getSid(), listener, HandlerUtil.setupListenerHandler());
        ConversationListener rethrowingListener = RethrowingForwarder.create(listener, ListenerException.class);
        rethrowingListener.onSynchronizationChanged(this);
    }

    @Override
    public void removeListener(ConversationListener listener) {
        this.checkDisposed("removeListener");
        this.listenerForwarder.removeListener(this.getSid(), listener);
    }

    @Override
    public void removeAllListeners() {
        this.checkDisposed("removeAllListeners");
        this.listenerForwarder.removeAllListeners(this.getSid());
    }

    @Override
    public void join(StatusListener listener) {
        this.checkDisposed("join");
        this.nativeJoin(new StatusListenerForwarder(listener));
    }

    @Override
    public void leave(StatusListener listener) {
        this.checkDisposed("leave");
        this.nativeLeave(new StatusListenerForwarder(listener));
    }

    @Override
    public void destroy(StatusListener listener) {
        this.checkDisposed("destroy");
        this.nativeDestroy(new StatusListenerForwarder(listener));
    }

    @Override
    public native void typing();

    @Override
    public native Conversation.SynchronizationStatus getSynchronizationStatus();

    @Override
    public native String getDateCreated();

    @Override
    public Date getDateCreatedAsDate() {
        this.checkDisposed("getDateCreatedAsDate");
        return DateUtils.parseIso8601DateTime(this.getDateCreated());
    }

    @Override
    public native String getCreatedBy();

    @Override
    public native String getDateUpdated();

    @Override
    public Date getDateUpdatedAsDate() {
        this.checkDisposed("getDateUpdatedAsDate");
        return DateUtils.parseIso8601DateTime(this.getDateUpdated());
    }

    @Override
    public Date getLastMessageDate() {
        this.checkDisposed("getLastMessageDate");
        String date = this.nativeGetLastMessageDate();
        if (date == null) {
            return null;
        }
        return DateUtils.parseIso8601DateTime(date);
    }

    @Override
    public native Long getLastMessageIndex();

    @Override
    public void getMessagesCount(CallbackListener<Long> listener) {
        this.checkDisposed("getMessagesCount");
        this.nativeGetMessagesCount(new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void getUnreadMessagesCount(CallbackListener<Long> listener) {
        this.checkDisposed("getUnreadMessagesCount");
        this.nativeGetUnconsumedMessagesCount(new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void getParticipantsCount(CallbackListener<Long> listener) {
        this.checkDisposed("getParticipantsCount");
        this.nativeGetMembersCount(new CallbackListenerForwarder<Long>(listener));
    }

    private Messages getMessages() {
        Messages messages = this.nativeGetMessages();
        if (messages == null) {
            throw new IllegalStateException("Messages are not available at the moment. Synchronize the conversation first.");
        }
        return messages;
    }

    @Override
    public Conversation.MessageBuilder prepareMessage() {
        this.checkDisposed("prepareMessage");
        return this.getMessages().new Messages.MessageBuilderImpl();
    }

    @Override
    public void removeMessage(Message message, StatusListener listener) {
        this.checkDisposed("removeMessage");
        this.getMessages().nativeRemoveMessage(message, new StatusListenerForwarder(listener));
    }

    @Override
    public Long getLastReadMessageIndex() {
        this.checkDisposed("getLastReadMessageIndex");
        return this.getMessages().nativeGetLastConsumedMessageIndex();
    }

    @Override
    public void setLastReadMessageIndex(long lastReadMessageIndex, CallbackListener<Long> listener) {
        this.checkDisposed("setLastReadMessageIndex");
        this.getMessages().nativeSetLastConsumedMessageIndexWithResult(lastReadMessageIndex, new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void advanceLastReadMessageIndex(long lastReadMessageIndex, CallbackListener<Long> listener) {
        this.checkDisposed("advanceLastReadMessageIndex");
        this.getMessages().nativeAdvanceLastConsumedMessageIndexWithResult(lastReadMessageIndex, new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void setAllMessagesRead(CallbackListener<Long> listener) {
        this.checkDisposed("setAllMessagesRead");
        this.getMessages().nativeSetAllMessagesConsumedWithResult(new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void setAllMessagesUnread(CallbackListener<Long> listener) {
        this.checkDisposed("setAllMessagesUnread");
        this.getMessages().nativeSetNoMessagesConsumedWithResult(new CallbackListenerForwarder<Long>(listener));
    }

    @Override
    public void getMessagesBefore(long index, int count, @NonNull CallbackListener<List<Message>> listener) {
        this.checkDisposed("getMessagesBefore");
        this.getMessages().nativeGetMessagesBefore(index, count, new CallbackListenerForwarder<List<Message>>(listener));
    }

    @Override
    public void getMessagesAfter(long index, int count, @NonNull CallbackListener<List<Message>> listener) {
        this.checkDisposed("getMessagesAfter");
        this.getMessages().nativeGetMessagesAfter(index, count, new CallbackListenerForwarder<List<Message>>(listener));
    }

    @Override
    public void getLastMessages(int count, @NonNull CallbackListener<List<Message>> listener) {
        this.checkDisposed("getLastMessages");
        this.getMessages().nativeGetLastMessages(count, new CallbackListenerForwarder<List<Message>>(listener));
    }

    @Override
    public void getMessageByIndex(long index, @NonNull CallbackListener<Message> listener) {
        this.checkDisposed("getMessageByIndex");
        this.getMessages().nativeGetMessageByIndex(index, new CallbackListenerForwarder<Message>(listener));
    }

    private Participants getParticipants() {
        Participants participants = this.nativeGetMembers();
        if (participants == null) {
            throw new IllegalStateException("Participants are not available at the moment. Synchronize the conversation first.");
        }
        return participants;
    }

    @Override
    public List<Participant> getParticipantsList() {
        return this.getParticipants().nativeGetMembersList();
    }

    @Override
    public Participant getParticipantByIdentity(String identity) {
        return this.getParticipants().nativeGetMember(identity);
    }

    @Override
    public Participant getParticipantBySid(String sid) {
        return this.getParticipants().nativeGetMemberBySid(sid);
    }

    @Override
    public void addParticipantByIdentity(String identity, Attributes attributes, StatusListener listener) {
        this.checkDisposed("addParticipantByIdentity");
        if (attributes == null) {
            attributes = Attributes.DEFAULT;
        }
        this.getParticipants().nativeAddByIdentity(identity, attributes.toString(), new StatusListenerForwarder(listener));
    }

    @Override
    public void addParticipantByAddress(String address, String proxyAddress, Attributes attributes, StatusListener listener) {
        this.checkDisposed("addParticipantByAddress");
        if (attributes == null) {
            attributes = Attributes.DEFAULT;
        }
        this.getParticipants().nativeAddByAddress(address, proxyAddress, attributes.toString(), new StatusListenerForwarder(listener));
    }

    @Override
    public void removeParticipant(Participant participant, StatusListener listener) {
        this.checkDisposed("removeParticipant");
        this.getParticipants().nativeRemove(participant, new StatusListenerForwarder(listener));
    }

    @Override
    public void removeParticipantByIdentity(String identity, StatusListener listener) {
        this.checkDisposed("removeParticipantByIdentity");
        this.getParticipants().nativeRemoveByIdentity(identity, new StatusListenerForwarder(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
        }
    }

    private void checkDisposed(String method) {
        if (this.isDisposed) {
            logger.e("Attempt to use disposed object in Conversation#" + method);
        }
    }

    private native void nativeSetFriendlyName(String var1, StatusListener var2);

    private native void nativeSetUniqueName(String var1, StatusListener var2);

    private native String nativeGetAttributes();

    private native void nativeSetAttributes(String var1, StatusListener var2);

    private native void nativeJoin(StatusListener var1);

    private native void nativeLeave(StatusListener var1);

    private native void nativeDestroy(StatusListener var1);

    private native void nativeGetMessagesCount(CallbackListener<Long> var1);

    private native void nativeGetUnconsumedMessagesCount(CallbackListener<Long> var1);

    private native void nativeGetMembersCount(CallbackListener<Long> var1);

    private native Messages nativeGetMessages();

    private native Participants nativeGetMembers();

    private native String nativeGetLastMessageDate();

    private native ConversationLimits nativeGetConversationLimits();

    private native void nativeDispose();

    private native void nativeSetNotificationLevel(Conversation.NotificationLevel var1, StatusListener var2);

    private static class ConversationListenerForwarder
    implements ConversationListener {
        private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(ConversationListenerForwarder.class));
        private Map<String, Map<ConversationListener, Handler>> conversationListenerMap = new HashMap<String, Map<ConversationListener, Handler>>();

        private ConversationListenerForwarder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageAdded(final Message message) {
            Map<ConversationListener, Handler> listeners;
            if (message == null) {
                logger.e("onMessageAdded called with null message - this shouldn't happen");
                return;
            }
            Conversation conversation = message.getConversation();
            logger.d("onMessageAdded conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onMessageAdded conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onMessageAdded conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onMessageAdded handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onMessageAdded calling listener");
                                listener.onMessageAdded(message);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageUpdated(final Message message, final Message.UpdateReason reason) {
            Map<ConversationListener, Handler> listeners;
            if (message == null) {
                logger.e("onMessageUpdated called with null message - this shouldn't happen");
                return;
            }
            Conversation conversation = message.getConversation();
            logger.d("onMessageUpdated conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onMessageUpdated conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onMessageUpdated conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onMessageUpdated handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onMessageUpdated calling listener");
                                listener.onMessageUpdated(message, reason);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageDeleted(final Message message) {
            Map<ConversationListener, Handler> listeners;
            if (message == null) {
                logger.e("onMessageDeleted called with null message - this shouldn't happen");
                return;
            }
            Conversation conversation = message.getConversation();
            logger.d("onMessageDeleted conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onMessageDeleted conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onMessageDeleted conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onMessageDeleted handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onMessageDeleted calling listener");
                                listener.onMessageDeleted(message);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParticipantAdded(final Participant participant) {
            Map<ConversationListener, Handler> listeners;
            if (participant == null) {
                logger.e("onParticipantAdded called with null participant - this shouldn't happen");
                return;
            }
            Conversation conversation = participant.getConversation();
            logger.d("onParticipantAdded conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onParticipantAdded conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onParticipantAdded conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onParticipantAdded handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onParticipantAdded calling listener");
                                listener.onParticipantAdded(participant);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParticipantUpdated(final Participant participant, final Participant.UpdateReason reason) {
            Map<ConversationListener, Handler> listeners;
            if (participant == null) {
                logger.e("onParticipantUpdated called with null participant - this shouldn't happen");
                return;
            }
            Conversation conversation = participant.getConversation();
            logger.d("onParticipantUpdated conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onParticipantUpdated conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onParticipantUpdated conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onParticipantUpdated handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onParticipantUpdated calling listener");
                                listener.onParticipantUpdated(participant, reason);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParticipantDeleted(final Participant participant) {
            Map<ConversationListener, Handler> listeners;
            if (participant == null) {
                logger.e("onParticipantDeleted called with null participant - this shouldn't happen");
                return;
            }
            Conversation conversation = participant.getConversation();
            logger.d("onParticipantDeleted conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onParticipantDeleted conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onParticipantDeleted conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onParticipantDeleted handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onParticipantDeleted calling listener");
                                listener.onParticipantDeleted(participant);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTypingStarted(final Conversation conversation, final Participant participant) {
            Map<ConversationListener, Handler> listeners;
            if (participant == null) {
                logger.e("onTypingStarted called with null participant - this shouldn't happen");
                return;
            }
            logger.d("onTypingStarted conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onTypingStarted conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onTypingStarted conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onTypingStarted handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onTypingStarted calling listener");
                                listener.onTypingStarted(conversation, participant);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTypingEnded(final Conversation conversation, final Participant participant) {
            Map<ConversationListener, Handler> listeners;
            if (participant == null) {
                logger.e("onTypingEnded called with null participant - this shouldn't happen");
                return;
            }
            logger.d("onTypingEnded conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onTypingEnded conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onTypingEnded conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onTypingEnded handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onTypingEnded calling listener");
                                listener.onTypingEnded(conversation, participant);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSynchronizationChanged(final Conversation conversation) {
            Map<ConversationListener, Handler> listeners;
            logger.d("onSynchronizationChanged conversation " + conversation.getSid() + "|" + conversation.hashCode());
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                listeners = this.conversationListenerMap.get(conversation.getSid());
            }
            if (listeners == null) {
                return;
            }
            map = listeners;
            synchronized (map) {
                logger.d("onSynchronizationChanged conversation listeners " + listeners.toString());
                for (Map.Entry<ConversationListener, Handler> entry : listeners.entrySet()) {
                    final ConversationListener listener = entry.getKey();
                    logger.d("onSynchronizationChanged conversation listener " + listener.hashCode());
                    Handler handler = entry.getValue();
                    if (handler == null) continue;
                    logger.d("onSynchronizationChanged handler not null.");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                logger.d("onSynchronizationChanged calling listener");
                                listener.onSynchronizationChanged(conversation);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(String sid, ConversationListener listener, Handler handler) {
            Map<ConversationListener, Handler> existingMap;
            ConversationListener rethrowingListener = RethrowingForwarder.create(listener, ListenerException.class);
            Map<Object, Map<ConversationListener, Object>> map = this.conversationListenerMap;
            synchronized (map) {
                existingMap = this.conversationListenerMap.get(sid);
            }
            if (existingMap != null) {
                map = existingMap;
                synchronized (map) {
                    existingMap.put(rethrowingListener, handler);
                }
            }
            existingMap = new HashMap<ConversationListener, Handler>();
            existingMap.put(rethrowingListener, handler);
            map = this.conversationListenerMap;
            synchronized (map) {
                this.conversationListenerMap.put(sid, existingMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeListener(String sid, ConversationListener listener) {
            Map<ConversationListener, Handler> existingMap;
            Map<String, Map<ConversationListener, Handler>> map = this.conversationListenerMap;
            synchronized (map) {
                existingMap = this.conversationListenerMap.get(sid);
            }
            if (existingMap != null) {
                ConversationListener rethrowingListener = RethrowingForwarder.create(listener, ListenerException.class);
                Map<ConversationListener, Handler> map2 = existingMap;
                synchronized (map2) {
                    existingMap.remove(rethrowingListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAllListeners(String sid) {
            Map<String, Map<ConversationListener, Handler>> map = this.conversationListenerMap;
            synchronized (map) {
                this.conversationListenerMap.remove(sid);
            }
        }
    }
}

