/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.ConversationLimits;
import com.twilio.conversations.ConversationListener;
import com.twilio.conversations.MediaUploadListener;
import com.twilio.conversations.Message;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.content.ContentTemplateVariable;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface Conversation {
    public String getSid();

    public String getFriendlyName();

    public String getUniqueName();

    public ConversationLimits getLimits();

    @NonNull
    public Attributes getAttributes();

    public NotificationLevel getNotificationLevel();

    public SynchronizationStatus getSynchronizationStatus();

    public ConversationStatus getStatus();

    public ConversationState getState();

    @Nullable
    public Date getStateDateUpdatedAsDate();

    public String getCreatedBy();

    public String getDateCreated();

    public Date getDateCreatedAsDate();

    public String getDateUpdated();

    public Date getDateUpdatedAsDate();

    public void setFriendlyName(String var1, StatusListener var2);

    public void setUniqueName(String var1, StatusListener var2);

    public void setAttributes(@NotNull Attributes var1, StatusListener var2);

    public void setNotificationLevel(NotificationLevel var1, StatusListener var2);

    public void addListener(ConversationListener var1);

    public void removeListener(ConversationListener var1);

    public void removeAllListeners();

    public void join(StatusListener var1);

    public void leave(StatusListener var1);

    public void destroy(StatusListener var1);

    public void typing();

    public void getMessagesCount(CallbackListener<Long> var1);

    public void getUnreadMessagesCount(CallbackListener<Long> var1);

    public void getParticipantsCount(CallbackListener<Long> var1);

    public MessageBuilder prepareMessage();

    public void removeMessage(Message var1, StatusListener var2);

    public Date getLastMessageDate();

    public Long getLastMessageIndex();

    public Long getLastReadMessageIndex();

    public void setLastReadMessageIndex(long var1, CallbackListener<Long> var3);

    public void advanceLastReadMessageIndex(long var1, CallbackListener<Long> var3);

    public void setAllMessagesRead(CallbackListener<Long> var1);

    public void setAllMessagesUnread(CallbackListener<Long> var1);

    public void getMessagesBefore(long var1, int var3, @NonNull CallbackListener<List<Message>> var4);

    public void getMessagesAfter(long var1, int var3, @NonNull CallbackListener<List<Message>> var4);

    public void getLastMessages(int var1, @NonNull CallbackListener<List<Message>> var2);

    public void getMessageByIndex(long var1, @NonNull CallbackListener<Message> var3);

    public void addParticipantByIdentity(String var1, Attributes var2, StatusListener var3);

    public void addParticipantByAddress(String var1, String var2, Attributes var3, StatusListener var4);

    public void removeParticipant(Participant var1, StatusListener var2);

    public void removeParticipantByIdentity(String var1, StatusListener var2);

    public List<Participant> getParticipantsList();

    public Participant getParticipantByIdentity(String var1);

    public Participant getParticipantBySid(String var1);

    public static interface UnsentMessage {
        public CancellationToken send(@Nullable CallbackListener<Message> var1);
    }

    public static interface MessageBuilder {
        public MessageBuilder setBody(String var1);

        public MessageBuilder setSubject(String var1);

        public MessageBuilder setAttributes(@NotNull Attributes var1);

        public MessageBuilder setEmailBody(@NotNull String var1, @NotNull String var2);

        public MessageBuilder setEmailBody(@NotNull InputStream var1, @NotNull String var2, @Nullable MediaUploadListener var3);

        public MessageBuilder setEmailHistory(@NotNull String var1, @NotNull String var2);

        public MessageBuilder setEmailHistory(@NotNull InputStream var1, @NotNull String var2, @Nullable MediaUploadListener var3);

        public MessageBuilder addMedia(@NotNull InputStream var1, @NotNull String var2, @Nullable String var3, @Nullable MediaUploadListener var4);

        public MessageBuilder setContentTemplate(String var1);

        public MessageBuilder setContentTemplate(String var1, List<ContentTemplateVariable> var2);

        public UnsentMessage build();

        public CancellationToken buildAndSend(@Nullable CallbackListener<Message> var1);
    }

    public static enum UpdateReason {
        STATUS(1),
        LAST_READ_MESSAGE_INDEX(2),
        UNIQUE_NAME(3),
        FRIENDLY_NAME(4),
        ATTRIBUTES(5),
        LAST_MESSAGE(6),
        NOTIFICATION_LEVEL(7),
        STATE(8);

        private final int value;

        private UpdateReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateReason fromInt(int value) {
            for (UpdateReason t : UpdateReason.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for UpdateReason");
        }
    }

    public static enum SynchronizationStatus {
        NONE(0),
        IDENTIFIER(1),
        METADATA(2),
        ALL(3),
        FAILED(4);

        private final int value;

        private SynchronizationStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SynchronizationStatus fromInt(int value) {
            for (SynchronizationStatus t : SynchronizationStatus.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for SynchronizationStatus");
        }

        public boolean isAtLeast(SynchronizationStatus s) {
            if (s == FAILED || this == FAILED) {
                return false;
            }
            return this.getValue() >= s.getValue();
        }
    }

    public static enum ConversationState {
        UNDEFINED(0),
        ACTIVE(1),
        INACTIVE(2),
        CLOSED(3);

        private final int value;

        private ConversationState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConversationState fromInt(int value) {
            for (ConversationState t : ConversationState.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for ConversationState");
        }
    }

    public static enum ConversationStatus {
        JOINED(1),
        NOT_PARTICIPATING(2);

        private final int value;

        private ConversationStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConversationStatus fromInt(int value) {
            for (ConversationStatus t : ConversationStatus.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for ConversationStatus");
        }
    }

    public static enum NotificationLevel {
        DEFAULT(0),
        MUTED(1);

        private final int value;

        private NotificationLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NotificationLevel fromInt(int value) {
            for (NotificationLevel t : NotificationLevel.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for NotificationLevel");
        }
    }
}

