/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.util.TwilioLogger;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Attributes {
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(Attributes.class));
    public static final Attributes DEFAULT = new Attributes(new JSONObject());
    @NonNull
    private final Type mType;
    @NonNull
    private final String mJson;

    public Attributes() {
        this.mType = Type.NULL;
        this.mJson = JSONObject.NULL.toString();
    }

    public Attributes(@NonNull JSONObject object) {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        this.mType = Type.OBJECT;
        this.mJson = object.toString();
    }

    public Attributes(@NonNull JSONArray array) {
        if (array == null) {
            throw new IllegalArgumentException("array must not be null");
        }
        this.mType = Type.ARRAY;
        this.mJson = array.toString();
    }

    public Attributes(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        this.mType = Type.STRING;
        this.mJson = JSONObject.quote((String)string);
    }

    public Attributes(@NonNull Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number must not be null");
        }
        this.mType = Type.NUMBER;
        try {
            this.mJson = JSONObject.numberToString((Number)number);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot serialize number: " + number, e);
        }
    }

    public Attributes(boolean value) {
        this.mType = Type.BOOLEAN;
        this.mJson = String.valueOf(value);
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Nullable
    public JSONObject getJSONObject() {
        if (this.mType != Type.OBJECT) {
            return null;
        }
        try {
            return new JSONObject(this.mJson);
        }
        catch (Exception e) {
            logger.e("Error creating JSONObject: " + this.mJson, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public JSONArray getJSONArray() {
        if (this.mType != Type.ARRAY) {
            return null;
        }
        try {
            return new JSONArray(this.mJson);
        }
        catch (Exception e) {
            logger.e("Error creating JSONArray: " + this.mJson, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String getString() {
        if (this.mType != Type.STRING) {
            return null;
        }
        try {
            return (String)new JSONTokener(this.mJson).nextValue();
        }
        catch (Exception e) {
            logger.e("Error creating String: " + this.mJson, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public Number getNumber() {
        if (this.mType != Type.NUMBER) {
            return null;
        }
        try {
            return (Number)new JSONTokener(this.mJson).nextValue();
        }
        catch (Exception e) {
            logger.e("Error creating Number: " + this.mJson, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public Boolean getBoolean() {
        if (this.mType != Type.BOOLEAN) {
            return null;
        }
        try {
            return (Boolean)new JSONTokener(this.mJson).nextValue();
        }
        catch (Exception e) {
            logger.e("Error creating Boolean: " + this.mJson, (Throwable)e);
            return null;
        }
    }

    @NonNull
    public String toString() {
        return this.mJson;
    }

    public int hashCode() {
        return 31 * this.mType.hashCode() + this.mJson.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes other = (Attributes)obj;
        return this.mType == other.mType && this.mJson.equals(other.mJson);
    }

    @NonNull
    static Attributes parse(String attributes) throws JSONException {
        Object value = new JSONTokener(attributes).nextValue();
        if (value instanceof JSONObject) {
            return new Attributes((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return new Attributes((JSONArray)value);
        }
        if (JSONObject.NULL.equals(value)) {
            return new Attributes();
        }
        if (value instanceof Boolean) {
            return new Attributes((Boolean)value);
        }
        if (value instanceof Number) {
            return new Attributes((Number)value);
        }
        if (value instanceof String) {
            return new Attributes((String)value);
        }
        throw new JSONException("Unknown JSON value type: " + value);
    }

    static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }
}

