/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AggregatedDeliveryReceipt {
    private final int mTotal;
    private final DeliveryAmount mRead;
    private final DeliveryAmount mUndelivered;
    private final DeliveryAmount mDelivered;
    private final DeliveryAmount mFailed;
    private final DeliveryAmount mSent;

    AggregatedDeliveryReceipt(int total, DeliveryAmount read, DeliveryAmount undelivered, DeliveryAmount delivered, DeliveryAmount failed, DeliveryAmount sent) {
        this.mTotal = total;
        this.mRead = read;
        this.mUndelivered = undelivered;
        this.mDelivered = delivered;
        this.mFailed = failed;
        this.mSent = sent;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public DeliveryAmount getSent() {
        return this.mSent;
    }

    public DeliveryAmount getDelivered() {
        return this.mDelivered;
    }

    public DeliveryAmount getUndelivered() {
        return this.mUndelivered;
    }

    public DeliveryAmount getRead() {
        return this.mRead;
    }

    public DeliveryAmount getFailed() {
        return this.mFailed;
    }

    @NonNull
    public String toString() {
        return "AggregatedDeliveryReceipt(\ntotal: " + this.mTotal + "\nread: " + (Object)((Object)this.mRead) + "\nundelivered: " + (Object)((Object)this.mUndelivered) + "\ndelivered: " + (Object)((Object)this.mDelivered) + "\nfailed: " + (Object)((Object)this.mFailed) + "\nsent: " + (Object)((Object)this.mSent) + "\n)";
    }

    public int hashCode() {
        int result = this.mTotal;
        result = 31 * result + this.mRead.hashCode();
        result = 31 * result + this.mUndelivered.hashCode();
        result = 31 * result + this.mDelivered.hashCode();
        result = 31 * result + this.mFailed.hashCode();
        result = 31 * result + this.mSent.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AggregatedDeliveryReceipt)) {
            return false;
        }
        AggregatedDeliveryReceipt other = (AggregatedDeliveryReceipt)obj;
        return this.mTotal == other.mTotal && this.mRead.equals((Object)other.mRead) && this.mUndelivered.equals((Object)other.mUndelivered) && this.mDelivered.equals((Object)other.mDelivered) && this.mFailed.equals((Object)other.mFailed) && this.mSent.equals((Object)other.mSent);
    }

    public static enum DeliveryAmount {
        NONE(0),
        SOME(1),
        ALL(2);

        private final int mValue;

        private DeliveryAmount(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static DeliveryAmount fromInt(int value) {
            for (DeliveryAmount amount : DeliveryAmount.values()) {
                if (amount.getValue() != value) continue;
                return amount;
            }
            throw new IllegalStateException("Invalid value " + value + " for AggregatedDeliveryReceipt.DeliveryAmount");
        }
    }
}

