/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessor;
import com.twilio.audioswitch.android.BluetoothIntentProcessorImpl;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.SystemClockWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothScoJob;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0004NOPQBg\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u000200H\u0002J\u0006\u00102\u001a\u000200J\b\u00103\u001a\u000200H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107J\n\u00108\u001a\u0004\u0018\u000107H\u0003J\u0006\u00109\u001a\u00020\u0016J\b\u0010:\u001a\u00020\u0016H\u0003J\b\u0010;\u001a\u00020\u0016H\u0002J\b\u0010<\u001a\u00020\u0016H\u0003J\u0012\u0010=\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u000107H\u0002J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0002002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0017J\u0010\u0010J\u001a\u0002002\u0006\u0010F\u001a\u00020GH\u0016J\u000e\u0010K\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010L\u001a\u000200J\u000e\u0010M\u001a\u0004\u0018\u00010A*\u00020DH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u00060\u0019R\u00020\u00008\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u00060\u001fR\u00020\u00008\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\"R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(8\u0000@@X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010\u001b\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "headsetListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "bluetoothIntentProcessor", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "headsetProxy", "Landroid/bluetooth/BluetoothHeadset;", "hasRegisteredReceivers", "", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;Landroid/bluetooth/BluetoothAdapter;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;Landroid/bluetooth/BluetoothHeadset;Z)V", "disableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "getDisableBluetoothScoJob$audioswitch_release$annotations", "()V", "getDisableBluetoothScoJob$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "enableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "getEnableBluetoothScoJob$audioswitch_release$annotations", "getEnableBluetoothScoJob$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "getHeadsetListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "setHeadsetListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;)V", "value", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "headsetState", "getHeadsetState$audioswitch_release$annotations", "getHeadsetState$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "setHeadsetState$audioswitch_release", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;)V", "activate", "", "connect", "deactivate", "disconnect", "getHeadset", "Lcom/twilio/audioswitch/AudioDevice$BluetoothHeadset;", "bluetoothHeadsetName", "", "getHeadsetName", "hasActivationError", "hasActiveHeadset", "hasActiveHeadsetChanged", "hasConnectedDevice", "isCorrectIntentAction", "intentAction", "isHeadsetDevice", "deviceWrapper", "Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "onReceive", "intent", "Landroid/content/Intent;", "onServiceConnected", "profile", "", "bluetoothProfile", "Landroid/bluetooth/BluetoothProfile;", "onServiceDisconnected", "start", "stop", "getHeadsetDevice", "Companion", "DisableBluetoothScoJob", "EnableBluetoothScoJob", "HeadsetState", "audioswitch_release"})
public final class BluetoothHeadsetManager
extends BroadcastReceiver
implements BluetoothProfile.ServiceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadsetConnectionListener headsetListener;
    @NotNull
    private final BluetoothIntentProcessor bluetoothIntentProcessor;
    @Nullable
    private BluetoothHeadset headsetProxy;
    private boolean hasRegisteredReceivers;
    @NotNull
    private HeadsetState headsetState;
    @NotNull
    private final EnableBluetoothScoJob enableBluetoothScoJob;
    @NotNull
    private final DisableBluetoothScoJob disableBluetoothScoJob;

    @VisibleForTesting(otherwise=2)
    public BluetoothHeadsetManager(@NotNull Context context, @NotNull Logger logger, @NotNull BluetoothAdapter bluetoothAdapter, @NotNull AudioDeviceManager audioDeviceManager, @Nullable BluetoothHeadsetConnectionListener headsetListener, @NotNull Handler bluetoothScoHandler, @NotNull SystemClockWrapper systemClockWrapper, @NotNull BluetoothIntentProcessor bluetoothIntentProcessor, @Nullable BluetoothHeadset headsetProxy, boolean hasRegisteredReceivers) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)bluetoothAdapter, (String)"bluetoothAdapter");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
        Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
        Intrinsics.checkNotNullParameter((Object)bluetoothIntentProcessor, (String)"bluetoothIntentProcessor");
        this.context = context;
        this.logger = logger;
        this.bluetoothAdapter = bluetoothAdapter;
        this.headsetListener = headsetListener;
        this.bluetoothIntentProcessor = bluetoothIntentProcessor;
        this.headsetProxy = headsetProxy;
        this.hasRegisteredReceivers = hasRegisteredReceivers;
        this.headsetState = HeadsetState.Disconnected.INSTANCE;
        this.enableBluetoothScoJob = new EnableBluetoothScoJob(this.logger, audioDeviceManager, bluetoothScoHandler, systemClockWrapper);
        this.disableBluetoothScoJob = new DisableBluetoothScoJob(this.logger, audioDeviceManager, bluetoothScoHandler, systemClockWrapper);
    }

    public /* synthetic */ BluetoothHeadsetManager(Context context, Logger logger, BluetoothAdapter bluetoothAdapter, AudioDeviceManager audioDeviceManager, BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, Handler handler, SystemClockWrapper systemClockWrapper, BluetoothIntentProcessor bluetoothIntentProcessor, BluetoothHeadset bluetoothHeadset, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bluetoothHeadsetConnectionListener = null;
        }
        if ((n & 0x20) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((n & 0x40) != 0) {
            systemClockWrapper = new SystemClockWrapper();
        }
        if ((n & 0x80) != 0) {
            bluetoothIntentProcessor = new BluetoothIntentProcessorImpl();
        }
        if ((n & 0x100) != 0) {
            bluetoothHeadset = null;
        }
        if ((n & 0x200) != 0) {
            bl = false;
        }
        this(context, logger, bluetoothAdapter, audioDeviceManager, bluetoothHeadsetConnectionListener, handler, systemClockWrapper, bluetoothIntentProcessor, bluetoothHeadset, bl);
    }

    @Nullable
    public final BluetoothHeadsetConnectionListener getHeadsetListener() {
        return this.headsetListener;
    }

    public final void setHeadsetListener(@Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener) {
        this.headsetListener = bluetoothHeadsetConnectionListener;
    }

    @NotNull
    public final HeadsetState getHeadsetState$audioswitch_release() {
        return this.headsetState;
    }

    public final void setHeadsetState$audioswitch_release(@NotNull HeadsetState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.headsetState, (Object)value)) {
            this.headsetState = value;
            this.logger.d("BluetoothHeadsetManager", "Headset state changed to " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName());
            if (Intrinsics.areEqual((Object)value, (Object)HeadsetState.Disconnected.INSTANCE)) {
                this.enableBluetoothScoJob.cancelBluetoothScoJob();
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getHeadsetState$audioswitch_release$annotations() {
    }

    @NotNull
    public final EnableBluetoothScoJob getEnableBluetoothScoJob$audioswitch_release() {
        return this.enableBluetoothScoJob;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getEnableBluetoothScoJob$audioswitch_release$annotations() {
    }

    @NotNull
    public final DisableBluetoothScoJob getDisableBluetoothScoJob$audioswitch_release() {
        return this.disableBluetoothScoJob;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getDisableBluetoothScoJob$audioswitch_release$annotations() {
    }

    @SuppressLint(value={"MissingPermission"})
    public void onServiceConnected(int profile, @NotNull BluetoothProfile bluetoothProfile) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)bluetoothProfile, (String)"bluetoothProfile");
            this.headsetProxy = (BluetoothHeadset)bluetoothProfile;
            List list = ((BluetoothHeadset)bluetoothProfile).getConnectedDevices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bluetoothProfile.connectedDevices");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothDevice device = (BluetoothDevice)element$iv;
                boolean bl = false;
                this.logger.d("BluetoothHeadsetManager", "Bluetooth " + device.getName() + " connected");
            }
            if (!this.hasConnectedDevice()) break block2;
            this.connect();
            BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
            if (bluetoothHeadsetConnectionListener != null) {
                BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, this.getHeadsetName(), 0, 2, null);
            }
        }
    }

    public void onServiceDisconnected(int profile) {
        block0: {
            this.logger.d("BluetoothHeadsetManager", "Bluetooth disconnected");
            this.setHeadsetState$audioswitch_release(HeadsetState.Disconnected.INSTANCE);
            BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
            if (bluetoothHeadsetConnectionListener == null) break block0;
            BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, null, 0, 3, null);
        }
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block18: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (!this.isCorrectIntentAction(intent.getAction())) break block18;
            BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
            if (bluetoothDeviceWrapper != null) {
                BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper;
                boolean bl = false;
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                boolean bl2 = false;
                switch (state) {
                    case 2: {
                        this.logger.d("BluetoothHeadsetManager", "Bluetooth headset " + bluetoothDevice + " connected");
                        this.connect();
                        BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                        if (bluetoothHeadsetConnectionListener != null) {
                            bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(bluetoothDevice.getName(), 2);
                        }
                        break;
                    }
                    case 0: {
                        this.logger.d("BluetoothHeadsetManager", "Bluetooth headset " + bluetoothDevice + " disconnected");
                        this.disconnect();
                        BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                        if (bluetoothHeadsetConnectionListener != null) {
                            bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(bluetoothDevice.getName(), 0);
                        }
                        break;
                    }
                    case 12: {
                        this.logger.d("BluetoothHeadsetManager", "Bluetooth audio connected on device " + bluetoothDevice);
                        this.enableBluetoothScoJob.cancelBluetoothScoJob();
                        this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivated.INSTANCE);
                        BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                        if (bluetoothHeadsetConnectionListener != null) {
                            bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(bluetoothDevice.getName(), 12);
                        }
                        break;
                    }
                    case 10: {
                        this.logger.d("BluetoothHeadsetManager", "Bluetooth audio disconnected on device " + bluetoothDevice);
                        this.disableBluetoothScoJob.cancelBluetoothScoJob();
                        if (this.hasActiveHeadsetChanged()) {
                            this.enableBluetoothScoJob.executeBluetoothScoJob();
                        }
                        BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                        if (bluetoothHeadsetConnectionListener == null) break;
                        bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(bluetoothDevice.getName(), 10);
                        break;
                    }
                }
            }
            int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
            boolean bl = false;
            switch (state) {
                case 2: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth SCO connecting");
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        bluetoothHeadsetConnectionListener.onBluetoothScoStateChanged(2);
                    }
                    break;
                }
                case 1: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth SCO connected");
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        bluetoothHeadsetConnectionListener.onBluetoothScoStateChanged(1);
                    }
                    break;
                }
                case 0: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth SCO disconnected");
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener == null) break;
                    bluetoothHeadsetConnectionListener.onBluetoothScoStateChanged(0);
                    break;
                }
            }
        }
    }

    public final void start(@NotNull BluetoothHeadsetConnectionListener headsetListener) {
        Intrinsics.checkNotNullParameter((Object)headsetListener, (String)"headsetListener");
        this.headsetListener = headsetListener;
        this.bluetoothAdapter.getProfileProxy(this.context, (BluetoothProfile.ServiceListener)this, 1);
        if (!this.hasRegisteredReceivers) {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED"));
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED"));
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
            this.hasRegisteredReceivers = true;
        }
    }

    public final void stop() {
        this.headsetListener = null;
        this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.headsetProxy);
        if (this.hasRegisteredReceivers) {
            this.context.unregisterReceiver((BroadcastReceiver)this);
            this.hasRegisteredReceivers = false;
        }
    }

    public final void activate() {
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.Connected.INSTANCE) || Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivationError.INSTANCE)) {
            this.enableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.logger.w("BluetoothHeadsetManager", "Cannot activate when in the " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName() + " state");
        }
    }

    public final void deactivate() {
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivated.INSTANCE)) {
            this.disableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.logger.w("BluetoothHeadsetManager", "Cannot deactivate when in the " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName() + " state");
        }
    }

    public final boolean hasActivationError() {
        return Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivationError.INSTANCE);
    }

    @Nullable
    public final AudioDevice.BluetoothHeadset getHeadset(@Nullable String bluetoothHeadsetName) {
        AudioDevice.BluetoothHeadset bluetoothHeadset;
        if (!Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.Disconnected.INSTANCE)) {
            String headsetName;
            String string = bluetoothHeadsetName;
            if (string == null) {
                string = this.getHeadsetName();
            }
            String string2 = headsetName = string;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                bluetoothHeadset = new AudioDevice.BluetoothHeadset(it);
            } else {
                bluetoothHeadset = new AudioDevice.BluetoothHeadset(null, 1, null);
            }
        } else {
            bluetoothHeadset = null;
        }
        return bluetoothHeadset;
    }

    private final boolean isCorrectIntentAction(String intentAction) {
        return Intrinsics.areEqual((Object)intentAction, (Object)"android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED") || Intrinsics.areEqual((Object)intentAction, (Object)"android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED") || Intrinsics.areEqual((Object)intentAction, (Object)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
    }

    private final void connect() {
        if (!this.hasActiveHeadset()) {
            this.setHeadsetState$audioswitch_release(HeadsetState.Connected.INSTANCE);
        }
    }

    private final void disconnect() {
        this.setHeadsetState$audioswitch_release(this.hasActiveHeadset() ? (HeadsetState)HeadsetState.AudioActivated.INSTANCE : (this.hasConnectedDevice() ? (HeadsetState)HeadsetState.Connected.INSTANCE : (HeadsetState)HeadsetState.Disconnected.INSTANCE));
    }

    private final boolean hasActiveHeadsetChanged() {
        return Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivated.INSTANCE) && this.hasConnectedDevice() && !this.hasActiveHeadset();
    }

    @SuppressLint(value={"MissingPermission"})
    private final String getHeadsetName() {
        String string;
        BluetoothHeadset bluetoothHeadset = this.headsetProxy;
        if (bluetoothHeadset != null) {
            List list;
            BluetoothHeadset proxy = bluetoothHeadset;
            boolean bl = false;
            List list2 = list = proxy.getConnectedDevices();
            if (list2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"connectedDevices");
                List devices = list;
                boolean bl2 = false;
                if (devices.size() > 1 && this.hasActiveHeadset()) {
                    Object v2;
                    block9: {
                        Iterable iterable = devices;
                        for (Object t : iterable) {
                            BluetoothDevice it = (BluetoothDevice)t;
                            boolean bl3 = false;
                            if (!proxy.isAudioConnected(it)) continue;
                            v2 = t;
                            break block9;
                        }
                        v2 = null;
                    }
                    BluetoothDevice bluetoothDevice = v2;
                    String device = bluetoothDevice != null ? bluetoothDevice.getName() : null;
                    this.logger.d("BluetoothHeadsetManager", "Device size > 1 with device name: " + device);
                    string = device;
                } else if (devices.size() == 1) {
                    String device = ((BluetoothDevice)CollectionsKt.first((List)devices)).getName();
                    this.logger.d("BluetoothHeadsetManager", "Device size 1 with device name: " + device);
                    string = device;
                } else {
                    this.logger.d("BluetoothHeadsetManager", "Device size 0");
                    string = null;
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"MissingPermission"})
    private final boolean hasActiveHeadset() {
        boolean bl;
        BluetoothHeadset bluetoothHeadset;
        block3: {
            List list;
            BluetoothHeadset bluetoothHeadset2 = this.headsetProxy;
            bluetoothHeadset = bluetoothHeadset2;
            if (bluetoothHeadset2 == null) return false;
            BluetoothHeadset proxy = bluetoothHeadset;
            boolean bl2 = false;
            List list2 = list = proxy.getConnectedDevices();
            if (list2 == null) return false;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"connectedDevices");
            List devices = list;
            boolean bl3 = false;
            Iterable $this$any$iv = devices;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BluetoothDevice it = (BluetoothDevice)element$iv;
                    boolean bl4 = false;
                    if (!proxy.isAudioConnected(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        Boolean bl5 = bl;
        bluetoothHeadset = bl5;
        if (bl5 == null) return false;
        boolean bl6 = bluetoothHeadset.booleanValue();
        return bl6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"MissingPermission"})
    private final boolean hasConnectedDevice() {
        List list;
        BluetoothHeadset bluetoothHeadset = this.headsetProxy;
        BluetoothHeadset bluetoothHeadset2 = bluetoothHeadset;
        if (bluetoothHeadset == null) return false;
        BluetoothHeadset proxy = bluetoothHeadset2;
        boolean bl = false;
        List list2 = list = proxy.getConnectedDevices();
        if (list2 == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"connectedDevices");
        List devices = list;
        boolean bl2 = false;
        Boolean bl3 = !((Collection)devices).isEmpty();
        bluetoothHeadset2 = bl3;
        if (bl3 == null) return false;
        boolean bl4 = bluetoothHeadset2.booleanValue();
        return bl4;
    }

    private final BluetoothDeviceWrapper getHeadsetDevice(Intent $this$getHeadsetDevice) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper;
        BluetoothDeviceWrapper bluetoothDeviceWrapper2 = this.bluetoothIntentProcessor.getBluetoothDevice($this$getHeadsetDevice);
        if (bluetoothDeviceWrapper2 != null) {
            BluetoothDeviceWrapper device = bluetoothDeviceWrapper2;
            boolean bl = false;
            bluetoothDeviceWrapper = this.isHeadsetDevice(device) ? device : null;
        } else {
            bluetoothDeviceWrapper = null;
        }
        return bluetoothDeviceWrapper;
    }

    private final boolean isHeadsetDevice(BluetoothDeviceWrapper deviceWrapper) {
        boolean bl;
        Integer n = deviceWrapper.getDeviceClass();
        if (n != null) {
            int deviceClass = ((Number)n).intValue();
            boolean bl2 = false;
            bl = deviceClass == 1032 || deviceClass == 1028 || deviceClass == 1056 || deviceClass == 1048 || deviceClass == 7936;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$Companion;", "", "()V", "newInstance", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "newInstance$audioswitch_release", "audioswitch_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BluetoothHeadsetManager newInstance$audioswitch_release(@NotNull Context context, @NotNull Logger logger, @Nullable BluetoothAdapter bluetoothAdapter, @NotNull AudioDeviceManager audioDeviceManager) {
            BluetoothHeadsetManager bluetoothHeadsetManager;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            if (bluetoothAdapter2 != null) {
                BluetoothAdapter adapter = bluetoothAdapter2;
                boolean bl = false;
                bluetoothHeadsetManager = new BluetoothHeadsetManager(context, logger, adapter, audioDeviceManager, null, null, null, null, null, false, 1008, null);
            } else {
                Companion $this$newInstance_u24lambda_u2d1 = this;
                boolean bl = false;
                logger.d("BluetoothHeadsetManager", "Bluetooth is not supported on this device");
                bluetoothHeadsetManager = null;
            }
            return bluetoothHeadsetManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "", "()V", "AudioActivated", "AudioActivating", "AudioActivationError", "Connected", "Disconnected", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Disconnected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Connected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivating;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivationError;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivated;", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public static abstract class HeadsetState {
        private HeadsetState() {
        }

        public /* synthetic */ HeadsetState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Disconnected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class Disconnected
        extends HeadsetState {
            @NotNull
            public static final Disconnected INSTANCE = new Disconnected();

            private Disconnected() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Connected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class Connected
        extends HeadsetState {
            @NotNull
            public static final Connected INSTANCE = new Connected();

            private Connected() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivating;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivating
        extends HeadsetState {
            @NotNull
            public static final AudioActivating INSTANCE = new AudioActivating();

            private AudioActivating() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivationError;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivationError
        extends HeadsetState {
            @NotNull
            public static final AudioActivationError INSTANCE = new AudioActivationError();

            private AudioActivationError() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivated;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivated
        extends HeadsetState {
            @NotNull
            public static final AudioActivated INSTANCE = new AudioActivated();

            private AudioActivated() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;Lcom/twilio/audioswitch/android/Logger;Lcom/twilio/audioswitch/AudioDeviceManager;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "scoAction", "", "scoTimeOutAction", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public final class EnableBluetoothScoJob
    extends BluetoothScoJob {
        @NotNull
        private final Logger logger;
        @NotNull
        private final AudioDeviceManager audioDeviceManager;

        public EnableBluetoothScoJob(@NotNull Logger logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull Handler bluetoothScoHandler, SystemClockWrapper systemClockWrapper) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
            Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
            super(logger, bluetoothScoHandler, systemClockWrapper);
            this.logger = logger;
            this.audioDeviceManager = audioDeviceManager;
        }

        @Override
        protected void scoAction() {
            this.logger.d("BluetoothHeadsetManager", "Attempting to enable bluetooth SCO");
            this.audioDeviceManager.enableBluetoothSco(true);
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivating.INSTANCE);
        }

        @Override
        public void scoTimeOutAction() {
            block0: {
                BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivationError.INSTANCE);
                BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = BluetoothHeadsetManager.this.getHeadsetListener();
                if (bluetoothHeadsetConnectionListener == null) break block0;
                bluetoothHeadsetConnectionListener.onBluetoothHeadsetActivationError();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;Lcom/twilio/audioswitch/android/Logger;Lcom/twilio/audioswitch/AudioDeviceManager;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "scoAction", "", "scoTimeOutAction", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public final class DisableBluetoothScoJob
    extends BluetoothScoJob {
        @NotNull
        private final Logger logger;
        @NotNull
        private final AudioDeviceManager audioDeviceManager;

        public DisableBluetoothScoJob(@NotNull Logger logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull Handler bluetoothScoHandler, SystemClockWrapper systemClockWrapper) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
            Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
            super(logger, bluetoothScoHandler, systemClockWrapper);
            this.logger = logger;
            this.audioDeviceManager = audioDeviceManager;
        }

        @Override
        protected void scoAction() {
            this.logger.d("BluetoothHeadsetManager", "Attempting to disable bluetooth SCO");
            this.audioDeviceManager.enableBluetoothSco(false);
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.Connected.INSTANCE);
        }

        @Override
        public void scoTimeOutAction() {
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivationError.INSTANCE);
        }
    }
}

