/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessor;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0012*\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetReceiver;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "bluetoothIntentProcessor", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "deviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "getDeviceListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "setDeviceListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "isHeadsetDevice", "", "deviceWrapper", "Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "onReceive", "", "intent", "Landroid/content/Intent;", "stop", "getHeadsetDevice", "audioswitch_release"})
public final class BluetoothHeadsetReceiver
extends BroadcastReceiver {
    private final Context context;
    private final LogWrapper logger;
    private final BluetoothIntentProcessor bluetoothIntentProcessor;
    @Nullable
    private BluetoothDeviceConnectionListener deviceListener;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            String string = intent.getAction();
            if (string == null) return;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String action = string2;
            boolean bl3 = false;
            String string3 = action;
            switch (string3.hashCode()) {
                case -1692127708: {
                    if (!string3.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) return;
                    break block12;
                }
                case 1821585647: {
                    if (!string3.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) return;
                    break;
                }
                case -301431627: {
                    if (!string3.equals("android.bluetooth.device.action.ACL_CONNECTED")) return;
                    BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
                    if (bluetoothDeviceWrapper == null) return;
                    BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper2;
                    boolean bl6 = false;
                    this.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + bluetoothDevice.getName() + " connected");
                    BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2 = this.deviceListener;
                    if (bluetoothDeviceConnectionListener2 == null) return;
                    bluetoothDeviceConnectionListener2.onBluetoothConnected(bluetoothDevice);
                    return;
                }
            }
            BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
            if (bluetoothDeviceWrapper == null) return;
            BluetoothDeviceWrapper bluetoothDeviceWrapper3 = bluetoothDeviceWrapper;
            boolean bl7 = false;
            boolean bl8 = false;
            BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper3;
            boolean bl9 = false;
            this.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + bluetoothDevice.getName() + " disconnected");
            BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener3 = this.deviceListener;
            if (bluetoothDeviceConnectionListener3 == null) return;
            bluetoothDeviceConnectionListener3.onBluetoothDisconnected();
            return;
        }
        int n = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
        boolean bl = false;
        boolean bl10 = false;
        int state = n;
        boolean bl11 = false;
        switch (state) {
            case 1: {
                this.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio connected");
                return;
            }
            case 0: {
                this.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio disconnected");
                return;
            }
            case -1: {
                this.logger.e("BluetoothDeviceReceiver", "Error retrieving Bluetooth SCO Audio state");
            }
        }
        return;
    }

    public final void stop() {
        this.deviceListener = null;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    private final BluetoothDeviceWrapper getHeadsetDevice(@NotNull Intent $this$getHeadsetDevice) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper;
        BluetoothDeviceWrapper bluetoothDeviceWrapper2 = this.bluetoothIntentProcessor.getBluetoothDevice($this$getHeadsetDevice);
        if (bluetoothDeviceWrapper2 != null) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper3 = bluetoothDeviceWrapper2;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothDeviceWrapper device = bluetoothDeviceWrapper3;
            boolean bl3 = false;
            bluetoothDeviceWrapper = this.isHeadsetDevice(device) ? device : null;
        } else {
            bluetoothDeviceWrapper = null;
        }
        return bluetoothDeviceWrapper;
    }

    private final boolean isHeadsetDevice(BluetoothDeviceWrapper deviceWrapper) {
        boolean bl;
        Integer n = deviceWrapper.getDeviceClass();
        if (n != null) {
            Integer n2 = n;
            boolean bl2 = false;
            boolean bl3 = false;
            int deviceClass = ((Number)n2).intValue();
            boolean bl4 = false;
            bl = deviceClass == 1032 || deviceClass == 1028 || deviceClass == 1056 || deviceClass == 1048 || deviceClass == 7936;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final BluetoothDeviceConnectionListener getDeviceListener() {
        return this.deviceListener;
    }

    public final void setDeviceListener(@Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }

    public BluetoothHeadsetReceiver(@NotNull Context context, @NotNull LogWrapper logger, @NotNull BluetoothIntentProcessor bluetoothIntentProcessor, @Nullable BluetoothDeviceConnectionListener deviceListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothIntentProcessor, (String)"bluetoothIntentProcessor");
        this.context = context;
        this.logger = logger;
        this.bluetoothIntentProcessor = bluetoothIntentProcessor;
        this.deviceListener = deviceListener;
    }

    public /* synthetic */ BluetoothHeadsetReceiver(Context context, LogWrapper logWrapper, BluetoothIntentProcessor bluetoothIntentProcessor, BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bluetoothDeviceConnectionListener2 = null;
        }
        this(context, logWrapper, bluetoothIntentProcessor, bluetoothDeviceConnectionListener2);
    }
}

