/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetReceiver;
import com.twilio.audioswitch.bluetooth.PreConnectedDeviceListener;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "", "context", "Landroid/content/Context;", "audioDeviceManager", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "preConnectedDeviceListener", "Lcom/twilio/audioswitch/bluetooth/PreConnectedDeviceListener;", "bluetoothHeadsetReceiver", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetReceiver;", "(Landroid/content/Context;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Landroid/bluetooth/BluetoothAdapter;Lcom/twilio/audioswitch/bluetooth/PreConnectedDeviceListener;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetReceiver;)V", "activate", "", "deactivate", "start", "deviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "stop", "audioswitch_release"})
public final class BluetoothController {
    private final Context context;
    private final AudioDeviceManager audioDeviceManager;
    private final BluetoothAdapter bluetoothAdapter;
    private final PreConnectedDeviceListener preConnectedDeviceListener;
    private final BluetoothHeadsetReceiver bluetoothHeadsetReceiver;

    public final void start(@NotNull BluetoothDeviceConnectionListener deviceListener) {
        Intrinsics.checkParameterIsNotNull((Object)deviceListener, (String)"deviceListener");
        this.preConnectedDeviceListener.setDeviceListener(deviceListener);
        this.bluetoothHeadsetReceiver.setDeviceListener(deviceListener);
        this.bluetoothAdapter.getProfileProxy(this.context, (BluetoothProfile.ServiceListener)this.preConnectedDeviceListener, 1);
        Context context = this.context;
        boolean bl = false;
        boolean bl2 = false;
        Context $this$run = context;
        boolean bl3 = false;
        $this$run.registerReceiver((BroadcastReceiver)this.bluetoothHeadsetReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        $this$run.registerReceiver((BroadcastReceiver)this.bluetoothHeadsetReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        $this$run.registerReceiver((BroadcastReceiver)this.bluetoothHeadsetReceiver, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
    }

    public final void stop() {
        this.preConnectedDeviceListener.stop();
        this.bluetoothHeadsetReceiver.stop();
    }

    public final void activate() {
        this.audioDeviceManager.enableBluetoothSco(true);
    }

    public final void deactivate() {
        this.audioDeviceManager.enableBluetoothSco(false);
    }

    public BluetoothController(@NotNull Context context, @NotNull AudioDeviceManager audioDeviceManager, @NotNull BluetoothAdapter bluetoothAdapter, @NotNull PreConnectedDeviceListener preConnectedDeviceListener, @NotNull BluetoothHeadsetReceiver bluetoothHeadsetReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothAdapter, (String)"bluetoothAdapter");
        Intrinsics.checkParameterIsNotNull((Object)preConnectedDeviceListener, (String)"preConnectedDeviceListener");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bluetoothHeadsetReceiver), (String)"bluetoothHeadsetReceiver");
        this.context = context;
        this.audioDeviceManager = audioDeviceManager;
        this.bluetoothAdapter = bluetoothAdapter;
        this.preConnectedDeviceListener = preConnectedDeviceListener;
        this.bluetoothHeadsetReceiver = bluetoothHeadsetReceiver;
    }
}

