/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

class IFFUtil {
    private static final long[][] RTABLE = new long[][]{IFFUtil.rtable(0), IFFUtil.rtable(1), IFFUtil.rtable(2), IFFUtil.rtable(3), IFFUtil.rtable(4), IFFUtil.rtable(5), IFFUtil.rtable(6), IFFUtil.rtable(7)};

    IFFUtil() {
    }

    private static long[] rtable(int n) {
        return new long[]{0L << n, 1L << n, 256L << n, 257L << n, 65536L << n, 65537L << n, 65792L << n, 65793L << n, 0x1000000L << n, 0x1000001L << n, 0x1000100L << n, 0x1000101L << n, 0x1010000L << n, 0x1010001L << n, 0x1010100L << n, 0x1010101L << n};
    }

    static void bitRotateCW(byte[] pSrc, int pSrcPos, int pSrcStep, byte[] pDst, int pDstPos, int pDstStep) {
        int idx = pSrcPos;
        long lo = 0L;
        long hi = 0L;
        for (int i = 0; i < 8; ++i) {
            int lonyb = pSrc[idx] & 0xF;
            int hinyb = pSrc[idx] >> 4 & 0xF;
            lo |= RTABLE[i][lonyb];
            hi |= RTABLE[i][hinyb];
            idx += pSrcStep;
        }
        idx = pDstPos;
        pDst[idx] = (byte)(hi >> 24 & 0xFFL);
        if ((idx += pDstStep) < pDst.length) {
            pDst[idx] = (byte)(hi >> 16 & 0xFFL);
            if ((idx += pDstStep) < pDst.length) {
                pDst[idx] = (byte)(hi >> 8 & 0xFFL);
                if ((idx += pDstStep) < pDst.length) {
                    pDst[idx] = (byte)(hi & 0xFFL);
                    idx += pDstStep;
                }
            }
        }
        if (idx < pDst.length) {
            pDst[idx] = (byte)(lo >> 24 & 0xFFL);
            if ((idx += pDstStep) < pDst.length) {
                pDst[idx] = (byte)(lo >> 16 & 0xFFL);
                if ((idx += pDstStep) < pDst.length) {
                    pDst[idx] = (byte)(lo >> 8 & 0xFFL);
                    if ((idx += pDstStep) < pDst.length) {
                        pDst[idx] = (byte)(lo & 0xFFL);
                    }
                }
            }
        }
    }

    static void bitRotateCCW(int[] pSrc, int pSrcPos, int pSrcStep, byte[] pDst, int pDstPos, int pDstStep) {
        int idx = pSrcPos;
        long lo = 0L;
        long hi = 0L;
        for (int i = 7; i >= 0; --i) {
            int lonyb = pSrc[idx] & 0xF;
            int hinyb = pSrc[idx] >> 4 & 0xF;
            lo |= RTABLE[i][lonyb];
            hi |= RTABLE[i][hinyb];
            idx += pSrcStep;
        }
        idx = pDstPos;
        pDst[idx] = (byte)(lo & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 8 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 16 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 24 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 8 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 16 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 24 & 0xFFL);
    }

    static void bitRotateCCW(byte[] pSrc, int pSrcPos, int pSrcStep, byte[] pDst, int pDstPos, int pDstStep) {
        int idx = pSrcPos;
        long lo = 0L;
        long hi = 0L;
        for (int i = 7; i >= 0; --i) {
            int lonyb = pSrc[idx] & 0xF;
            int hinyb = pSrc[idx] >> 4 & 0xF;
            lo |= RTABLE[i][lonyb];
            hi |= RTABLE[i][hinyb];
            idx += pSrcStep;
        }
        idx = pDstPos;
        pDst[idx] = (byte)(lo & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 8 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 16 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(lo >> 24 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 8 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 16 & 0xFFL);
        pDst[idx += pDstStep] = (byte)(hi >> 24 & 0xFFL);
    }

    static int toInt(byte[] pBytes) {
        return (pBytes[0] & 0xFF) << 24 | (pBytes[1] & 0xFF) << 16 | (pBytes[2] & 0xFF) << 8 | pBytes[3] & 0xFF;
    }

    static String toChunkStr(int pChunkId) {
        return new String(new byte[]{(byte)((pChunkId & 0xFF000000) >> 24), (byte)((pChunkId & 0xFF0000) >> 16), (byte)((pChunkId & 0xFF00) >> 8), (byte)(pChunkId & 0xFF)});
    }
}

