/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageWriterSpi;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class IFFImageWriter
extends ImageWriterBase {
    private static final byte[] ANNO_DATA = "Written by TwelveMonkeys IFFImageWriter 1.0 for Java (javax.imageio).".getBytes();

    public IFFImageWriter() {
        this(null);
    }

    protected IFFImageWriter(ImageWriterSpi pProvider) {
        super(pProvider);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException("Method getDefaultImageMetadata not implemented");
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException("Method convertImageMetadata not implemented");
    }

    public void write(IIOMetadata pStreamMetadata, IIOImage pImage, ImageWriteParam pParam) throws IOException {
        this.assertOutput();
        if (pImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write raster");
        }
        this.processImageStarted(0);
        FastByteArrayOutputStream imageData = new FastByteArrayOutputStream(1024);
        this.packImageData((OutputStream)imageData, pImage.getRenderedImage(), pParam);
        this.writeMeta(pImage.getRenderedImage(), imageData.size());
        this.writeBody((ByteArrayOutputStream)imageData);
        this.processImageComplete();
    }

    private void writeBody(ByteArrayOutputStream pImageData) throws IOException {
        this.mImageOutput.writeInt(1112491097);
        this.mImageOutput.writeInt(pImageData.size());
        pImageData.writeTo(IIOUtil.createStreamAdapter((ImageOutputStream)this.mImageOutput));
        if (pImageData.size() % 2 == 0) {
            this.mImageOutput.writeByte(0);
        }
        this.processImageProgress(100.0f);
        this.mImageOutput.flush();
    }

    private void packImageData(OutputStream pOutput, RenderedImage pImage, ImageWriteParam pParam) throws IOException {
        boolean compress = this.shouldCompress(pImage);
        OutputStream output = compress ? new EncoderStream(pOutput, (Encoder)new PackBitsEncoder(), true) : pOutput;
        ColorModel model = pImage.getColorModel();
        Raster raster = pImage.getData();
        int width = pImage.getWidth();
        int height = pImage.getHeight();
        int planeWidth = (width + 7) / 8;
        byte[] planeData = new byte[8 * planeWidth];
        int channels = (model.getPixelSize() + 7) / 8;
        int planesPerChannel = channels == 1 ? model.getPixelSize() : 8;
        int[] pixels = new int[8 * planeWidth];
        for (int y = 0; y < height; ++y) {
            for (int c = 0; c < channels; ++c) {
                pixels = raster.getSamples(0, y, width, 1, c, pixels);
                int pixelPos = 0;
                int planePos = 0;
                for (int i = 0; i < planeWidth; ++i) {
                    IFFUtil.bitRotateCCW(pixels, pixelPos, 1, planeData, planePos, planeWidth);
                    pixelPos += 8;
                    ++planePos;
                }
                for (int p = 0; p < planesPerChannel; ++p) {
                    output.write(planeData, p * planeWidth, planeWidth);
                    if (compress || planeWidth % 2 == 0) continue;
                    output.write(0);
                }
            }
            this.processImageProgress((float)y * 90.0f / (float)height);
        }
        output.flush();
    }

    private void writeMeta(RenderedImage pImage, int pBodyLength) throws IOException {
        BMHDChunk header;
        int compression;
        GenericChunk anno = new GenericChunk(IFFUtil.toInt("ANNO".getBytes()), ANNO_DATA);
        ColorModel cm = pImage.getColorModel();
        IndexColorModel icm = null;
        int n = compression = this.shouldCompress(pImage) ? 1 : 0;
        if (cm instanceof IndexColorModel) {
            icm = (IndexColorModel)cm;
            int trans = icm.getTransparency() == 2 ? 2 : 0;
            int transPixel = icm.getTransparency() == 2 ? icm.getTransparentPixel() : 0;
            header = new BMHDChunk(pImage.getWidth(), pImage.getHeight(), icm.getPixelSize(), trans, compression, transPixel);
        } else {
            header = new BMHDChunk(pImage.getWidth(), pImage.getHeight(), cm.getPixelSize(), 0, compression, 0);
        }
        CMAPChunk cmap = null;
        if (icm != null) {
            cmap = new CMAPChunk(icm);
        }
        int size = 12 + anno.mChunkLength + 28 + 8 + pBodyLength;
        if (cmap != null) {
            size += 8 + cmap.mChunkLength;
        }
        this.mImageOutput.writeInt(1179603533);
        this.mImageOutput.writeInt(size);
        this.mImageOutput.writeInt(1229734477);
        anno.writeChunk(this.mImageOutput);
        header.writeChunk(this.mImageOutput);
        if (cmap != null) {
            cmap.writeChunk(this.mImageOutput);
        }
    }

    private boolean shouldCompress(RenderedImage pImage) {
        return pImage.getWidth() >= 32;
    }

    public static void main(String[] pArgs) throws IOException {
        BufferedImage image = ImageIO.read(new File(pArgs[0]));
        IFFImageWriter writer = new IFFImageWriter(new IFFImageWriterSpi());
        ((ImageWriter)((Object)writer)).setOutput(ImageIO.createImageOutputStream(new File(pArgs[1])));
        ((ImageWriter)((Object)writer)).write(image);
    }
}

