/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.BODYChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.GRABChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFFImageReader
extends ImageReaderBase {
    private BMHDChunk mHeader;
    private CMAPChunk mColorMap;
    private BODYChunk mBody;
    private GRABChunk mGrab;
    private CAMGChunk mViewPort;
    private int mFormType;
    private long mBodyStart;
    private BufferedImage mImage;
    private DataInputStream mByteRunStream;

    public IFFImageReader() {
        super(IFFImageReaderSpi.sharedProvider());
    }

    protected IFFImageReader(ImageReaderSpi pProvider) {
        super(pProvider);
    }

    private void init(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        if (this.mHeader == null) {
            this.readMeta();
        }
    }

    protected void resetMembers() {
        this.mHeader = null;
        this.mColorMap = null;
        this.mBody = null;
        this.mViewPort = null;
        this.mFormType = 0;
        this.mImage = null;
        this.mByteRunStream = null;
    }

    private void readMeta() throws IOException {
        int length;
        if (this.mImageInput.readInt() != 1179603533) {
            throw new IIOException("Unknown file format for IFFImageReader");
        }
        this.mFormType = this.mImageInput.readInt();
        if (this.mFormType != 1229734477 && this.mFormType != 1346522400) {
            throw new IIOException("Only IFF (FORM) type ILBM and PBM supported: " + IFFUtil.toChunkStr(this.mFormType));
        }
        this.mGrab = null;
        this.mViewPort = null;
        block7: for (int remaining = this.mImageInput.readInt() - 4; remaining > 0; remaining -= length % 2 == 0 ? length : length + 1) {
            int chunkId = this.mImageInput.readInt();
            length = this.mImageInput.readInt();
            remaining -= 8;
            switch (chunkId) {
                case 1112361028: {
                    if (this.mHeader != null) {
                        throw new IIOException("Multiple BMHD chunks not allowed");
                    }
                    this.mHeader = new BMHDChunk(length);
                    this.mHeader.readChunk(this.mImageInput);
                    continue block7;
                }
                case 1129136464: {
                    if (this.mColorMap != null) {
                        throw new IIOException("Multiple CMAP chunks not allowed");
                    }
                    this.mColorMap = new CMAPChunk(length, this.mHeader, this.mViewPort);
                    this.mColorMap.readChunk(this.mImageInput);
                    continue block7;
                }
                case 1196572994: {
                    if (this.mGrab != null) {
                        throw new IIOException("Multiple GRAB chunks not allowed");
                    }
                    this.mGrab = new GRABChunk(length);
                    this.mGrab.readChunk(this.mImageInput);
                    continue block7;
                }
                case 1128353095: {
                    if (this.mViewPort != null) {
                        throw new IIOException("Multiple CAMG chunks not allowed");
                    }
                    this.mViewPort = new CAMGChunk(length);
                    this.mViewPort.readChunk(this.mImageInput);
                    continue block7;
                }
                case 1112491097: {
                    if (this.mBody != null) {
                        throw new IIOException("Multiple BODY chunks not allowed");
                    }
                    this.mBody = new BODYChunk(length);
                    this.mBodyStart = this.mImageInput.getStreamPosition();
                    return;
                }
            }
            GenericChunk generic = new GenericChunk(chunkId, length);
            ((IFFChunk)generic).readChunk(this.mImageInput);
        }
    }

    public BufferedImage read(int pIndex, ImageReadParam pParam) throws IOException {
        this.init(pIndex);
        this.processImageStarted(pIndex);
        this.mImage = IFFImageReader.getDestination((ImageReadParam)pParam, this.getImageTypes(pIndex), (int)this.mHeader.mWidth, (int)this.mHeader.mHeight);
        if (this.mBody != null) {
            this.readBody(pParam);
        } else if (this.mColorMap != null) {
            this.mImage = this.mColorMap.createPaletteImage();
        }
        BufferedImage result = this.mImage;
        this.processImageComplete();
        return result;
    }

    public int getWidth(int pIndex) throws IOException {
        this.init(pIndex);
        return this.mHeader.mWidth;
    }

    public int getHeight(int pIndex) throws IOException {
        this.init(pIndex);
        return this.mHeader.mHeight;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int pIndex) throws IOException {
        this.init(pIndex);
        List<ImageTypeSpecifier> types = Arrays.asList(this.getRawImageType(pIndex), ImageTypeSpecifier.createFromBufferedImageType(this.mHeader.mBitplanes == 32 ? 6 : 5));
        return types.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int pIndex) throws IOException {
        ImageTypeSpecifier specifier;
        this.init(pIndex);
        switch (this.mHeader.mBitplanes) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (!this.isHAM()) {
                    IndexColorModel cm = this.mColorMap.getIndexColorModel();
                    if (cm != null) {
                        specifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)cm);
                        break;
                    }
                    specifier = ImageTypeSpecifier.createFromBufferedImageType(10);
                    break;
                }
            }
            case 24: {
                specifier = ImageTypeSpecifier.createFromBufferedImageType(5);
                break;
            }
            case 32: {
                specifier = ImageTypeSpecifier.createFromBufferedImageType(6);
                break;
            }
            default: {
                throw new IIOException("Bit depth not implemented: " + this.mHeader.mBitplanes);
            }
        }
        return specifier;
    }

    private void readBody(ImageReadParam pParam) throws IOException {
        this.mImageInput.seek(this.mBodyStart);
        this.mByteRunStream = null;
        if (this.mColorMap != null) {
            IndexColorModel cm = this.mColorMap.getIndexColorModel();
            this.readIndexed(pParam, this.mImageInput, cm);
        } else {
            this.readTrueColor(pParam, this.mImageInput);
        }
    }

    private void readIndexed(ImageReadParam pParam, ImageInputStream pInput, IndexColorModel pModel) throws IOException {
        WritableRaster raster;
        ColorModel cm;
        int width = this.mHeader.mWidth;
        int height = this.mHeader.mHeight;
        Rectangle aoi = IFFImageReader.getSourceRegion((ImageReadParam)pParam, (int)width, (int)height);
        Point offset = pParam == null ? new Point(0, 0) : pParam.getDestinationOffset();
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        if (pParam != null) {
            sourceXSubsampling = pParam.getSourceXSubsampling();
            sourceYSubsampling = pParam.getSourceYSubsampling();
            sourceBands = pParam.getSourceBands();
            destinationBands = pParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)pParam, (int)(this.isHAM() ? 3 : 1), (int)this.mImage.getSampleModel().getNumBands());
        WritableRaster destination = this.mImage.getRaster();
        if (destinationBands != null || offset.x != 0 || offset.y != 0) {
            destination = destination.createWritableChild(0, 0, destination.getWidth(), destination.getHeight(), offset.x, offset.y, destinationBands);
        }
        int planeWidth = (width + 7) / 8;
        byte[] planeData = new byte[8 * planeWidth];
        if (this.isHAM()) {
            cm = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            raster = Raster.createInterleavedRaster(0, width, 1, width * 3, 3, new int[]{2, 1, 0}, null);
        } else {
            cm = pModel;
            raster = pModel.createCompatibleWritableRaster(width, 1);
        }
        Raster sourceRow = raster.createChild(aoi.x, 0, aoi.width, 1, 0, 0, sourceBands);
        byte[] row = new byte[width * 8];
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        int planes = this.mHeader.mBitplanes;
        Object dataElements = null;
        Object outDataElements = null;
        ColorConvertOp converter = null;
        for (int srcY = 0; srcY < height; ++srcY) {
            for (int p = 0; p < planes; ++p) {
                try {
                    this.readPlaneData(pInput, planeData, p * planeWidth, planeWidth);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (srcY < aoi.y || (srcY - aoi.y) % sourceYSubsampling != 0) continue;
            if (srcY >= aoi.y + aoi.height) {
                return;
            }
            if (this.mFormType == 1229734477) {
                int pixelPos = 0;
                int planePos = 0;
                for (int i = 0; i < planeWidth; ++i) {
                    IFFUtil.bitRotateCW(planeData, planePos, planeWidth, row, pixelPos, 1);
                    pixelPos += 8;
                    ++planePos;
                }
                if (this.isHAM()) {
                    this.hamToRGB(row, pModel, data, 0);
                } else {
                    raster.setDataElements(0, 0, width, 1, row);
                }
            } else {
                System.arraycopy(planeData, 0, row, 0, this.mHeader.mBitplanes * planeWidth);
                raster.setDataElements(0, 0, width, 1, row);
            }
            int dstY = (srcY - aoi.y) / sourceYSubsampling;
            if (cm.isCompatibleRaster(destination)) {
                if (sourceXSubsampling == 1) {
                    destination.setRect(offset.x, dstY, sourceRow);
                } else {
                    for (int srcX = 0; srcX < sourceRow.getWidth(); srcX += sourceXSubsampling) {
                        dataElements = sourceRow.getDataElements(srcX, 0, dataElements);
                        int dstX = srcX / sourceXSubsampling;
                        destination.setDataElements(dstX, dstY, dataElements);
                    }
                }
            } else if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                for (int srcX = 0; srcX < sourceRow.getWidth(); srcX += sourceXSubsampling) {
                    dataElements = sourceRow.getDataElements(srcX, 0, dataElements);
                    int rgb = icm.getRGB(dataElements);
                    outDataElements = this.mImage.getColorModel().getDataElements(rgb, outDataElements);
                    int dstX = srcX / sourceXSubsampling;
                    destination.setDataElements(dstX, dstY, outDataElements);
                }
            } else {
                if (converter == null) {
                    converter = new ColorConvertOp(cm.getColorSpace(), this.mImage.getColorModel().getColorSpace(), null);
                }
                converter.filter(raster.createChild(aoi.x, 0, aoi.width, 1, 0, 0, null), destination.createWritableChild(offset.x, offset.y + srcY - aoi.y, aoi.width, 1, 0, 0, null));
            }
            this.processImageProgress((float)srcY * 100.0f / (float)this.mHeader.mWidth);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readTrueColor(ImageReadParam pParam, ImageInputStream pInput) throws IOException {
        int width = this.mHeader.mWidth;
        int height = this.mHeader.mHeight;
        Rectangle aoi = IFFImageReader.getSourceRegion((ImageReadParam)pParam, (int)width, (int)height);
        Point offset = pParam == null ? new Point(0, 0) : pParam.getDestinationOffset();
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        if (pParam != null) {
            sourceXSubsampling = pParam.getSourceXSubsampling();
            sourceYSubsampling = pParam.getSourceYSubsampling();
            sourceBands = pParam.getSourceBands();
            destinationBands = pParam.getDestinationBands();
        }
        IFFImageReader.checkReadParamBandSettings((ImageReadParam)pParam, (int)(this.mHeader.mBitplanes / 8), (int)this.mImage.getSampleModel().getNumBands());
        int planeWidth = (width + 7) / 8;
        byte[] planeData = new byte[8 * planeWidth];
        WritableRaster destination = this.mImage.getRaster();
        if (destinationBands != null || offset.x != 0 || offset.y != 0) {
            destination = destination.createWritableChild(0, 0, destination.getWidth(), destination.getHeight(), offset.x, offset.y, destinationBands);
        }
        WritableRaster raster = this.mImage.getRaster().createCompatibleWritableRaster(width, 1);
        Raster sourceRow = raster.createChild(aoi.x, 0, aoi.width, 1, 0, 0, sourceBands);
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        int channels = (this.mHeader.mBitplanes + 7) / 8;
        int planesPerChannel = 8;
        Object dataElements = null;
        for (int srcY = 0; srcY < height; ++srcY) {
            for (int c = 0; c < channels; ++c) {
                for (int p = 0; p < 8; ++p) {
                    this.readPlaneData(pInput, planeData, p * planeWidth, planeWidth);
                }
                if (srcY < aoi.y || (srcY - aoi.y) % sourceYSubsampling != 0) continue;
                if (srcY >= aoi.y + aoi.height) {
                    return;
                }
                if (this.mFormType == 1229734477) {
                    int off = channels - c - 1;
                    int pixelPos = 0;
                    int planePos = 0;
                    for (int i = 0; i < planeWidth; ++i) {
                        IFFUtil.bitRotateCW(planeData, planePos, planeWidth, data, off + pixelPos * channels, channels);
                        pixelPos += 8;
                        ++planePos;
                    }
                    continue;
                }
                System.arraycopy(planeData, 0, data, srcY * 8 * planeWidth, planeWidth);
            }
            int dstY = (srcY - aoi.y) / sourceYSubsampling;
            if (sourceXSubsampling == 1) {
                destination.setRect(0, dstY, sourceRow);
            } else {
                for (int srcX = 0; srcX < sourceRow.getWidth(); srcX += sourceXSubsampling) {
                    dataElements = sourceRow.getDataElements(srcX, 0, dataElements);
                    int dstX = srcX / sourceXSubsampling;
                    destination.setDataElements(dstX, dstY, dataElements);
                }
            }
            this.processImageProgress((float)srcY * 100.0f / (float)this.mHeader.mWidth);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
    }

    private void readPlaneData(ImageInputStream pInput, byte[] pData, int pOffset, int pPlaneWidth) throws IOException {
        switch (this.mHeader.mCompressionType) {
            case 0: {
                pInput.readFully(pData, pOffset, pPlaneWidth);
                if (this.mHeader.mBitplanes * pPlaneWidth % 2 == 0) break;
                pInput.readByte();
                break;
            }
            case 1: {
                if (this.mByteRunStream == null) {
                    this.mByteRunStream = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)pInput, (long)this.mBody.mChunkLength), (Decoder)new PackBitsDecoder(true)));
                }
                this.mByteRunStream.readFully(pData, pOffset, pPlaneWidth);
                break;
            }
            default: {
                throw new IIOException("Unknown compression type: " + this.mHeader.mCompressionType);
            }
        }
    }

    private void hamToRGB(byte[] pIndexed, IndexColorModel pModel, byte[] pDest, int pDestOffset) {
        int bits = this.mHeader.mBitplanes;
        int width = this.mHeader.mWidth;
        int lastRed = 0;
        int lastGreen = 0;
        int lastBlue = 0;
        for (int x = 0; x < width; ++x) {
            int pixel = pIndexed[x] & 0xFF;
            int paletteIndex = bits == 6 ? pixel & 0xF : pixel & 0x3F;
            int indexShift = bits == 6 ? 4 : 2;
            int colorMask = bits == 6 ? 15 : 3;
            switch (pixel >> 8 - indexShift & 3) {
                case 0: {
                    lastRed = pModel.getRed(paletteIndex);
                    lastGreen = pModel.getGreen(paletteIndex);
                    lastBlue = pModel.getBlue(paletteIndex);
                    break;
                }
                case 1: {
                    lastBlue = lastBlue & colorMask | paletteIndex << indexShift;
                    break;
                }
                case 2: {
                    lastRed = lastRed & colorMask | paletteIndex << indexShift;
                    break;
                }
                case 3: {
                    lastGreen = lastGreen & colorMask | paletteIndex << indexShift;
                }
            }
            int offset = x * 3 + pDestOffset;
            pDest[2 + offset] = (byte)lastRed;
            pDest[1 + offset] = (byte)lastGreen;
            pDest[offset] = (byte)lastBlue;
        }
    }

    private boolean isHAM() {
        return this.mViewPort != null && this.mViewPort.isHAM();
    }

    public static void main(String[] pArgs) throws IOException {
        IFFImageReader reader = new IFFImageReader(new IFFImageReaderSpi());
        BufferedImageInputStream input = new BufferedImageInputStream(ImageIO.createImageInputStream(new File(pArgs[0])));
        boolean canRead = ((ImageReader)((Object)reader)).getOriginatingProvider().canDecodeInput(input);
        System.out.println("Can read: " + canRead);
        if (canRead) {
            ((ImageReader)((Object)reader)).setInput(input);
            ImageReadParam param = ((ImageReader)((Object)reader)).getDefaultReadParam();
            BufferedImage image = ((ImageReader)((Object)reader)).read(0, param);
            System.out.println("image = " + image);
            IFFImageReader.showIt((BufferedImage)image, (String)"");
        }
    }
}

