/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class GenericChunk
extends IFFChunk {
    byte[] mData;

    protected GenericChunk(int pChunkId, int pChunkLength) {
        super(pChunkId, pChunkLength);
        this.mData = new byte[pChunkLength <= 50 ? pChunkLength : 47];
    }

    protected GenericChunk(int pChunkId, byte[] pChunkData) {
        super(pChunkId, pChunkData.length);
        this.mData = pChunkData;
    }

    void readChunk(DataInput pInput) throws IOException {
        pInput.readFully(this.mData, 0, this.mData.length);
        for (int toSkip = this.mChunkLength - this.mData.length; toSkip > 0; toSkip -= pInput.skipBytes(toSkip)) {
        }
        if (this.mChunkLength % 2 != 0) {
            pInput.readByte();
        }
    }

    void writeChunk(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.mChunkId);
        pOutput.writeInt(this.mChunkLength);
        pOutput.write(this.mData, 0, this.mData.length);
        if (this.mData.length % 2 != 0) {
            pOutput.writeByte(0);
        }
    }

    public String toString() {
        return super.toString() + " {value=\"" + new String(this.mData, 0, this.mData.length <= 50 ? this.mData.length : 47) + (this.mChunkLength <= 50 ? "" : "...") + "\"}";
    }
}

