/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

class GRABChunk
extends IFFChunk {
    Point2D mPoint;

    protected GRABChunk(int pChunkLength) {
        super(1196572994, pChunkLength);
    }

    protected GRABChunk(Point2D pPoint) {
        super(1196572994, 4);
        this.mPoint = pPoint;
    }

    void readChunk(DataInput pInput) throws IOException {
        if (this.mChunkLength != 4) {
            throw new IIOException("Unknown GRAB chunk size: " + this.mChunkLength);
        }
        this.mPoint = new Point(pInput.readShort(), pInput.readShort());
    }

    void writeChunk(DataOutput pOutput) throws IOException {
        pOutput.writeShort((int)this.mPoint.getX());
        pOutput.writeShort((int)this.mPoint.getY());
    }

    public String toString() {
        return super.toString() + " {point=" + this.mPoint + "}";
    }
}

