/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

class CMAPChunk
extends IFFChunk {
    byte[] mReds;
    byte[] mGreens;
    byte[] mBlues;
    boolean mEHB;
    private final BMHDChunk mHeader;
    private final CAMGChunk mCamg;
    private IndexColorModel mModel;

    protected CMAPChunk(int pChunkLength, BMHDChunk pHeader, CAMGChunk pCamg) {
        super(1129136464, pChunkLength);
        this.mHeader = pHeader;
        this.mCamg = pCamg;
    }

    public CMAPChunk(IndexColorModel pModel) {
        super(1129136464, pModel.getMapSize() * 3);
        this.mModel = pModel;
        this.mHeader = null;
        this.mCamg = null;
    }

    void readChunk(DataInput pInput) throws IOException {
        int i;
        boolean isEHB;
        int numColors;
        int paletteSize = numColors = this.mChunkLength / 3;
        boolean bl = isEHB = this.mCamg != null && this.mCamg.isEHB();
        if (isEHB) {
            if (numColors == 32) {
                paletteSize = 64;
            } else {
                throw new IIOException("Unknown number of colors for EHB: " + numColors);
            }
        }
        this.mReds = new byte[paletteSize];
        this.mGreens = (byte[])this.mReds.clone();
        this.mBlues = (byte[])this.mReds.clone();
        for (i = 0; i < numColors; ++i) {
            this.mReds[i] = pInput.readByte();
            this.mGreens[i] = pInput.readByte();
            this.mBlues[i] = pInput.readByte();
        }
        if (isEHB) {
            for (i = 0; i < numColors; ++i) {
                this.mReds[i + numColors] = (byte)((this.mReds[i] & 0xFF) / 2);
                this.mGreens[i + numColors] = (byte)((this.mGreens[i] & 0xFF) / 2);
                this.mBlues[i + numColors] = (byte)((this.mBlues[i] & 0xFF) / 2);
            }
        }
        if (this.mChunkLength % 2 != 0) {
            pInput.readByte();
        }
        int trans = this.mHeader.mMaskType == 2 ? this.mHeader.mTransparentIndex : -1;
        this.mModel = new InverseColorMapIndexColorModel(this.mHeader.mBitplanes, this.mReds.length, this.mReds, this.mGreens, this.mBlues, trans);
    }

    void writeChunk(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.mChunkId);
        pOutput.writeInt(this.mChunkLength);
        int length = this.mModel.getMapSize();
        for (int i = 0; i < length; ++i) {
            pOutput.writeByte(this.mModel.getRed(i));
            pOutput.writeByte(this.mModel.getGreen(i));
            pOutput.writeByte(this.mModel.getBlue(i));
        }
        if (this.mChunkLength % 2 != 0) {
            pOutput.writeByte(0);
        }
    }

    public String toString() {
        return super.toString() + " {colorMap=" + this.mModel + "}";
    }

    IndexColorModel getIndexColorModel() {
        return this.mModel;
    }

    public BufferedImage createPaletteImage() {
        IndexColorModel cm = this.getIndexColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(cm.getMapSize(), 1);
        byte[] pixel = null;
        for (int x = 0; x < cm.getMapSize(); ++x) {
            pixel = (byte[])cm.getDataElements(cm.getRGB(x), pixel);
            raster.setDataElements(x, 0, pixel);
        }
        return new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
    }
}

