/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

class CAMGChunk
extends IFFChunk {
    private int mCAMG;

    public CAMGChunk(int pLength) {
        super(1128353095, pLength);
    }

    void readChunk(DataInput pInput) throws IOException {
        if (this.mChunkLength != 4) {
            throw new IIOException("Unknown CAMG chunk length: " + this.mChunkLength);
        }
        this.mCAMG = pInput.readInt();
    }

    void writeChunk(DataOutput pOutput) throws IOException {
        throw new InternalError("Not implemented: writeChunk()");
    }

    boolean isHAM() {
        return (this.mCAMG & 0x800) != 0;
    }

    boolean isEHB() {
        return (this.mCAMG & 0x80) != 0;
    }

    public String toString() {
        return super.toString() + " {mode=" + (this.isHAM() ? "HAM" : (this.isEHB() ? "EHB" : "Normal")) + "}";
    }
}

