/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

class BMHDChunk
extends IFFChunk {
    static final int MASK_NONE = 0;
    static final int MASK_HAS_MASK = 1;
    static final int MASK_TRANSPARENT_COLOR = 2;
    static final int MASK_LASSO = 3;
    static final int COMPRESSION_NONE = 0;
    static final int COMPRESSION_BYTE_RUN = 1;
    int mWidth;
    int mHeight;
    int mXPos;
    int mYPos;
    int mBitplanes;
    int mMaskType;
    int mCompressionType;
    int mTransparentIndex;
    int mXAspect;
    int mYAspect;
    int mPageWidth;
    int mPageHeight;

    protected BMHDChunk(int pChunkLength) {
        super(1112361028, pChunkLength);
    }

    protected BMHDChunk(int pWidth, int pHeight, int pBitplanes, int pMaskType, int pCompressionType, int pTransparentIndex) {
        super(1112361028, 20);
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        this.mXPos = 0;
        this.mYPos = 0;
        this.mBitplanes = pBitplanes;
        this.mMaskType = pMaskType;
        this.mCompressionType = pCompressionType;
        this.mTransparentIndex = pTransparentIndex;
        this.mXAspect = 1;
        this.mYAspect = 1;
        this.mPageWidth = Math.min(pWidth, Short.MAX_VALUE);
        this.mPageHeight = Math.min(pHeight, Short.MAX_VALUE);
    }

    void readChunk(DataInput pInput) throws IOException {
        if (this.mChunkLength != 20) {
            throw new IIOException("Unknown BMHD chunk length: " + this.mChunkLength);
        }
        this.mWidth = pInput.readUnsignedShort();
        this.mHeight = pInput.readUnsignedShort();
        this.mXPos = pInput.readShort();
        this.mYPos = pInput.readShort();
        this.mBitplanes = pInput.readUnsignedByte();
        this.mMaskType = pInput.readUnsignedByte();
        this.mCompressionType = pInput.readUnsignedByte();
        pInput.readByte();
        this.mTransparentIndex = pInput.readUnsignedShort();
        this.mXAspect = pInput.readUnsignedByte();
        this.mYAspect = pInput.readUnsignedByte();
        this.mPageWidth = pInput.readShort();
        this.mPageHeight = pInput.readShort();
    }

    void writeChunk(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.mChunkId);
        pOutput.writeInt(this.mChunkLength);
        pOutput.writeShort(this.mWidth);
        pOutput.writeShort(this.mHeight);
        pOutput.writeShort(this.mXPos);
        pOutput.writeShort(this.mYPos);
        pOutput.writeByte(this.mBitplanes);
        pOutput.writeByte(this.mMaskType);
        pOutput.writeByte(this.mCompressionType);
        pOutput.writeByte(0);
        pOutput.writeShort(this.mTransparentIndex);
        pOutput.writeByte(this.mXAspect);
        pOutput.writeByte(this.mYAspect);
        pOutput.writeShort(this.mPageWidth);
        pOutput.writeShort(this.mPageHeight);
    }

    public String toString() {
        return super.toString() + " {w=" + this.mWidth + ", h=" + this.mHeight + ", x=" + this.mXPos + ", y=" + this.mYPos + ", planes=" + this.mBitplanes + ", mask=" + this.mMaskType + ", compression=" + this.mCompressionType + ", trans=" + this.mTransparentIndex + ", xAspect=" + this.mXAspect + ", yAspect=" + this.mYAspect + ", pageWidth=" + this.mPageWidth + ", pageHeight=" + this.mPageHeight + "}";
    }
}

