/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.xwd;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.xwd.XWDX11Header;
import com.twelvemonkeys.lang.Validate;
import java.nio.ByteOrder;
import javax.imageio.metadata.IIOMetadataNode;

final class XWDImageMetadata
extends AbstractMetadata {
    private final XWDX11Header header;

    XWDImageMetadata(XWDX11Header xWDX11Header) {
        super(true, null, null, null, null);
        this.header = (XWDX11Header)Validate.notNull((Object)xWDX11Header, (String)"header");
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.visualClass) {
            case 0: 
            case 1: {
                iIOMetadataNode2.setAttribute("name", "GRAY");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("name", "RGB");
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        switch (this.header.visualClass) {
            case 2: 
            case 3: {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Palette");
                iIOMetadataNode.appendChild(iIOMetadataNode3);
                for (int i = 0; i < this.header.colorMap.getMapSize(); ++i) {
                    IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("PaletteEntry");
                    iIOMetadataNode4.setAttribute("index", Integer.toString(i));
                    iIOMetadataNode4.setAttribute("red", Integer.toString(this.header.colorMap.getRed(i)));
                    iIOMetadataNode4.setAttribute("green", Integer.toString(this.header.colorMap.getGreen(i)));
                    iIOMetadataNode4.setAttribute("blue", Integer.toString(this.header.colorMap.getBlue(i)));
                    iIOMetadataNode3.appendChild(iIOMetadataNode4);
                }
                break;
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        switch (this.header.visualClass) {
            case 2: 
            case 3: {
                iIOMetadataNode3.setAttribute("value", "Index");
                break;
            }
            default: {
                iIOMetadataNode3.setAttribute("value", "UnsignedIntegral");
            }
        }
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        int n = this.header.numComponents();
        iIOMetadataNode4.setAttribute("value", this.createListValue(n, Integer.toString(this.header.bitsPerPixel / n)));
        if (this.header.bitsPerRGB < 8 && this.header.bitFillOrder == ByteOrder.LITTLE_ENDIAN) {
            IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("SampleMSB");
            iIOMetadataNode.appendChild(iIOMetadataNode5);
            iIOMetadataNode5.setAttribute("value", this.createListValue(this.header.numComponents(), "0"));
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2.setAttribute("value", "7");
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        if (this.header.windowName != null) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2.setAttribute("keyword", "DocumentName");
            iIOMetadataNode2.setAttribute("value", this.header.windowName);
        }
        return iIOMetadataNode.hasChildNodes() ? iIOMetadataNode : null;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }
}

