/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorProfiles;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFReader;
import com.twelvemonkeys.imageio.metadata.xmp.XMPReader;
import com.twelvemonkeys.imageio.plugins.webp.AnimationFrame;
import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import com.twelvemonkeys.imageio.plugins.webp.RIFFChunk;
import com.twelvemonkeys.imageio.plugins.webp.VP8xChunk;
import com.twelvemonkeys.imageio.plugins.webp.WebPImageMetadata;
import com.twelvemonkeys.imageio.plugins.webp.lossless.VP8LDecoder;
import com.twelvemonkeys.imageio.plugins.webp.vp8.VP8Frame;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class WebPImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.webp.debug"));
    private LSBBitReader lsbBitReader;
    private long fileSize;
    private VP8xChunk header;
    private ICC_Profile iccProfile;
    private final List<AnimationFrame> frames = new ArrayList<AnimationFrame>();

    WebPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.fileSize = -1L;
        this.header = null;
        this.iccProfile = null;
        this.lsbBitReader = null;
        this.frames.clear();
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.lsbBitReader = new LSBBitReader(this.imageInput);
    }

    private void readHeader(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        if (this.header.containsANIM) {
            this.readFrame(n);
        }
    }

    private void readFrame(int n) throws IOException {
        if (!this.header.containsANIM) {
            throw new IndexOutOfBoundsException("imageIndex >= 1 for non-animated WebP: " + n);
        }
        if (n < this.frames.size()) {
            return;
        }
        VP8xChunk vP8xChunk = this.frames.isEmpty() ? this.header : (RIFFChunk)this.frames.get(this.frames.size() - 1);
        this.imageInput.seek(vP8xChunk.offset + vP8xChunk.length);
        while (this.imageInput.getStreamPosition() < this.fileSize) {
            int n2 = this.imageInput.readInt();
            long l = this.imageInput.readUnsignedInt();
            long l2 = this.imageInput.getStreamPosition();
            if (DEBUG) {
                System.out.printf("chunk: '%s'\n", WebPImageReader.fourCC(n2));
                System.out.println("chunkLength: " + l);
                System.out.println("chunkStart: " + l2);
            }
            switch (n2) {
                case 1296649793: {
                    break;
                }
                case 1179471425: {
                    int n3 = 2 * (int)this.lsbBitReader.readBits(24);
                    int n4 = 2 * (int)this.lsbBitReader.readBits(24);
                    int n5 = 1 + (int)this.lsbBitReader.readBits(24);
                    int n6 = 1 + (int)this.lsbBitReader.readBits(24);
                    Rectangle rectangle = new Rectangle(n3, n4, n5, n6);
                    int n7 = (int)this.imageInput.readBits(24);
                    int n8 = this.imageInput.readUnsignedByte();
                    this.frames.add(new AnimationFrame(l, l2, rectangle, n7, n8));
                    break;
                }
            }
            if (n < this.frames.size()) {
                return;
            }
            this.imageInput.seek(l2 + l + (l & 1L));
        }
        throw new IndexOutOfBoundsException(String.format("imageIndex > %d: %d", this.frames.size(), n));
    }

    private void readHeader() throws IOException {
        if (this.header != null) {
            return;
        }
        this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.imageInput.seek(0L);
        int n = this.imageInput.readInt();
        if (n != 1179011410) {
            throw new IIOException(String.format("Not a WebP file, invalid 'RIFF' magic: '%s'", WebPImageReader.fourCC(n)));
        }
        this.fileSize = 8L + this.imageInput.readUnsignedInt();
        int n2 = this.imageInput.readInt();
        if (n2 != 1346520407) {
            throw new IIOException(String.format("Not a WebP file, invalid 'WEBP' magic: '%s'", WebPImageReader.fourCC(n2)));
        }
        int n3 = this.imageInput.readInt();
        long l = this.imageInput.readUnsignedInt();
        this.header = new VP8xChunk(n3, l, this.imageInput.getStreamPosition());
        switch (n3) {
            case 540561494: {
                int n4 = this.lsbBitReader.readBit();
                if (n4 != 0) {
                    throw new IIOException("Unexpected WebP frame type, expected key frame (0): " + n4);
                }
                int n5 = (int)this.lsbBitReader.readBits(3);
                int n6 = this.lsbBitReader.readBit();
                if (DEBUG) {
                    System.out.println("versionNumber: " + n5);
                    System.out.println("showFrame: " + n6);
                }
                this.lsbBitReader.readBits(19);
                this.imageInput.readUnsignedByte();
                this.imageInput.readUnsignedByte();
                this.imageInput.readUnsignedByte();
                int n7 = this.imageInput.readUnsignedShort();
                this.header.width = n7 & 0x3FFF;
                int n8 = this.imageInput.readUnsignedShort();
                this.header.height = n8 & 0x3FFF;
                break;
            }
            case 1278758998: {
                byte by = this.imageInput.readByte();
                if (by != 47) {
                    throw new IIOException(String.format("Unexpected 'VP8L' signature, expected 0x0x%2x: 0x%2x", (byte)47, by));
                }
                this.header.isLossless = true;
                this.header.width = 1 + (int)this.lsbBitReader.readBits(14);
                this.header.height = 1 + (int)this.lsbBitReader.readBits(14);
                this.header.containsALPH = this.lsbBitReader.readBit() == 1;
                int n9 = (int)this.lsbBitReader.readBits(3);
                if (n9 == 0) break;
                throw new IIOException(String.format("Unexpected 'VP8L' version, expected 0: %d", n9));
            }
            case 1480085590: {
                if (l != 10L) {
                    throw new IIOException("Unexpected 'VP8X' chunk length, expected 10: " + l);
                }
                int n10 = (int)this.imageInput.readBits(2);
                if (n10 != 0) {
                    throw new IIOException(String.format("Unexpected 'VP8X' chunk reserved value, expected 0: %d", n10));
                }
                this.header.containsICCP = this.imageInput.readBit() == 1;
                this.header.containsALPH = this.imageInput.readBit() == 1;
                this.header.containsEXIF = this.imageInput.readBit() == 1;
                this.header.containsXMP_ = this.imageInput.readBit() == 1;
                this.header.containsANIM = this.imageInput.readBit() == 1;
                n10 = (int)this.imageInput.readBits(25);
                if (n10 != 0) {
                    throw new IIOException(String.format("Unexpected 'VP8X' chunk reserved value, expected 0: %d", n10));
                }
                this.header.width = 1 + (int)this.lsbBitReader.readBits(24);
                this.header.height = 1 + (int)this.lsbBitReader.readBits(24);
                if (!this.header.containsICCP) break;
                while (this.iccProfile == null && this.imageInput.getStreamPosition() < this.fileSize) {
                    int n11 = this.imageInput.readInt();
                    long l2 = this.imageInput.readUnsignedInt();
                    long l3 = this.imageInput.getStreamPosition();
                    if (n11 == 1346585417) {
                        this.iccProfile = ColorProfiles.readProfile((InputStream)IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)l2));
                    } else {
                        this.processWarningOccurred(String.format("Expected 'ICCP' chunk, '%s' chunk encountered", WebPImageReader.fourCC(n11)));
                    }
                    this.imageInput.seek(l3 + l2 + (l2 & 1L));
                }
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown WebP chunk: '%s'", WebPImageReader.fourCC(n3)));
            }
        }
        if (DEBUG) {
            System.out.println("file size: " + this.fileSize + " (stream length: " + this.imageInput.length() + ")");
            System.out.println("header: " + this.header);
        }
    }

    static String fourCC(int n) {
        return new String(new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF000000) >>> 24)}, StandardCharsets.US_ASCII);
    }

    public int getNumImages(boolean bl) throws IOException {
        this.assertInput();
        this.readHeader();
        if (this.header.containsANIM && bl) {
            if (this.isSeekForwardOnly()) {
                throw new IllegalStateException("Illegal combination of allowSearch with seekForwardOnly");
            }
            this.readAllFrames();
            return this.frames.size();
        }
        return this.header.containsANIM ? -1 : 1;
    }

    private void readAllFrames() throws IOException {
        try {
            this.readFrame(Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getWidth(int n) throws IOException {
        this.readHeader(n);
        return this.header.containsANIM ? this.frames.get((int)n).bounds.width : this.header.width;
    }

    public int getHeight(int n) throws IOException {
        this.readHeader(n);
        return this.header.containsANIM ? this.frames.get((int)n).bounds.height : this.header.height;
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.readHeader(n);
        if (this.iccProfile != null && !ColorProfiles.isCS_sRGB((ICC_Profile)this.iccProfile)) {
            int[] nArray;
            ICC_ColorSpace iCC_ColorSpace = ColorSpaces.createColorSpace((ICC_Profile)this.iccProfile);
            if (this.header.containsALPH) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            int[] nArray4 = nArray;
            return ImageTypeSpecifiers.createInterleaved((ColorSpace)iCC_ColorSpace, (int[])nArray4, (int)0, (boolean)this.header.containsALPH, (boolean)false);
        }
        return ImageTypeSpecifiers.createFromBufferedImageType((int)(this.header.containsALPH ? 6 : 5));
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        if (imageTypeSpecifier.getBufferedImageType() == 0) {
            arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)(this.header.containsALPH ? 6 : 5)));
        }
        arrayList.add(imageTypeSpecifier);
        arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)(this.header.containsALPH ? 2 : 1)));
        arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)(this.header.containsALPH ? 3 : 4)));
        return arrayList.iterator();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = WebPImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)n2, (int)n3);
        this.processImageStarted(n);
        switch (this.header.fourCC) {
            case 540561494: {
                this.imageInput.seek(this.header.offset);
                this.readVP8(RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster()), imageReadParam);
                break;
            }
            case 1278758998: {
                this.imageInput.seek(this.header.offset);
                this.readVP8Lossless(RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster()), imageReadParam);
                break;
            }
            case 1480085590: {
                if (this.header.containsANIM) {
                    AnimationFrame animationFrame = this.frames.get(n);
                    this.imageInput.seek(animationFrame.offset + 16L);
                    this.opaqueAlpha(bufferedImage.getAlphaRaster());
                    this.readVP8Extended(bufferedImage, imageReadParam, animationFrame.offset + animationFrame.length);
                    break;
                }
                this.imageInput.seek(this.header.offset + this.header.length);
                this.readVP8Extended(bufferedImage, imageReadParam, this.fileSize);
                break;
            }
            default: {
                throw new IIOException("Unknown first chunk for WebP: " + WebPImageReader.fourCC(this.header.fourCC));
            }
        }
        this.applyICCProfileIfNeeded(bufferedImage);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    private void readVP8Extended(BufferedImage bufferedImage, ImageReadParam imageReadParam, long l) throws IOException {
        while (this.imageInput.getStreamPosition() < l) {
            int n = this.imageInput.readInt();
            long l2 = this.imageInput.readUnsignedInt();
            long l3 = this.imageInput.getStreamPosition();
            if (DEBUG) {
                System.out.printf("chunk: '%s'\n", WebPImageReader.fourCC(n));
                System.out.println("chunkLength: " + l2);
                System.out.println("chunkStart: " + l3);
            }
            block0 : switch (n) {
                case 1213221953: {
                    int n2 = (int)this.imageInput.readBits(2);
                    if (n2 != 0) {
                        this.processWarningOccurred(String.format("Unexpected 'ALPH' chunk reserved value, expected 0: %d", n2));
                    }
                    int n3 = (int)this.imageInput.readBits(2);
                    int n4 = (int)this.imageInput.readBits(2);
                    int n5 = (int)this.imageInput.readBits(2);
                    if (DEBUG) {
                        System.out.println("preProcessing: " + n3);
                        System.out.println("filtering: " + n4);
                        System.out.println("compression: " + n5);
                    }
                    switch (n5) {
                        case 0: {
                            this.readUncompressedAlpha(bufferedImage.getAlphaRaster());
                            break block0;
                        }
                        case 1: {
                            this.opaqueAlpha(bufferedImage.getAlphaRaster());
                            break block0;
                        }
                    }
                    this.processWarningOccurred("Unknown WebP alpha compression: " + n5);
                    this.opaqueAlpha(bufferedImage.getAlphaRaster());
                    break;
                }
                case 540561494: {
                    this.readVP8(RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster()).createWritableChild(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, new int[]{0, 1, 2}), imageReadParam);
                    break;
                }
                case 1278758998: {
                    this.readVP8Lossless(RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster()), imageReadParam);
                    break;
                }
                case 1179471425: 
                case 1296649793: {
                    if (!this.header.containsANIM) {
                        this.processWarningOccurred("Ignoring unsupported chunk: " + WebPImageReader.fourCC(n));
                    }
                }
                case 542133592: 
                case 1179211845: 
                case 1346585417: {
                    break;
                }
                default: {
                    this.processWarningOccurred("Ignoring unexpected chunk: " + WebPImageReader.fourCC(n));
                }
            }
            this.imageInput.seek(l3 + l2 + (l2 & 1L));
        }
    }

    private void applyICCProfileIfNeeded(BufferedImage bufferedImage) {
        ColorModel colorModel;
        ICC_Profile iCC_Profile;
        if (this.iccProfile != null && !this.iccProfile.equals(iCC_Profile = ((ICC_ColorSpace)(colorModel = bufferedImage.getColorModel()).getColorSpace()).getProfile())) {
            if (DEBUG) {
                System.err.println("Converting from " + this.iccProfile + " to " + (ColorProfiles.isCS_sRGB((ICC_Profile)iCC_Profile) ? "sRGB" : iCC_Profile));
            }
            WritableRaster writableRaster = colorModel.hasAlpha() ? bufferedImage.getRaster().createWritableChild(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, new int[]{0, 1, 2}) : bufferedImage.getRaster();
            new ColorConvertOp(new ICC_Profile[]{this.iccProfile, iCC_Profile}, null).filter(writableRaster, writableRaster);
        }
    }

    private void opaqueAlpha(WritableRaster writableRaster) {
        int n = writableRaster.getHeight();
        int n2 = writableRaster.getWidth();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                writableRaster.setSample(j, i, 0, 255);
            }
        }
    }

    private void readUncompressedAlpha(WritableRaster writableRaster) throws IOException {
        this.processWarningOccurred("Uncompressed WebP alpha not implemented");
        this.opaqueAlpha(writableRaster);
    }

    private void readVP8Lossless(WritableRaster writableRaster, ImageReadParam imageReadParam) throws IOException {
        VP8LDecoder vP8LDecoder = new VP8LDecoder(this.imageInput, DEBUG);
        vP8LDecoder.readVP8Lossless(writableRaster, true);
    }

    private void readVP8(WritableRaster writableRaster, ImageReadParam imageReadParam) throws IOException {
        VP8Frame vP8Frame = new VP8Frame(this.imageInput, DEBUG);
        vP8Frame.setProgressListener((IIOReadProgressListener)new ProgressListenerBase(){

            public void imageProgress(ImageReader imageReader, float f) {
                WebPImageReader.this.processImageProgress(f);
            }
        });
        if (!vP8Frame.decode(writableRaster, imageReadParam)) {
            this.processWarningOccurred("Nothing to decode");
        }
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readHeader(n);
        this.readMeta();
        return new WebPImageMetadata(this.header);
    }

    private void readMeta() throws IOException {
        if (this.header.containsEXIF || this.header.containsXMP_) {
            this.imageInput.seek(this.header.offset + this.header.length);
            while (this.imageInput.getStreamPosition() < this.fileSize) {
                int n = this.imageInput.readInt();
                long l = this.imageInput.readUnsignedInt();
                long l2 = this.imageInput.getStreamPosition();
                switch (n) {
                    case 1179211845: {
                        int n2 = 0;
                        byte[] byArray = new byte[6];
                        this.imageInput.readFully(byArray);
                        if (byArray[0] == 69 && byArray[1] == 120 && byArray[2] == 105 && byArray[3] == 102 && byArray[4] == 0 && byArray[5] == 0) {
                            n2 = 6;
                        } else {
                            this.imageInput.seek(l2);
                        }
                        SubImageInputStream subImageInputStream = new SubImageInputStream(this.imageInput, l - (long)n2);
                        Directory directory = new TIFFReader().read((ImageInputStream)subImageInputStream);
                        if (!DEBUG) break;
                        System.out.println("exif: " + directory);
                        break;
                    }
                    case 542133592: {
                        Directory directory = new XMPReader().read((ImageInputStream)new SubImageInputStream(this.imageInput, l));
                        if (!DEBUG) break;
                        System.out.println("xmp: " + directory);
                        break;
                    }
                }
                this.imageInput.seek(l2 + l + (l & 1L));
            }
        }
    }
}

