/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import java.io.EOFException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public final class LSBBitReader {
    private final ImageInputStream imageInput;
    int bitOffset = 0;

    public LSBBitReader(ImageInputStream imageInputStream) {
        this.imageInput = imageInputStream;
    }

    public long readBits(int n) throws IOException {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l |= (long)this.readBit() << i;
        }
        return l;
    }

    public int readBit() throws IOException {
        int n = 7 - this.bitOffset;
        this.imageInput.setBitOffset(n);
        int n2 = this.bitOffset + 1 & 7;
        int n3 = this.imageInput.read();
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n2 != 0) {
            this.imageInput.seek(this.imageInput.getStreamPosition() - 1L);
        }
        this.bitOffset = n2;
        return n3 >> 7 - n & 1;
    }
}

