/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.plugins.tga.TGAHeader;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

final class TGAMetadata
extends IIOMetadata {
    private final TGAHeader header;

    TGAMetadata(TGAHeader tGAHeader) {
        this.header = tGAHeader;
        this.standardFormatSupported = true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if ("javax_imageio_1.0".equals(string)) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Unsupported metadata format: " + string);
    }

    @Override
    public void mergeTree(String string, Node node) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    public void reset() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.header.getImageType()) {
            case 3: 
            case 11: {
                iIOMetadataNode2.setAttribute("name", "GRAY");
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 32: 
            case 33: {
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("name", "Unknown");
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        switch (this.header.getPixelDepth()) {
            case 8: 
            case 16: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(1));
                break;
            }
            case 24: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(3));
                break;
            }
            case 32: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(4));
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode4.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IndexColorModel indexColorModel = this.header.getColorMap();
        if (indexColorModel != null) {
            IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild(iIOMetadataNode5);
            for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode6.setAttribute("index", Integer.toString(i));
                iIOMetadataNode6.setAttribute("red", Integer.toString(indexColorModel.getRed(i)));
                iIOMetadataNode6.setAttribute("green", Integer.toString(indexColorModel.getGreen(i)));
                iIOMetadataNode6.setAttribute("blue", Integer.toString(indexColorModel.getBlue(i)));
                iIOMetadataNode5.appendChild(iIOMetadataNode6);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        switch (this.header.getImageType()) {
            case 9: 
            case 10: 
            case 11: 
            case 32: 
            case 33: {
                IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                String string = this.header.getImageType() == 32 || this.header.getImageType() == 33 ? "Uknown" : "RLE";
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
                iIOMetadataNode3.setAttribute("value", "TRUE");
                iIOMetadataNode.appendChild(iIOMetadataNode3);
                return iIOMetadataNode;
            }
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("SampleFormat");
        switch (this.header.getImageType()) {
            case 1: 
            case 9: 
            case 32: 
            case 33: {
                iIOMetadataNode3.setAttribute("value", "Index");
                break;
            }
            default: {
                iIOMetadataNode3.setAttribute("value", "UnsignedIntegral");
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BitsPerSample");
        switch (this.header.getPixelDepth()) {
            case 8: 
            case 16: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(1, Integer.toString(this.header.getPixelDepth())));
                break;
            }
            case 24: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(3, Integer.toString(8)));
                break;
            }
            case 32: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(4, Integer.toString(8)));
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        switch (this.header.getOrigin()) {
            case 0: {
                iIOMetadataNode2.setAttribute("value", "FlipH");
                break;
            }
            case 1: {
                iIOMetadataNode2.setAttribute("value", "Rotate180");
                break;
            }
            case 2: {
                iIOMetadataNode2.setAttribute("value", "Normal");
                break;
            }
            case 3: {
                iIOMetadataNode2.setAttribute("value", "FlipV");
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (this.header.getIdentification() != null && !this.header.getIdentification().isEmpty()) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", "identification");
            iIOMetadataNode2.setAttribute("value", this.header.getIdentification());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.header.getPixelDepth() == 32 ? "nonpremultiplied" : "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

