/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PSDLayerMaskData {
    private int top;
    private int left;
    private int bottom;
    private int right;
    private int defaultColor;
    private int flags;
    private int maskParams;
    private int userMaskDensity;
    private double userMaskFeather;
    private int vectorMaskDensity;
    private double vectorMaskFeather;

    PSDLayerMaskData(ImageInputStream imageInputStream, int n) throws IOException {
        if (n < 20 || n > 55) {
            throw new IIOException("Illegal PSD Layer Mask data size: " + n + " (expected between 20 and 55)");
        }
        this.top = imageInputStream.readInt();
        this.left = imageInputStream.readInt();
        this.bottom = imageInputStream.readInt();
        this.right = imageInputStream.readInt();
        this.defaultColor = imageInputStream.readUnsignedByte();
        this.flags = imageInputStream.readUnsignedByte();
        int n2 = n - 18;
        if ((this.flags & 0x10) != 0) {
            this.maskParams = imageInputStream.readUnsignedByte();
            --n2;
            if ((this.maskParams & 1) != 0) {
                this.userMaskDensity = imageInputStream.readByte();
                --n2;
            }
            if ((this.maskParams & 2) != 0) {
                this.userMaskFeather = imageInputStream.readDouble();
                n2 -= 8;
            }
            if ((this.maskParams & 4) != 0) {
                this.vectorMaskDensity = imageInputStream.readByte();
                --n2;
            }
            if ((this.maskParams & 8) != 0) {
                this.vectorMaskFeather = imageInputStream.readDouble();
                n2 -= 8;
            }
        }
        if (n == 20 && n2 == 2) {
            imageInputStream.readShort();
            n2 -= 2;
        } else {
            if (n2 >= 2) {
                this.flags = imageInputStream.readUnsignedByte();
                --n2;
                this.defaultColor = imageInputStream.readUnsignedByte();
                --n2;
            }
            if (n2 >= 16) {
                this.top = imageInputStream.readInt();
                this.left = imageInputStream.readInt();
                this.bottom = imageInputStream.readInt();
                this.right = imageInputStream.readInt();
                n2 -= 16;
            }
        }
        if (n2 > 0) {
            imageInputStream.skipBytes(n2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.top);
        stringBuilder.append(", left: ").append(this.left);
        stringBuilder.append(", bottom: ").append(this.bottom);
        stringBuilder.append(", right: ").append(this.right);
        stringBuilder.append(", default color: ").append(this.defaultColor);
        stringBuilder.append(", flags: ").append(Integer.toBinaryString(this.flags));
        stringBuilder.append(" (");
        if ((this.flags & 1) != 0) {
            stringBuilder.append("relative");
        } else {
            stringBuilder.append("absolute");
        }
        if ((this.flags & 2) != 0) {
            stringBuilder.append(", disabled");
        } else {
            stringBuilder.append(", enabled");
        }
        if ((this.flags & 4) != 0) {
            stringBuilder.append(", inverted");
        }
        if ((this.flags & 8) != 0) {
            stringBuilder.append(", from rendered data");
        }
        if ((this.flags & 0x10) != 0) {
            stringBuilder.append(", has parameters");
        }
        if ((this.flags & 0x20) != 0) {
            stringBuilder.append(", unknown flag (bit 5)");
        }
        if ((this.flags & 0x40) != 0) {
            stringBuilder.append(", unknown flag (bit 6)");
        }
        if ((this.flags & 0x80) != 0) {
            stringBuilder.append(", unknown flag (bit 7)");
        }
        stringBuilder.append(")");
        if ((this.flags & 0x10) != 0) {
            if ((this.maskParams & 1) != 0) {
                stringBuilder.append(", userMaskDensity: ").append(this.userMaskDensity);
            }
            if ((this.maskParams & 2) != 0) {
                stringBuilder.append(", userMaskFeather: ").append(this.userMaskFeather);
            }
            if ((this.maskParams & 4) != 0) {
                stringBuilder.append(", vectorMaskDensity: ").append(this.vectorMaskDensity);
            }
            if ((this.maskParams & 8) != 0) {
                stringBuilder.append(", vectorMaskFeather: ").append(this.vectorMaskFeather);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

