/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelSourceDestinationRange;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerBlendMode;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerMaskData;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PSDLayerInfo {
    final int top;
    final int left;
    final int bottom;
    final int right;
    final PSDChannelInfo[] channelInfo;
    final PSDLayerBlendMode blendMode;
    final PSDLayerMaskData layerMaskData;
    final PSDChannelSourceDestinationRange[] ranges;
    private final String layerName;
    private final String unicodeLayerName;
    private final int layerId;
    int groupId = -1;
    final boolean isGroup;
    final boolean isDivider;

    PSDLayerInfo(boolean bl, ImageInputStream imageInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        this.top = imageInputStream.readInt();
        this.left = imageInputStream.readInt();
        this.bottom = imageInputStream.readInt();
        this.right = imageInputStream.readInt();
        int n4 = imageInputStream.readUnsignedShort();
        this.channelInfo = new PSDChannelInfo[n4];
        for (int i = 0; i < n4; ++i) {
            short s = imageInputStream.readShort();
            long l = bl ? imageInputStream.readLong() : imageInputStream.readUnsignedInt();
            this.channelInfo[i] = new PSDChannelInfo(s, l);
        }
        this.blendMode = new PSDLayerBlendMode(imageInputStream);
        long l = imageInputStream.readUnsignedInt();
        int n5 = imageInputStream.readInt();
        this.layerMaskData = n5 != 0 ? new PSDLayerMaskData(imageInputStream, n5) : null;
        int n6 = imageInputStream.readInt();
        if (n6 % 8 != 0) {
            throw new IIOException("Illegal PSD Layer Blending Data size: " + n6 + ", expected multiple of 8");
        }
        this.ranges = new PSDChannelSourceDestinationRange[n6 / 8];
        for (n3 = 0; n3 < this.ranges.length; ++n3) {
            this.ranges[n3] = new PSDChannelSourceDestinationRange(imageInputStream, n3 == 0 ? "Gray" : "Channel " + (n3 - 1));
        }
        this.layerName = PSDUtil.readPascalString(imageInputStream);
        n3 = this.layerName.length() + 1;
        if (n3 % 4 != 0) {
            n2 = 4 - n3 % 4;
            imageInputStream.skipBytes(n2);
            n3 += n2;
        }
        n2 = -1;
        String string = null;
        int n7 = 0;
        long l2 = imageInputStream.getStreamPosition();
        long l3 = l2 + l - (long)n5 - 4L - (long)n6 - 4L - (long)n3;
        while (imageInputStream.getStreamPosition() < l3 && ((n = imageInputStream.readInt()) == 943868237 || n == 943863348)) {
            int n8 = imageInputStream.readInt();
            boolean bl2 = n != 943868237;
            long l4 = bl2 ? imageInputStream.readLong() : imageInputStream.readUnsignedInt();
            long l5 = imageInputStream.getStreamPosition();
            switch (n8) {
                case 1819635305: {
                    string = PSDUtil.readUnicodeString(imageInputStream);
                    break;
                }
                case 1819896164: {
                    if (l4 != 4L) {
                        throw new IIOException(String.format("Expected layerId length == 4: %d", l4));
                    }
                    n2 = imageInputStream.readInt();
                    break;
                }
                case 1819501428: 
                case 1819501675: {
                    if (l4 < 4L) {
                        throw new IIOException(String.format("Expected sectionDividerSetting length >= 4: %d", l4));
                    }
                    n7 = imageInputStream.readInt();
                    imageInputStream.skipBytes(l4 - 4L);
                    break;
                }
                default: {
                    imageInputStream.skipBytes(l4);
                }
            }
            if (imageInputStream.getStreamPosition() == l5 + l4) continue;
            imageInputStream.seek(l5 + l4);
        }
        this.layerId = n2;
        this.unicodeLayerName = string;
        this.isGroup = n7 == 1 || n7 == 2;
        boolean bl3 = this.isDivider = n7 == 3;
        if (imageInputStream.getStreamPosition() != l3) {
            imageInputStream.seek(l3);
        }
    }

    String getLayerName() {
        return this.unicodeLayerName != null ? this.unicodeLayerName : this.layerName;
    }

    int getLayerId() {
        return this.layerId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.top);
        stringBuilder.append(", left: ").append(this.left);
        stringBuilder.append(", bottom: ").append(this.bottom);
        stringBuilder.append(", right: ").append(this.right);
        stringBuilder.append(", channels: ").append(Arrays.toString(this.channelInfo));
        stringBuilder.append(", blend mode: ").append(this.blendMode);
        if (this.layerMaskData != null) {
            stringBuilder.append(", layer mask data: ").append(this.layerMaskData);
        }
        stringBuilder.append(", ranges: ").append(Arrays.toString(this.ranges));
        stringBuilder.append(", layer name: \"").append(this.getLayerName()).append("\"");
        stringBuilder.append(", layer id: ").append(this.getLayerId());
        if (this.groupId != -1) {
            stringBuilder.append(", group id: ").append(this.groupId);
        }
        if (this.isGroup) {
            stringBuilder.append(", isGroup");
        }
        if (this.isDivider) {
            stringBuilder.append(", isDivider");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

