/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerMaskData {
    private int top;
    private int left;
    private int bottom;
    private int right;
    private int defaultColor;
    private int flags;
    private boolean large;
    private int realFlags;
    private int realUserBackground;
    private int realTop;
    private int realLeft;
    private int realBottom;
    private int realRight;

    PSDLayerMaskData(ImageInputStream imageInputStream, int n) throws IOException {
        if (n != 20 && n != 36) {
            throw new IIOException("Illegal PSD Layer Mask data size: " + n + " (expeced 20 or 36)");
        }
        this.top = imageInputStream.readInt();
        this.left = imageInputStream.readInt();
        this.bottom = imageInputStream.readInt();
        this.right = imageInputStream.readInt();
        this.defaultColor = imageInputStream.readUnsignedByte();
        this.flags = imageInputStream.readUnsignedByte();
        if (n == 20) {
            imageInputStream.readShort();
        } else {
            this.large = true;
            this.realFlags = imageInputStream.readUnsignedByte();
            this.realUserBackground = imageInputStream.readUnsignedByte();
            this.realTop = imageInputStream.readInt();
            this.realLeft = imageInputStream.readInt();
            this.realBottom = imageInputStream.readInt();
            this.realRight = imageInputStream.readInt();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.top);
        stringBuilder.append(", left: ").append(this.left);
        stringBuilder.append(", bottom: ").append(this.bottom);
        stringBuilder.append(", right: ").append(this.right);
        stringBuilder.append(", default color: ").append(this.defaultColor);
        stringBuilder.append(", flags: ").append(Integer.toBinaryString(this.flags));
        stringBuilder.append(" (");
        if ((this.flags & 1) != 0) {
            stringBuilder.append("Pos. rel. to layer");
        } else {
            stringBuilder.append("Pos. abs.");
        }
        if ((this.flags & 2) != 0) {
            stringBuilder.append(", Mask disabled");
        } else {
            stringBuilder.append(", Mask enabled");
        }
        if ((this.flags & 4) != 0) {
            stringBuilder.append(", Invert mask");
        }
        if ((this.flags & 8) != 0) {
            stringBuilder.append(", Unknown bit 3");
        }
        if ((this.flags & 0x10) != 0) {
            stringBuilder.append(", Unknown bit 4");
        }
        if ((this.flags & 0x20) != 0) {
            stringBuilder.append(", Unknown bit 5");
        }
        if ((this.flags & 0x40) != 0) {
            stringBuilder.append(", Unknown bit 6");
        }
        if ((this.flags & 0x80) != 0) {
            stringBuilder.append(", Unknown bit 7");
        }
        stringBuilder.append(")");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

