/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelSourceDestinationRange;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerBlendMode;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerMaskData;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerInfo {
    final int top;
    final int left;
    final int bottom;
    final int right;
    final PSDChannelInfo[] channelInfo;
    final PSDLayerBlendMode blendMode;
    final PSDLayerMaskData layerMaskData;
    final PSDChannelSourceDestinationRange[] ranges;
    final String layerName;

    PSDLayerInfo(ImageInputStream imageInputStream) throws IOException {
        int n;
        this.top = imageInputStream.readInt();
        this.left = imageInputStream.readInt();
        this.bottom = imageInputStream.readInt();
        this.right = imageInputStream.readInt();
        int n2 = imageInputStream.readUnsignedShort();
        this.channelInfo = new PSDChannelInfo[n2];
        for (int i = 0; i < n2; ++i) {
            short s = imageInputStream.readShort();
            long l = imageInputStream.readUnsignedInt();
            this.channelInfo[i] = new PSDChannelInfo(s, l);
        }
        this.blendMode = new PSDLayerBlendMode(imageInputStream);
        long l = imageInputStream.readUnsignedInt();
        int n3 = imageInputStream.readInt();
        this.layerMaskData = n3 != 0 ? new PSDLayerMaskData(imageInputStream, n3) : null;
        int n4 = imageInputStream.readInt();
        if (n4 % 8 != 0) {
            throw new IIOException("Illegal PSD Layer Blending Data size: " + n4 + ", expected multiple of 8");
        }
        this.ranges = new PSDChannelSourceDestinationRange[n4 / 8];
        for (n = 0; n < this.ranges.length; ++n) {
            this.ranges[n] = new PSDChannelSourceDestinationRange(imageInputStream, n == 0 ? "Gray" : "Channel " + (n - 1));
        }
        this.layerName = PSDUtil.readPascalString(imageInputStream);
        n = this.layerName.length() + 1;
        if (n % 4 != 0) {
            int n5 = n % 4;
            imageInputStream.skipBytes(n5);
            n += n5;
        }
        imageInputStream.skipBytes(l - (long)n3 - 4L - (long)n4 - 4L - (long)n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.top);
        stringBuilder.append(", left: ").append(this.left);
        stringBuilder.append(", bottom: ").append(this.bottom);
        stringBuilder.append(", right: ").append(this.right);
        stringBuilder.append(", channels: ").append(Arrays.toString(this.channelInfo));
        stringBuilder.append(", blend mode: ").append(this.blendMode);
        if (this.layerMaskData != null) {
            stringBuilder.append(", layer mask data: ").append(this.layerMaskData);
        }
        stringBuilder.append(", ranges: ").append(Arrays.toString(this.ranges));
        stringBuilder.append(", layer name: \"").append(this.layerName).append("\"");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

