/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderWriter;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOImage;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class PAMHeaderWriter
extends HeaderWriter {
    public PAMHeaderWriter(ImageOutputStream imageOutputStream) {
        super(imageOutputStream);
    }

    @Override
    public void writeHeader(IIOImage iIOImage, ImageWriterSpi imageWriterSpi) throws IOException {
        this.imageOutput.writeShort(20535);
        this.imageOutput.write(10);
        this.writeComments(iIOImage.getMetadata(), imageWriterSpi);
        this.imageOutput.write(String.format("WIDTH %s\nHEIGHT %s\n", this.getWidth(iIOImage), this.getHeight(iIOImage)).getBytes(StandardCharsets.UTF_8));
        this.imageOutput.write(String.format("DEPTH %s\n", this.getNumBands(iIOImage)).getBytes(StandardCharsets.UTF_8));
        this.imageOutput.write(String.format("MAXVAL %s\n", this.getMaxVal(iIOImage)).getBytes(StandardCharsets.UTF_8));
        TupleType tupleType = this.getNumBands(iIOImage) > 3 ? TupleType.RGB_ALPHA : TupleType.RGB;
        this.imageOutput.write(String.format("TUPLTYPE %s\nENDHDR\n", new Object[]{tupleType}).getBytes(StandardCharsets.UTF_8));
    }
}

