/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PFMHeaderParser
extends HeaderParser {
    private final short fileType;
    private final TupleType tupleType;

    public PFMHeaderParser(ImageInputStream imageInputStream, short s) {
        super(imageInputStream);
        this.fileType = s;
        this.tupleType = PFMHeaderParser.asTupleType(s);
    }

    static TupleType asTupleType(int n) {
        switch (n) {
            case 20582: {
                return TupleType.GRAYSCALE;
            }
            case 20550: {
                return TupleType.RGB;
            }
        }
        throw new AssertionError((Object)("Illegal PNM type :" + n));
    }

    @Override
    public PNMHeader parse() throws IOException {
        int n = 0;
        int n2 = 0;
        float f = this.tupleType == TupleType.BLACKANDWHITE_WHITE_IS_ZERO ? 1.0f : 0.0f;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n == 0 || n2 == 0 || f == 0.0f) {
            String[] stringArray;
            String string = this.input.readLine();
            if (string == null) {
                throw new IIOException("Unexpeced end of stream");
            }
            int n3 = string.indexOf(35);
            if (n3 >= 0) {
                stringArray = string.substring(n3 + 1).trim();
                if (!stringArray.isEmpty()) {
                    arrayList.add((String)stringArray);
                }
                string = string.substring(0, n3);
            }
            if ((string = string.trim()).isEmpty()) continue;
            for (String string2 : stringArray = string.split("\\s")) {
                if (n == 0) {
                    n = Integer.parseInt(string2);
                    continue;
                }
                if (n2 == 0) {
                    n2 = Integer.parseInt(string2);
                    continue;
                }
                if (f == 0.0f) {
                    f = Float.parseFloat(string2);
                    continue;
                }
                throw new IIOException("Unknown PNM token: " + string2);
            }
        }
        return new PNMHeader(this.fileType, this.tupleType, n, n2, this.tupleType.getSamplesPerPixel(), this.byteOrder(f), arrayList);
    }

    private ByteOrder byteOrder(float f) {
        return f > 0.0f ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }
}

