/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dcx;

import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class DCXHeader {
    private final int[] offsetTable;

    DCXHeader(int[] nArray) {
        this.offsetTable = nArray;
    }

    public int getCount() {
        return this.offsetTable.length;
    }

    public long getOffset(int n) {
        return 0xFFFFFFFFL & (long)this.offsetTable[n];
    }

    public static DCXHeader read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n != 987654321) {
            throw new IIOException(String.format("Not a DCX file. Expected DCX magic %02x, read %02x", 987654321, n));
        }
        int[] nArray = new int[1024];
        int n2 = 0;
        do {
            nArray[n2] = imageInputStream.readInt();
        } while (nArray[++n2 - 1] != 0 && n2 < nArray.length);
        return new DCXHeader(n2 == nArray.length ? nArray : Arrays.copyOf(nArray, n2));
    }

    public String toString() {
        return "DCXHeader{offsetTable=" + Arrays.toString(this.offsetTable) + '}';
    }
}

