/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.Frame;
import com.twelvemonkeys.imageio.plugins.jpeg.HuffmanTable;
import com.twelvemonkeys.imageio.plugins.jpeg.QuantizationTable;
import com.twelvemonkeys.imageio.plugins.jpeg.RestartInterval;
import com.twelvemonkeys.imageio.plugins.jpeg.Scan;
import com.twelvemonkeys.imageio.plugins.jpeg.Segment;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class JPEGLosslessDecoder {
    private final ImageInputStream input;
    private final Frame frame;
    private final HuffmanTable huffTable;
    private final QuantizationTable quantTable;
    private Scan scan;
    private final int[][][] HuffTab = new int[4][2][12800];
    private final int[] IDCT_Source = new int[64];
    private final int[] nBlock = new int[10];
    private final int[][] acTab = new int[10][];
    private final int[][] dcTab = new int[10][];
    private final int[][] qTab = new int[10][];
    private boolean restarting;
    private int marker;
    private int markerIndex;
    private int numComp;
    private int restartInterval;
    private int selection;
    private int xDim;
    private int yDim;
    private int xLoc;
    private int yLoc;
    private int mask;
    private int[] outputData;
    private int[] outputRedData;
    private int[] outputGreenData;
    private int[] outputBlueData;
    private static final int[] IDCT_P = new int[]{0, 5, 40, 16, 45, 2, 7, 42, 21, 56, 8, 61, 18, 47, 1, 4, 41, 23, 58, 13, 32, 24, 37, 10, 63, 17, 44, 3, 6, 43, 20, 57, 15, 34, 29, 48, 53, 26, 39, 9, 60, 19, 46, 22, 59, 12, 33, 31, 50, 55, 25, 36, 11, 62, 14, 35, 28, 49, 52, 27, 38, 30, 51, 54};
    private static final int[] TABLE = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private static final int RESTART_MARKER_BEGIN = 65488;
    private static final int RESTART_MARKER_END = 65495;
    private static final int MAX_HUFFMAN_SUBTREE = 50;
    private static final int MSB = Integer.MIN_VALUE;

    int getDimX() {
        return this.xDim;
    }

    int getDimY() {
        return this.yDim;
    }

    JPEGLosslessDecoder(List<Segment> list, ImageInputStream imageInputStream) {
        Validate.notNull(list);
        this.frame = this.get(list, Frame.class);
        this.scan = this.get(list, Scan.class);
        QuantizationTable quantizationTable = this.get(list, QuantizationTable.class);
        this.quantTable = quantizationTable != null ? quantizationTable : new QuantizationTable();
        this.huffTable = this.get(list, HuffmanTable.class);
        RestartInterval restartInterval = this.get(list, RestartInterval.class);
        this.restartInterval = restartInterval != null ? restartInterval.interval : 0;
        this.input = imageInputStream;
    }

    private <T> T get(List<Segment> list, Class<T> clazz) {
        for (Segment segment : list) {
            if (!clazz.isInstance(segment)) continue;
            return clazz.cast(segment);
        }
        return null;
    }

    int[][] decode() throws IOException {
        int[][] nArrayArray;
        int n = 0;
        int[] nArray = new int[10];
        this.xLoc = 0;
        this.yLoc = 0;
        int n2 = this.input.readUnsignedShort();
        if (n2 != 65496) {
            throw new IIOException("Not a JPEG file");
        }
        this.huffTable.buildHuffTables(this.HuffTab);
        this.quantTable.enhanceTables(TABLE);
        n2 = this.input.readUnsignedShort();
        while (true) {
            Object object;
            if (n2 != 65498) {
                this.input.skipBytes(this.input.readUnsignedShort() - 2);
                n2 = this.input.readUnsignedShort();
                continue;
            }
            int n3 = this.frame.samplePrecision;
            this.mask = n3 == 8 ? 255 : 65535;
            Frame.Component[] componentArray = this.frame.components;
            this.scan = this.readScan();
            this.numComp = this.scan.components.length;
            this.selection = this.scan.spectralSelStart;
            Scan.Component[] componentArray2 = this.scan.components;
            int[][] nArray2 = this.quantTable.quantTables;
            for (int i = 0; i < this.numComp; ++i) {
                object = this.getComponentSpec(componentArray, componentArray2[i].scanCompSel);
                this.qTab[i] = nArray2[((Frame.Component)object).qtSel];
                this.nBlock[i] = ((Frame.Component)object).vSub * ((Frame.Component)object).hSub;
                this.dcTab[i] = this.HuffTab[componentArray2[i].dcTabSel][0];
                this.acTab[i] = this.HuffTab[componentArray2[i].acTabSel][1];
            }
            this.xDim = this.frame.samplesPerLine;
            this.yDim = this.frame.lines;
            nArrayArray = new int[this.numComp][];
            if (this.numComp == 1) {
                this.outputData = new int[this.xDim * this.yDim];
                nArrayArray[0] = this.outputData;
            } else {
                this.outputRedData = new int[this.xDim * this.yDim];
                this.outputGreenData = new int[this.xDim * this.yDim];
                this.outputBlueData = new int[this.xDim * this.yDim];
                nArrayArray[0] = this.outputRedData;
                nArrayArray[1] = this.outputGreenData;
                nArrayArray[2] = this.outputBlueData;
            }
            ++n;
            do {
                int n4;
                int[] nArray3 = new int[1];
                object = new int[1];
                nArray3[0] = 0;
                object[0] = false;
                for (n4 = 0; n4 < 10; ++n4) {
                    nArray[n4] = 1 << n3 - 1;
                }
                if (this.restartInterval == 0) {
                    n2 = this.decode(nArray, nArray3, (int[])object);
                    while (n2 == 0 && this.xLoc < this.xDim && this.yLoc < this.yDim) {
                        this.output(nArray);
                        n2 = this.decode(nArray, nArray3, (int[])object);
                    }
                    break;
                }
                for (n4 = 0; n4 < this.restartInterval; ++n4) {
                    this.restarting = n4 == 0;
                    n2 = this.decode(nArray, nArray3, (int[])object);
                    this.output(nArray);
                    if (n2 != 0) break;
                }
                if (n2 != 0) continue;
                if (this.markerIndex != 0) {
                    n2 = 0xFF00 | this.marker;
                    this.markerIndex = 0;
                    continue;
                }
                n2 = this.input.readUnsignedShort();
            } while (n2 >= 65488 && n2 <= 65495);
            if (n2 == 65500 && n == 1) {
                this.readNumber();
                n2 = this.input.readUnsignedShort();
            }
            if (n2 == 65497 || this.xLoc >= this.xDim || this.yLoc >= this.yDim || n != 0) break;
        }
        return nArrayArray;
    }

    private Frame.Component getComponentSpec(Frame.Component[] componentArray, int n) {
        for (Frame.Component component : componentArray) {
            if (component.id != n) continue;
            return component;
        }
        throw new IllegalArgumentException("No such component id: " + n);
    }

    private Scan readScan() throws IOException {
        int n = this.input.readUnsignedShort();
        return Scan.read(this.input, n);
    }

    private int decode(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        if (this.numComp == 1) {
            return this.decodeSingle(nArray, nArray2, nArray3);
        }
        if (this.numComp == 3) {
            return this.decodeRGB(nArray, nArray2, nArray3);
        }
        return -1;
    }

    private int decodeSingle(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        if (this.restarting) {
            this.restarting = false;
            nArray[0] = 1 << this.frame.samplePrecision - 1;
        } else {
            switch (this.selection) {
                case 2: {
                    nArray[0] = this.getPreviousY(this.outputData);
                    break;
                }
                case 3: {
                    nArray[0] = this.getPreviousXY(this.outputData);
                    break;
                }
                case 4: {
                    nArray[0] = this.getPreviousX(this.outputData) + this.getPreviousY(this.outputData) - this.getPreviousXY(this.outputData);
                    break;
                }
                case 5: {
                    nArray[0] = this.getPreviousX(this.outputData) + (this.getPreviousY(this.outputData) - this.getPreviousXY(this.outputData) >> 1);
                    break;
                }
                case 6: {
                    nArray[0] = this.getPreviousY(this.outputData) + (this.getPreviousX(this.outputData) - this.getPreviousXY(this.outputData) >> 1);
                    break;
                }
                case 7: {
                    nArray[0] = (int)(((long)this.getPreviousX(this.outputData) + (long)this.getPreviousY(this.outputData)) / 2L);
                    break;
                }
                default: {
                    nArray[0] = this.getPreviousX(this.outputData);
                }
            }
        }
        for (int i = 0; i < this.nBlock[0]; ++i) {
            int n = this.getHuffmanValue(this.dcTab[0], nArray2, nArray3);
            if (n >= 65280) {
                return n;
            }
            int n2 = this.getn(nArray, n, nArray2, nArray3);
            int n3 = n2 >> 8;
            if (n3 >= 65488 && n3 <= 65495) {
                return n3;
            }
            nArray[0] = nArray[0] + n2;
        }
        return 0;
    }

    private int decodeRGB(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        switch (this.selection) {
            case 2: {
                nArray[0] = this.getPreviousY(this.outputRedData);
                nArray[1] = this.getPreviousY(this.outputGreenData);
                nArray[2] = this.getPreviousY(this.outputBlueData);
                break;
            }
            case 3: {
                nArray[0] = this.getPreviousXY(this.outputRedData);
                nArray[1] = this.getPreviousXY(this.outputGreenData);
                nArray[2] = this.getPreviousXY(this.outputBlueData);
                break;
            }
            case 4: {
                nArray[0] = this.getPreviousX(this.outputRedData) + this.getPreviousY(this.outputRedData) - this.getPreviousXY(this.outputRedData);
                nArray[1] = this.getPreviousX(this.outputGreenData) + this.getPreviousY(this.outputGreenData) - this.getPreviousXY(this.outputGreenData);
                nArray[2] = this.getPreviousX(this.outputBlueData) + this.getPreviousY(this.outputBlueData) - this.getPreviousXY(this.outputBlueData);
                break;
            }
            case 5: {
                nArray[0] = this.getPreviousX(this.outputRedData) + (this.getPreviousY(this.outputRedData) - this.getPreviousXY(this.outputRedData) >> 1);
                nArray[1] = this.getPreviousX(this.outputGreenData) + (this.getPreviousY(this.outputGreenData) - this.getPreviousXY(this.outputGreenData) >> 1);
                nArray[2] = this.getPreviousX(this.outputBlueData) + (this.getPreviousY(this.outputBlueData) - this.getPreviousXY(this.outputBlueData) >> 1);
                break;
            }
            case 6: {
                nArray[0] = this.getPreviousY(this.outputRedData) + (this.getPreviousX(this.outputRedData) - this.getPreviousXY(this.outputRedData) >> 1);
                nArray[1] = this.getPreviousY(this.outputGreenData) + (this.getPreviousX(this.outputGreenData) - this.getPreviousXY(this.outputGreenData) >> 1);
                nArray[2] = this.getPreviousY(this.outputBlueData) + (this.getPreviousX(this.outputBlueData) - this.getPreviousXY(this.outputBlueData) >> 1);
                break;
            }
            case 7: {
                nArray[0] = (int)(((long)this.getPreviousX(this.outputRedData) + (long)this.getPreviousY(this.outputRedData)) / 2L);
                nArray[1] = (int)(((long)this.getPreviousX(this.outputGreenData) + (long)this.getPreviousY(this.outputGreenData)) / 2L);
                nArray[2] = (int)(((long)this.getPreviousX(this.outputBlueData) + (long)this.getPreviousY(this.outputBlueData)) / 2L);
                break;
            }
            default: {
                nArray[0] = this.getPreviousX(this.outputRedData);
                nArray[1] = this.getPreviousX(this.outputGreenData);
                nArray[2] = this.getPreviousX(this.outputBlueData);
            }
        }
        for (int i = 0; i < this.numComp; ++i) {
            int[] nArray4 = this.qTab[i];
            int[] nArray5 = this.acTab[i];
            int[] nArray6 = this.dcTab[i];
            block9: for (int j = 0; j < this.nBlock[i]; ++j) {
                int n;
                for (n = 0; n < this.IDCT_Source.length; ++n) {
                    this.IDCT_Source[n] = 0;
                }
                int n2 = this.getHuffmanValue(nArray6, nArray2, nArray3);
                if (n2 >= 65280) {
                    return n2;
                }
                nArray[i] = this.IDCT_Source[0] = nArray[i] + this.getn(nArray3, n2, nArray2, nArray3);
                this.IDCT_Source[0] = this.IDCT_Source[0] * nArray4[0];
                for (n = 1; n < 64; ++n) {
                    n2 = this.getHuffmanValue(nArray5, nArray2, nArray3);
                    if (n2 >= 65280) {
                        return n2;
                    }
                    n += n2 >> 4;
                    if ((n2 & 0xF) == 0) {
                        if (n2 >> 4 != 0) continue;
                        continue block9;
                    }
                    this.IDCT_Source[JPEGLosslessDecoder.IDCT_P[n]] = this.getn(nArray3, n2 & 0xF, nArray2, nArray3) * nArray4[n];
                }
            }
        }
        return 0;
    }

    private int getHuffmanValue(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        int n;
        if (nArray3[0] < 8) {
            nArray2[0] = nArray2[0] << 8;
            n = this.input.readUnsignedByte();
            if (n == 255) {
                this.marker = this.input.readUnsignedByte();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n;
        } else {
            nArray3[0] = nArray3[0] - 8;
        }
        int n2 = nArray[nArray2[0] >> nArray3[0]];
        if ((n2 & Integer.MIN_VALUE) != 0) {
            if (this.markerIndex != 0) {
                this.markerIndex = 0;
                return 0xFF00 | this.marker;
            }
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
            nArray2[0] = nArray2[0] << 8;
            n = this.input.readUnsignedByte();
            if (n == 255) {
                this.marker = this.input.readUnsignedByte();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n;
            n2 = nArray[(n2 & 0xFF) * 256 + (nArray2[0] >> nArray3[0])];
            nArray3[0] = nArray3[0] + 8;
        }
        nArray3[0] = nArray3[0] + (8 - (n2 >> 8));
        if (nArray3[0] < 0) {
            throw new IIOException("index=" + nArray3[0] + " temp=" + nArray2[0] + " code=" + n2 + " in HuffmanValue()");
        }
        if (nArray3[0] < this.markerIndex) {
            this.markerIndex = 0;
            return 0xFF00 | this.marker;
        }
        nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        return n2 & 0xFF;
    }

    private int getn(int[] nArray, int n, int[] nArray2, int[] nArray3) throws IOException {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (n == 16) {
            if (nArray[0] >= 0) {
                return Short.MIN_VALUE;
            }
            return 32768;
        }
        nArray3[0] = nArray3[0] - n;
        if (nArray3[0] >= 0) {
            if (nArray3[0] < this.markerIndex && !this.isLastPixel()) {
                this.markerIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            n2 = nArray2[0] >> nArray3[0];
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        } else {
            nArray2[0] = nArray2[0] << 8;
            int n3 = this.input.readUnsignedByte();
            if (n3 == 255) {
                this.marker = this.input.readUnsignedByte();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n3;
            nArray3[0] = nArray3[0] + 8;
            if (nArray3[0] < 0) {
                if (this.markerIndex != 0) {
                    this.markerIndex = 0;
                    return (0xFF00 | this.marker) << 8;
                }
                nArray2[0] = nArray2[0] << 8;
                n3 = this.input.readUnsignedByte();
                if (n3 == 255) {
                    this.marker = this.input.readUnsignedByte();
                    if (this.marker != 0) {
                        this.markerIndex = 9;
                    }
                }
                nArray2[0] = nArray2[0] | n3;
                nArray3[0] = nArray3[0] + 8;
            }
            if (nArray3[0] < 0) {
                throw new IOException("index=" + nArray3[0] + " in getn()");
            }
            if (nArray3[0] < this.markerIndex) {
                this.markerIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            n2 = nArray2[0] >> nArray3[0];
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        }
        if (n2 < 1 << n - 1) {
            n2 += (-1 << n) + 1;
        }
        return n2;
    }

    private int getPreviousX(int[] nArray) {
        if (this.xLoc > 0) {
            return nArray[this.yLoc * this.xDim + this.xLoc - 1];
        }
        if (this.yLoc > 0) {
            return this.getPreviousY(nArray);
        }
        return 1 << this.frame.samplePrecision - 1;
    }

    private int getPreviousXY(int[] nArray) {
        if (this.xLoc > 0 && this.yLoc > 0) {
            return nArray[(this.yLoc - 1) * this.xDim + this.xLoc - 1];
        }
        return this.getPreviousY(nArray);
    }

    private int getPreviousY(int[] nArray) {
        if (this.yLoc > 0) {
            return nArray[(this.yLoc - 1) * this.xDim + this.xLoc];
        }
        return this.getPreviousX(nArray);
    }

    private boolean isLastPixel() {
        return this.xLoc == this.xDim - 1 && this.yLoc == this.yDim - 1;
    }

    private void output(int[] nArray) {
        if (this.numComp == 1) {
            this.outputSingle(nArray);
        } else {
            this.outputRGB(nArray);
        }
    }

    private void outputSingle(int[] nArray) {
        if (this.xLoc < this.xDim && this.yLoc < this.yDim) {
            this.outputData[this.yLoc * this.xDim + this.xLoc] = this.mask & nArray[0];
            ++this.xLoc;
            if (this.xLoc >= this.xDim) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void outputRGB(int[] nArray) {
        if (this.xLoc < this.xDim && this.yLoc < this.yDim) {
            this.outputRedData[this.yLoc * this.xDim + this.xLoc] = nArray[0];
            this.outputGreenData[this.yLoc * this.xDim + this.xLoc] = nArray[1];
            this.outputBlueData[this.yLoc * this.xDim + this.xLoc] = nArray[2];
            ++this.xLoc;
            if (this.xLoc >= this.xDim) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private int readNumber() throws IOException {
        int n = this.input.readUnsignedShort();
        if (n != 4) {
            throw new IOException("ERROR: Define number format throw new IOException [Ld!=4]");
        }
        return this.input.readUnsignedShort();
    }

    int getNumComponents() {
        return this.numComp;
    }

    int getPrecision() {
        return this.frame.samplePrecision;
    }
}

