/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.AbstractMultiPaletteChunk;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.BODYChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.CMAPChunk;
import com.twelvemonkeys.imageio.plugins.iff.DGBLChunk;
import com.twelvemonkeys.imageio.plugins.iff.DLOCChunk;
import com.twelvemonkeys.imageio.plugins.iff.DPELChunk;
import com.twelvemonkeys.imageio.plugins.iff.GRABChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.imageio.plugins.iff.PCHGChunk;
import com.twelvemonkeys.imageio.plugins.iff.XS24Chunk;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;

abstract class Form {
    final int formType;
    final List<GenericChunk> meta = new ArrayList<GenericChunk>();

    Form(int n) {
        this.formType = n;
    }

    abstract int width();

    abstract int height();

    abstract float aspect();

    abstract int bitplanes();

    abstract int compressionType();

    boolean isMultiPalette() {
        return false;
    }

    boolean isHAM() {
        return false;
    }

    public boolean premultiplied() {
        return false;
    }

    public int sampleSize() {
        return 1;
    }

    public int transparentIndex() {
        return -1;
    }

    public IndexColorModel colorMap() throws IIOException {
        return null;
    }

    public ColorModel colorMapForRow(IndexColorModel indexColorModel, int n) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasThumbnail();

    public abstract int thumbnailWidth();

    public abstract int thumbnailHeight();

    public abstract BufferedImage thumbnail();

    abstract long bodyOffset();

    abstract long bodyLength();

    public String toString() {
        return IFFUtil.toChunkStr(this.formType);
    }

    Form with(IFFChunk iFFChunk) throws IIOException {
        if (iFFChunk instanceof GenericChunk) {
            this.meta.add((GenericChunk)iFFChunk);
            return this;
        }
        throw new IllegalArgumentException(iFFChunk + " not supported in FORM type " + IFFUtil.toChunkStr(this.formType));
    }

    static Form ofType(int n) {
        switch (n) {
            case 1094926925: 
            case 1229734477: 
            case 1346522400: 
            case 1380401720: {
                return new ILBMForm(n);
            }
            case 0x44454550: 
            case 1414942800: {
                return new DEEPForm(n);
            }
        }
        throw new IllegalArgumentException("FORM type " + IFFUtil.toChunkStr(n) + " not supported");
    }

    private static final class DEEPForm
    extends Form {
        private final DGBLChunk deepGlobal;
        private final DLOCChunk deepLocation;
        private final DPELChunk deepPixel;
        private final XS24Chunk thumbnail;
        private final BODYChunk body;

        DEEPForm(int n) {
            this(n, null, null, null, null, null);
        }

        private DEEPForm(int n, DGBLChunk dGBLChunk, DLOCChunk dLOCChunk, DPELChunk dPELChunk, XS24Chunk xS24Chunk, BODYChunk bODYChunk) {
            super(n);
            this.deepGlobal = dGBLChunk;
            this.deepLocation = dLOCChunk;
            this.deepPixel = dPELChunk;
            this.thumbnail = xS24Chunk;
            this.body = bODYChunk;
        }

        @Override
        int width() {
            return this.deepLocation.width;
        }

        @Override
        int height() {
            return this.deepLocation.height;
        }

        @Override
        int bitplanes() {
            return this.deepPixel.bitsPerPixel();
        }

        @Override
        public int sampleSize() {
            return this.bitplanes() / 8;
        }

        @Override
        public boolean premultiplied() {
            return true;
        }

        @Override
        int compressionType() {
            return this.deepGlobal.compressionType;
        }

        @Override
        float aspect() {
            return this.deepGlobal.yAspect == 0 ? 0.0f : (float)this.deepGlobal.xAspect / (float)this.deepGlobal.yAspect;
        }

        @Override
        public boolean hasThumbnail() {
            return this.thumbnail != null;
        }

        @Override
        public int thumbnailWidth() {
            return this.thumbnail != null ? this.thumbnail.width : -1;
        }

        @Override
        public int thumbnailHeight() {
            return this.thumbnail != null ? this.thumbnail.height : -1;
        }

        @Override
        public BufferedImage thumbnail() {
            return this.thumbnail != null ? this.thumbnail.thumbnail() : null;
        }

        @Override
        long bodyOffset() {
            return this.body.chunkOffset;
        }

        @Override
        long bodyLength() {
            return this.body.chunkLength;
        }

        @Override
        DEEPForm with(IFFChunk iFFChunk) throws IIOException {
            if (iFFChunk instanceof DGBLChunk) {
                if (this.deepGlobal != null) {
                    throw new IIOException("Multiple DGBL chunks not allowed");
                }
                return new DEEPForm(this.formType, (DGBLChunk)iFFChunk, null, null, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof DLOCChunk) {
                if (this.deepLocation != null) {
                    throw new IIOException("Multiple DLOC chunks not allowed");
                }
                return new DEEPForm(this.formType, this.deepGlobal, (DLOCChunk)iFFChunk, this.deepPixel, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof DPELChunk) {
                if (this.deepPixel != null) {
                    throw new IIOException("Multiple DPEL chunks not allowed");
                }
                return new DEEPForm(this.formType, this.deepGlobal, this.deepLocation, (DPELChunk)iFFChunk, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof XS24Chunk) {
                if (this.thumbnail != null) {
                    throw new IIOException("Multiple XS24 chunks not allowed");
                }
                return new DEEPForm(this.formType, this.deepGlobal, this.deepLocation, this.deepPixel, (XS24Chunk)iFFChunk, this.body);
            }
            if (iFFChunk instanceof BODYChunk) {
                return new DEEPForm(this.formType, this.deepGlobal, this.deepLocation, this.deepPixel, this.thumbnail, (BODYChunk)iFFChunk);
            }
            return (DEEPForm)super.with(iFFChunk);
        }

        @Override
        public String toString() {
            return super.toString() + '{' + this.deepGlobal + ", " + this.deepLocation + ", " + this.deepPixel + '}';
        }
    }

    static final class ILBMForm
    extends Form {
        private final BMHDChunk bitmapHeader;
        private final CAMGChunk viewMode;
        private final CMAPChunk colorMap;
        private final AbstractMultiPaletteChunk multiPalette;
        private final XS24Chunk thumbnail;
        private final BODYChunk body;

        ILBMForm(int n) {
            this(n, null, null, null, null, null, null);
        }

        private ILBMForm(int n, BMHDChunk bMHDChunk, CAMGChunk cAMGChunk, CMAPChunk cMAPChunk, AbstractMultiPaletteChunk abstractMultiPaletteChunk, XS24Chunk xS24Chunk, BODYChunk bODYChunk) {
            super(n);
            this.bitmapHeader = bMHDChunk;
            this.viewMode = cAMGChunk;
            this.colorMap = cMAPChunk;
            this.multiPalette = abstractMultiPaletteChunk;
            this.thumbnail = xS24Chunk;
            this.body = bODYChunk;
        }

        @Override
        int width() {
            return this.bitmapHeader.width;
        }

        @Override
        int height() {
            return this.bitmapHeader.height;
        }

        @Override
        int bitplanes() {
            return this.bitmapHeader.bitplanes;
        }

        @Override
        int compressionType() {
            return this.bitmapHeader.compressionType;
        }

        @Override
        float aspect() {
            return this.bitmapHeader.yAspect == 0 ? 0.0f : (float)this.bitmapHeader.xAspect / (float)this.bitmapHeader.yAspect;
        }

        @Override
        boolean isMultiPalette() {
            return this.multiPalette != null;
        }

        boolean isEHB() {
            return this.viewMode != null && this.viewMode.isEHB();
        }

        @Override
        boolean isHAM() {
            return this.viewMode != null && this.viewMode.isHAM();
        }

        boolean isLaced() {
            return this.viewMode != null && this.viewMode.isLaced();
        }

        @Override
        public int transparentIndex() {
            return this.bitmapHeader.maskType == 2 ? this.bitmapHeader.transparentIndex : -1;
        }

        @Override
        public IndexColorModel colorMap() throws IIOException {
            return this.colorMap != null ? this.colorMap.getIndexColorModel(this) : null;
        }

        @Override
        public ColorModel colorMapForRow(IndexColorModel indexColorModel, int n) {
            return this.multiPalette != null ? this.multiPalette.getColorModel(indexColorModel, n, this.isLaced()) : null;
        }

        @Override
        public boolean hasThumbnail() {
            return this.thumbnail != null;
        }

        @Override
        public int thumbnailWidth() {
            return this.thumbnail != null ? this.thumbnail.width : -1;
        }

        @Override
        public int thumbnailHeight() {
            return this.thumbnail != null ? this.thumbnail.height : -1;
        }

        @Override
        public BufferedImage thumbnail() {
            return this.thumbnail != null ? this.thumbnail.thumbnail() : null;
        }

        @Override
        long bodyOffset() {
            return this.body.chunkOffset;
        }

        @Override
        long bodyLength() {
            return this.body.chunkLength;
        }

        @Override
        ILBMForm with(IFFChunk iFFChunk) throws IIOException {
            if (iFFChunk instanceof BMHDChunk) {
                if (this.bitmapHeader != null) {
                    throw new IIOException("Multiple BMHD chunks not allowed");
                }
                return new ILBMForm(this.formType, (BMHDChunk)iFFChunk, null, this.colorMap, this.multiPalette, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof CAMGChunk) {
                if (this.viewMode != null) {
                    throw new IIOException("Multiple CAMG chunks not allowed");
                }
                return new ILBMForm(this.formType, this.bitmapHeader, (CAMGChunk)iFFChunk, this.colorMap, this.multiPalette, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof CMAPChunk) {
                if (this.colorMap != null) {
                    throw new IIOException("Multiple CMAP chunks not allowed");
                }
                return new ILBMForm(this.formType, this.bitmapHeader, this.viewMode, (CMAPChunk)iFFChunk, this.multiPalette, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof AbstractMultiPaletteChunk) {
                if (this.multiPalette instanceof PCHGChunk) {
                    if (iFFChunk instanceof PCHGChunk) {
                        throw new IIOException("Multiple PCHG/SHAM/CTBL chunks not allowed");
                    }
                    return this;
                }
                return new ILBMForm(this.formType, this.bitmapHeader, this.viewMode, this.colorMap, (AbstractMultiPaletteChunk)iFFChunk, this.thumbnail, this.body);
            }
            if (iFFChunk instanceof XS24Chunk) {
                if (this.thumbnail != null) {
                    throw new IIOException("Multiple XS24 chunks not allowed");
                }
                return new ILBMForm(this.formType, this.bitmapHeader, this.viewMode, this.colorMap, this.multiPalette, (XS24Chunk)iFFChunk, this.body);
            }
            if (iFFChunk instanceof BODYChunk) {
                if (this.body != null) {
                    throw new IIOException("Multiple " + IFFUtil.toChunkStr(iFFChunk.chunkId) + " chunks not allowed");
                }
                return new ILBMForm(this.formType, this.bitmapHeader, this.viewMode, this.colorMap, this.multiPalette, this.thumbnail, (BODYChunk)iFFChunk);
            }
            if (iFFChunk instanceof GRABChunk) {
                return this;
            }
            return (ILBMForm)super.with(iFFChunk);
        }

        @Override
        public String toString() {
            return super.toString() + '{' + this.bitmapHeader + (this.viewMode != null ? ", " + this.viewMode : "") + (this.colorMap != null ? ", " + this.colorMap : "") + (this.multiPalette != null ? ", " + this.multiPalette : "") + '}';
        }
    }
}

