/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.plugins.iff.MultiPalette;
import com.twelvemonkeys.imageio.plugins.iff.MutableIndexColorModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;

abstract class AbstractMultiPaletteChunk
extends IFFChunk
implements MultiPalette {
    static final int FACTOR_4BIT = 17;
    protected MutableIndexColorModel.PaletteChange[] initialChanges;
    protected MutableIndexColorModel.PaletteChange[][] changes;
    protected int lastRow;
    protected WeakReference<IndexColorModel> originalPalette;
    protected MutableIndexColorModel mutablePalette;

    public AbstractMultiPaletteChunk(int n, int n2) {
        super(n, n2);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        if (this.chunkId == 1397244237) {
            dataInput.readUnsignedShort();
        }
        int n = this.chunkLength / 32;
        this.changes = new MutableIndexColorModel.PaletteChange[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            this.changes[i] = new MutableIndexColorModel.PaletteChange[16];
            for (n2 = 0; n2 < 16; ++n2) {
                this.changes[i][n2] = new MutableIndexColorModel.PaletteChange();
            }
            for (n2 = 0; n2 < 16; ++n2) {
                int n3 = dataInput.readUnsignedShort();
                this.changes[i][n2].index = n2;
                this.changes[i][n2].r = (byte)(((n3 & 0xF00) >> 8) * 17);
                this.changes[i][n2].g = (byte)(((n3 & 0xF0) >> 4) * 17);
                this.changes[i][n2].b = (byte)((n3 & 0xF) * 17);
            }
        }
    }

    @Override
    void writeChunk(DataOutput dataOutput) {
        throw new UnsupportedOperationException("Method writeChunk not implemented");
    }

    @Override
    public ColorModel getColorModel(IndexColorModel indexColorModel, int n, boolean bl) {
        if (n < this.lastRow || this.mutablePalette == null || this.originalPalette != null && this.originalPalette.get() != indexColorModel) {
            this.originalPalette = new WeakReference<IndexColorModel>(indexColorModel);
            this.mutablePalette = new MutableIndexColorModel(indexColorModel);
            if (this.initialChanges != null) {
                this.mutablePalette.adjustColorMap(this.initialChanges);
            }
        }
        for (int i = this.lastRow + 1; i <= n; ++i) {
            int n2;
            if (bl && this.skipLaced()) {
                if (i % 2 != 0) continue;
                n2 = i / 2;
            } else {
                n2 = i;
            }
            if (n2 >= this.changes.length || this.changes[n2] == null) continue;
            this.mutablePalette.adjustColorMap(this.changes[n2]);
        }
        return this.mutablePalette;
    }

    protected boolean skipLaced() {
        return false;
    }
}

